/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RunAsLocalWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -53489817846332331L;
    private final PhpProjectProperties properties;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final String displayName;
    final ProjectCustomizer.Category category;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JTextArea hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsLocalWeb(PhpProjectProperties phpProjectProperties, ConfigManager configManager, ProjectCustomizer.Category category) {
        super(configManager);
        this.properties = phpProjectProperties;
        this.category = category;
        this.project = phpProjectProperties.getProject();
        this.displayName = NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_ConfigLocalWeb");
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.indexFileLabel, this.argsLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.indexFileTextField, this.argsTextField};
        this.propertyNames = new String[]{"url", "index.file", "script.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater fieldUpdater = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(fieldUpdater);
        }
    }

    protected boolean isDefault() {
        return true;
    }

    protected PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.LOCAL;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
    }

    protected void validateFields() {
        String string = this.urlTextField.getText();
        String string2 = this.indexFileTextField.getText();
        String string3 = this.argsTextField.getText();
        String string4 = RunAsValidator.validateWebFields(string, FileUtil.toFile((FileObject)this.getWebRoot()), string2, string3);
        this.category.setErrorMessage(string4);
        this.category.setValid(true);
    }

    private FileObject getWebRoot() {
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, this.properties.getWebRoot());
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.hintLabel = new JTextArea();
        this.setFocusTraversalPolicy(null);
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_ProjectUrl"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RunAsLocalWeb.this.indexFileBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsLocalWeb.class, (String)"LBL_Arguments"));
        this.hintLabel.setEditable(false);
        this.hintLabel.setLineWrap(true);
        this.hintLabel.setRows(2);
        this.hintLabel.setWrapStyleWord(true);
        this.hintLabel.setBorder(null);
        this.hintLabel.setDisabledTextColor(UIManager.getDefaults().getColor("Label.disabledForeground"));
        this.hintLabel.setEnabled(false);
        this.hintLabel.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.argsLabel).add((Component)this.urlLabel).add((Component)this.indexFileLabel).add((Component)this.runAsLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.hintLabel, 0, -1, Short.MAX_VALUE).add(2, (Component)this.argsTextField, -1, 220, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indexFileTextField, -1, 125, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.indexFileBrowseButton)).add(2, (Component)this.runAsCombo, 0, 220, Short.MAX_VALUE).add(2, (Component)this.urlTextField, -1, 220, Short.MAX_VALUE)).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.runAsCombo, -2, -1, -2).add((Component)this.runAsLabel)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.urlLabel).add((Component)this.urlTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.indexFileBrowseButton).add((Component)this.indexFileTextField, -2, -1, -2).add((Component)this.indexFileLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.argsLabel).add((Component)this.argsTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.hintLabel, -2, -1, -2).addContainerGap()));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.runAsCombo.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.argsTextField.AccessibleContext.accessibleDescription"));
        this.hintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.hintLabel.AccessibleContext.accessibleName"));
        this.hintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.hintLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsLocalWeb.class, (String)"RunAsLocalWeb.AccessibleContext.accessibleDescription"));
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent actionEvent) {
        Utils.browseFolderFile(this.getWebRoot(), this.indexFileTextField);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String string, JLabel jLabel, JTextField jTextField) {
            super(RunAsLocalWeb.this, string, jLabel, jTextField);
        }

        protected final String getDefaultValue() {
            return RunAsLocalWeb.this.getDefaultValue(this.getPropName());
        }

        protected void processUpdate() {
            super.processUpdate();
            String string = "";
            try {
                string = RunAsValidator.composeUrlHint(RunAsLocalWeb.this.urlTextField.getText(), RunAsLocalWeb.this.indexFileTextField.getText(), RunAsLocalWeb.this.argsTextField.getText());
            }
            catch (RunAsValidator.InvalidUrlException invalidUrlException) {
                RunAsLocalWeb.this.category.setErrorMessage(invalidUrlException.getMessage());
                RunAsLocalWeb.this.category.setValid(false);
            }
            RunAsLocalWeb.this.hintLabel.setText(string);
        }
    }
}

