/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.net.MalformedURLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.DebugLocalCommand;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.actions.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebugCommand
extends Command
implements Displayable {
    public static final String ID = "debug";
    public static String DISPLAY_NAME = NbBundle.getMessage(DebugCommand.class, (String)"LBL_DebugProject");
    private final DebugLocalCommand debugLocalCommand;

    public DebugCommand(PhpProject phpProject) {
        super(phpProject);
        this.debugLocalCommand = new DebugLocalCommand(phpProject);
    }

    public void invokeAction(Lookup lookup) throws IllegalArgumentException {
        if (!this.isRunConfigurationValid()) {
            return;
        }
        boolean bl = this.isScriptSelected();
        if (bl) {
            this.debugLocalCommand.invokeAction(null);
        } else {
            boolean bl2;
            this.eventuallyUploadFiles();
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DebugCommand.this.showURLForDebugProjectFile();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            };
            boolean bl3 = WebClientToolsSessionStarterService.isAvailable();
            if (bl3 && !(bl2 = WebClientToolsProjectUtils.showDebugDialog((Project)this.getProject()))) {
                return;
            }
            if (!bl3 || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.getProject())) {
                XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
                if (xDebugStarter != null) {
                    if (xDebugStarter.isAlreadyRunning()) {
                        String string = NbBundle.getMessage(DebugCommand.class, (String)"MSG_NoMoreDebugSession");
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                        boolean bl4 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION);
                        if (bl4) {
                            xDebugStarter.stop();
                            this.invokeAction(lookup);
                        }
                    } else {
                        FileObject fileObject = this.fileForProject(true);
                        if (fileObject != null) {
                            this.startDebugger(xDebugStarter, runnable, fileObject, bl);
                        } else {
                            String string = ProjectPropertiesSupport.getIndexFile(this.getProject());
                            String string2 = NbBundle.getMessage(DebugLocalCommand.class, (String)"ERR_Missing_IndexFile", (Object)string);
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            ((CustomizerProviderImpl)this.getProject().getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
                        }
                    }
                }
            } else {
                runnable.run();
            }
        }
    }

    protected void startDebugger(XDebugStarter xDebugStarter, Runnable runnable, FileObject fileObject, boolean bl) {
        Callable<Cancellable> callable = Executors.callable(runnable, new Cancellable(){

            public boolean cancel() {
                return true;
            }
        });
        xDebugStarter.start(this.getProject(), callable, fileObject, bl);
    }

    public boolean isActionEnabled(Lookup lookup) throws IllegalArgumentException {
        return XDebugStarterFactory.getInstance() != null;
    }

    public String getCommandId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

