/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.ui.RemoteConnectionsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteConnections {
    static final Logger LOGGER = Logger.getLogger(RemoteConnections.class.getName());
    private static final String PREFERENCES_PATH = "RemoteConnections";
    private static final RequestProcessor TEST_CONNECTION_RP = new RequestProcessor("Test Remote Connection", 1);
    private static final ConnectionType DEFAULT_TYPE = ConnectionType.FTP;
    private static final int DEFAULT_PORT = 21;
    private static final String DEFAULT_INITIAL_DIRECTORY = "/";
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final int DEFAULT_TIMEOUT = 30;
    static final String TYPE = "type";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String ANONYMOUS_LOGIN = "anonymousLogin";
    static final String INITIAL_DIRECTORY = "initialDirectory";
    static final String PATH_SEPARATOR = "pathSeparator";
    static final String TIMEOUT = "timeout";
    static final String PASSIVE_MODE = "passiveMode";
    static final String[] PROPERTIES = new String[]{"type", "host", "port", "user", "password", "anonymousLogin", "initialDirectory", "pathSeparator", "timeout", "passiveMode"};
    private final ConfigManager configManager;
    private final ConfigManager.ConfigProvider configProvider = new DefaultConfigProvider();
    private final ChangeListener defaultChangeListener = new DefaultChangeListener();
    RemoteConnectionsPanel panel = null;
    private DialogDescriptor descriptor = null;
    private JButton testConnectionButton = null;
    private RequestProcessor.Task testConnectionTask = null;

    public static RemoteConnections get() {
        return new RemoteConnections();
    }

    private RemoteConnections() {
        this.configManager = new ConfigManager(this.configProvider);
    }

    private void initPanel() {
        if (this.panel != null) {
            return;
        }
        this.panel = new RemoteConnectionsPanel();
        this.panel.setConfigurations(this.getConfigurations());
        this.panel.addChangeListener(this.defaultChangeListener);
        this.panel.addAddButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnections.this.addConfig();
            }
        });
        this.panel.addRemoveButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnections.this.removeConfig();
            }
        });
        this.panel.addConfigListListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RemoteConnections.this.selectCurrentConfig();
                RemoteConnections.this.enableTestConnection();
            }
        });
    }

    public boolean openManager() {
        return this.openManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openManager(final RemoteConfiguration remoteConfiguration) {
        boolean bl;
        this.initPanel();
        this.testConnectionButton = new JButton(NbBundle.getMessage(RemoteConnections.class, (String)"LBL_TestConnection"));
        this.testConnectionTask = TEST_CONNECTION_RP.create(new Runnable(){

            public void run() {
                RemoteConnections.this.testConnection();
            }
        }, true);
        this.descriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RemoteConnections.class, (String)"LBL_ManageRemoteConnections"), true, new Object[]{this.testConnectionButton, NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION, 0, null, null);
        this.descriptor.setClosingOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        this.testConnectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteConnections.this.testConnectionTask.schedule(0);
            }
        });
        this.testConnectionTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                RemoteConnections.this.enableTestConnection();
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (RemoteConnections.this.panel.getConfigurations().isEmpty()) {
                        RemoteConnections.this.addConfig();
                    } else if (remoteConfiguration != null) {
                        RemoteConnections.this.panel.selectConfiguration(remoteConfiguration.getName());
                    } else {
                        RemoteConnections.this.panel.selectConfiguration(0);
                    }
                }
            });
            dialog.setVisible(true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        boolean bl2 = bl = this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
        if (bl) {
            this.saveRemoteConnections();
        }
        return bl;
    }

    public List<RemoteConfiguration> getRemoteConfigurations() {
        List<ConfigManager.Configuration> list = this.getConfigurations();
        ArrayList<RemoteConfiguration> arrayList = new ArrayList<RemoteConfiguration>(list.size());
        for (ConfigManager.Configuration configuration : list) {
            arrayList.add(new RemoteConfiguration(configuration));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public RemoteConfiguration remoteConfigurationForName(String string) {
        assert (string != null);
        for (RemoteConfiguration remoteConfiguration : this.getRemoteConfigurations()) {
            if (!remoteConfiguration.getName().equals(string)) continue;
            return remoteConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void testConnection() {
        RemoteException remoteException;
        String string;
        block12: {
            this.testConnectionButton.setEnabled(false);
            ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
            assert (configuration != null);
            string = configuration.getDisplayName();
            String string2 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TestingConnection", (Object)string);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
            RemoteClient remoteClient = new RemoteClient(new RemoteConfiguration(configuration));
            remoteException = null;
            progressHandle.start();
            remoteClient.connect();
            Object var9_7 = null;
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException remoteException2) {
                // empty catch block
            }
            progressHandle.finish();
            {
                break block12;
                catch (RemoteException remoteException3) {
                    remoteException = remoteException3;
                    Object var9_8 = null;
                    try {
                        remoteClient.disconnect();
                    }
                    catch (RemoteException remoteException4) {
                        // empty catch block
                    }
                    progressHandle.finish();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    remoteClient.disconnect();
                }
                catch (RemoteException remoteException5) {
                    // empty catch block
                }
                progressHandle.finish();
                throw throwable;
            }
        }
        String string3 = null;
        int n = 0;
        if (remoteException != null) {
            string3 = remoteException.getRemoteServerAnswer() == null ? remoteException.getMessage() : NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TestConnectionFailed", (Object)remoteException.getMessage(), (Object)remoteException.getRemoteServerAnswer());
            n = 0;
        } else {
            string3 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TestConnectionSucceeded");
            n = 1;
        }
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string3, string, 2, n, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    void enableTestConnection() {
        assert (this.testConnectionButton != null);
        assert (this.testConnectionTask != null);
        assert (this.panel != null);
        this.testConnectionButton.setEnabled(this.testConnectionTask.isFinished() && this.panel.getSelectedConfiguration() != null && this.panel.getSelectedConfiguration().isValid());
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        Collection<String> collection = this.configManager.configurationNames();
        ArrayList<ConfigManager.Configuration> arrayList = new ArrayList<ConfigManager.Configuration>(collection.size() - 1);
        for (String string : collection) {
            ConfigManager.Configuration configuration;
            if (string == null || (configuration = this.configManager.configurationFor(string)) == null) continue;
            arrayList.add(configuration);
        }
        Collections.sort(arrayList, ConfigManager.getConfigurationComparator());
        return arrayList;
    }

    void addConfig() {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(RemoteConnections.class, (String)"LBL_ConnectionName"), NbBundle.getMessage(RemoteConnections.class, (String)"LBL_CreateNewConnection"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            String string2 = string.replaceAll("[^a-zA-Z0-9_.-]", "_");
            String string3 = null;
            if (string.trim().length() == 0) {
                string3 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_EmptyConnectionExists");
            } else if (this.configManager.exists(string2)) {
                string3 = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_ConnectionExists", (Object)string2);
            }
            if (string3 != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
                return;
            }
            ConfigManager.Configuration configuration = this.configManager.createNew(string2, string);
            configuration.putValue(PORT, String.valueOf(21));
            configuration.putValue(INITIAL_DIRECTORY, "/");
            configuration.putValue(PATH_SEPARATOR, "/");
            configuration.putValue(TIMEOUT, String.valueOf(30));
            this.panel.addConfiguration(configuration);
            this.configManager.markAsCurrentConfiguration(string2);
        }
    }

    void removeConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        assert (configuration != null);
        this.configManager.configurationFor(configuration.getName()).delete();
        this.panel.removeConfiguration(configuration);
    }

    void selectCurrentConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        this.panel.removeChangeListener(this.defaultChangeListener);
        this.panel.setEnabledFields(configuration != null);
        if (configuration != null) {
            this.configManager.markAsCurrentConfiguration(configuration.getName());
            this.panel.setConnectionName(configuration.getDisplayName());
            this.panel.setType(this.resolveType(configuration.getValue(TYPE)));
            this.panel.setHostName(configuration.getValue(HOST));
            this.panel.setPort(configuration.getValue(PORT));
            this.panel.setUserName(configuration.getValue(USER));
            this.panel.setPassword(configuration.getValue(PASSWORD, true));
            this.panel.setAnonymousLogin(this.resolveBoolean(configuration.getValue(ANONYMOUS_LOGIN)));
            this.panel.setInitialDirectory(configuration.getValue(INITIAL_DIRECTORY));
            this.panel.setTimeout(configuration.getValue(TIMEOUT));
            this.panel.setPassiveMode(this.resolveBoolean(configuration.getValue(PASSIVE_MODE)));
        } else {
            this.panel.resetFields();
        }
        this.panel.addChangeListener(this.defaultChangeListener);
        if (configuration != null) {
            this.validate();
        }
    }

    void validate() {
        assert (this.panel != null);
        if (this.validateRememberPassword()) {
            this.setWarning(null);
        }
        if (!this.validateHost()) {
            return;
        }
        if (!this.validatePort()) {
            return;
        }
        if (!this.validateUser()) {
            return;
        }
        if (!this.validateInitialDirectory()) {
            return;
        }
        if (!this.validateTimeout()) {
            return;
        }
        this.setError(null);
        this.checkAllTheConfigs();
    }

    private boolean validateHost() {
        if (this.panel.getHostName().trim().length() == 0) {
            this.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_NoHostName"));
            return false;
        }
        return true;
    }

    private boolean validatePort() {
        String string = null;
        try {
            int n = Integer.parseInt(this.panel.getPort());
            if (n < 1) {
                string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PortNotPositive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PortNotNumeric");
        }
        this.setError(string);
        return string == null;
    }

    private boolean validateUser() {
        if (this.panel.isAnonymousLogin()) {
            return true;
        }
        if (this.panel.getUserName().trim().length() == 0) {
            this.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_NoUserName"));
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String string = RunAsValidator.validateUploadDirectory(this.panel.getInitialDirectory(), false);
        if (string != null) {
            this.setError(string);
            return false;
        }
        return true;
    }

    private boolean validateTimeout() {
        String string = null;
        try {
            int n = Integer.parseInt(this.panel.getTimeout());
            if (n < 0) {
                string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TimeoutNotPositive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            string = NbBundle.getMessage(RemoteConnections.class, (String)"MSG_TimeoutNotNumeric");
        }
        this.setError(string);
        return string == null;
    }

    private boolean validateRememberPassword() {
        if (this.panel.getPassword().length() > 0) {
            this.setWarning(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_PasswordRememberDangerous"));
            return false;
        }
        return true;
    }

    private void checkAllTheConfigs() {
        for (ConfigManager.Configuration configuration : this.panel.getConfigurations()) {
            assert (configuration != null);
            if (configuration.isValid()) continue;
            this.panel.setError(NbBundle.getMessage(RemoteConnections.class, (String)"MSG_InvalidConfiguration", (Object)configuration.getDisplayName()));
            assert (this.descriptor != null);
            this.descriptor.setValid(false);
            return;
        }
    }

    private void setError(String string) {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        configuration.setErrorMessage(string);
        this.panel.setError(string);
        assert (this.descriptor != null);
        this.descriptor.setValid(string == null);
        this.enableTestConnection();
    }

    private void setWarning(String string) {
        assert (this.panel != null);
        this.panel.setWarning(string);
    }

    private void updateActiveConfig() {
        assert (this.panel != null);
        ConfigManager.Configuration configuration = this.panel.getSelectedConfiguration();
        if (configuration == null) {
            return;
        }
        configuration.putValue(TYPE, this.panel.getType().name());
        configuration.putValue(HOST, this.panel.getHostName());
        configuration.putValue(PORT, this.panel.getPort());
        configuration.putValue(USER, this.panel.getUserName());
        configuration.putValue(PASSWORD, this.panel.getPassword(), true);
        configuration.putValue(ANONYMOUS_LOGIN, String.valueOf(this.panel.isAnonymousLogin()));
        configuration.putValue(INITIAL_DIRECTORY, this.panel.getInitialDirectory());
        configuration.putValue(PATH_SEPARATOR, "/");
        configuration.putValue(TIMEOUT, this.panel.getTimeout());
        configuration.putValue(PASSIVE_MODE, String.valueOf(this.panel.isPassiveMode()));
    }

    private void saveRemoteConnections() {
        Preferences preferences = NbPreferences.forModule(RemoteConnections.class).node(PREFERENCES_PATH);
        for (Map.Entry<String, Map<String, String>> entry : this.configProvider.getConfigs().entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            Map<String, String> map = entry.getValue();
            if (map == null) {
                try {
                    preferences.node(string).removeNode();
                }
                catch (BackingStoreException backingStoreException) {
                    LOGGER.log(Level.INFO, "Error while removing unused remote connection: " + string, backingStoreException);
                }
                continue;
            }
            Preferences preferences2 = preferences.node(string);
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                preferences2.put(entry2.getKey(), entry2.getValue());
            }
        }
    }

    private ConnectionType resolveType(String string) {
        if (string == null) {
            return DEFAULT_TYPE;
        }
        ConnectionType connectionType = null;
        try {
            connectionType = ConnectionType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            connectionType = DEFAULT_TYPE;
        }
        return connectionType;
    }

    private boolean resolveBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            RemoteConnections.this.updateActiveConfig();
            RemoteConnections.this.validate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigProvider
    implements ConfigManager.ConfigProvider {
        final Map<String, Map<String, String>> configs = ConfigManager.createEmptyConfigs();

        public DefaultConfigProvider() {
            this.readConfigs();
        }

        @Override
        public String[] getConfigProperties() {
            return PROPERTIES;
        }

        @Override
        public Map<String, Map<String, String>> getConfigs() {
            return this.configs;
        }

        @Override
        public String getActiveConfig() {
            return null;
        }

        @Override
        public void setActiveConfig(String string) {
        }

        private void readConfigs() {
            Preferences preferences = NbPreferences.forModule(RemoteConnections.class).node(RemoteConnections.PREFERENCES_PATH);
            try {
                for (String string : preferences.childrenNames()) {
                    Preferences preferences2 = preferences.node(string);
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (String string2 : preferences2.keys()) {
                        treeMap.put(string2, preferences2.get(string2, null));
                    }
                    this.configs.put(string, treeMap);
                }
            }
            catch (BackingStoreException backingStoreException) {
                LOGGER.log(Level.INFO, "Error while reading existing remote connections", backingStoreException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        FTP("LBL_Ftp");

        private final String label;

        private ConnectionType(String string2) {
            this.label = NbBundle.getMessage(RemoteConnections.class, (String)string2);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

