/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Utilities;

public class PhpMimeResolver
extends MIMEResolver {
    private static final int BYTES_FOR_PRECHECK = 255;
    private static final int BYTES_FOR_CHECK_IF_HTML_SIGNED = 4000;
    private static final Sign[] EMPTY_SIGNS = new Sign[0];
    private static final String MIME_TYPE = "text/x-php5";
    private static final String UNKNOWN_MIME_TYPE = null;
    private static final String[] PHP_WELL_KNOWN_EXTENSION_PREFIXES = new String[]{"php", "phtml"};
    private static final String[] OTHER_WELL_KNOWN_EXTENSION_PREFIXES = new String[]{"java", "rb", "rhtml"};
    private static final String[] WELL_KNOWN_WINDOWS_TROUBLE_FILES = new String[]{"ntuser.dat", "ntuser.dat.log"};
    private static final byte[] OPEN_TAG = "<?php".getBytes();
    private static final byte[] SHORT_OPEN_TAG = "<?".getBytes();
    private static final Set<String> resolvedExt = new HashSet<String>();

    public PhpMimeResolver() {
        super(new String[]{MIME_TYPE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findMIMEType(FileObject fileObject) {
        String string = fileObject.getExt();
        if (PhpMimeResolver.isWellKnownPhpExtension(string)) {
            return MIME_TYPE;
        }
        if (PhpMimeResolver.isWellKnownOtherExtension(string)) {
            return UNKNOWN_MIME_TYPE;
        }
        if (resolvedExt.contains(string)) {
            return MIME_TYPE;
        }
        MutableInteger mutableInteger = new MutableInteger();
        MutableInteger mutableInteger2 = new MutableInteger();
        if (!fileObject.canRead()) {
            return UNKNOWN_MIME_TYPE;
        }
        if (Utilities.isWindows() && PhpMimeResolver.existsInArray(fileObject.getNameExt().toLowerCase(), WELL_KNOWN_WINDOWS_TROUBLE_FILES)) {
            return UNKNOWN_MIME_TYPE;
        }
        try {
            InputStream inputStream = fileObject.getInputStream();
            try {
                byte[] byArray = new byte[255];
                int n = inputStream.read(byArray);
                Sign[] signArray = new Sign[]{new Sign("<!DOCTYPE HTML"), new Sign("<!DOCTYPE HTML".toLowerCase()), new Sign("<HTML>"), new Sign("<HTML>".toLowerCase())};
                if (n > 0 && this.resolve(byArray, n, mutableInteger, mutableInteger2, signArray)) {
                    String string2 = this.returnMimeType(fileObject, MIME_TYPE);
                    return string2;
                }
                if (!this.isSigned(signArray)) return this.returnMimeType(fileObject, UNKNOWN_MIME_TYPE);
                byArray = new byte[4000];
                n = inputStream.read(byArray);
                signArray = EMPTY_SIGNS;
                if (n <= 0) return this.returnMimeType(fileObject, UNKNOWN_MIME_TYPE);
                if (!this.resolve(byArray, n, mutableInteger, mutableInteger2, signArray)) return this.returnMimeType(fileObject, UNKNOWN_MIME_TYPE);
                String string3 = this.returnMimeType(fileObject, MIME_TYPE);
                return string3;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(PhpMimeResolver.class.getName()).log(Level.INFO, null, iOException);
            return null;
        }
    }

    private boolean resolve(byte[] byArray, int n, MutableInteger mutableInteger, MutableInteger mutableInteger2, Sign[] signArray) {
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (this.isOpenTag(by, mutableInteger)) {
                return true;
            }
            for (int j = 0; j < signArray.length; ++j) {
                Sign sign = signArray[j];
                sign.check(by);
            }
        }
        return false;
    }

    private boolean isSigned(Sign[] signArray) {
        for (int i = 0; i < signArray.length; ++i) {
            Sign sign = signArray[i];
            if (!sign.isSigned()) continue;
            return true;
        }
        return false;
    }

    public String returnMimeType(FileObject fileObject, String string) {
        String string2 = fileObject.getExt();
        if (string2 != null && string2.trim().length() > 0 && MIME_TYPE.equals(string)) {
            resolvedExt.add(string2);
        }
        return string;
    }

    private static boolean isWellKnownPhpExtension(String string) {
        return PhpMimeResolver.existsInArray(string, PHP_WELL_KNOWN_EXTENSION_PREFIXES);
    }

    private static boolean isWellKnownOtherExtension(String string) {
        return PhpMimeResolver.existsInArray(string, OTHER_WELL_KNOWN_EXTENSION_PREFIXES);
    }

    private static boolean existsInArray(String string, String[] stringArray) {
        if (string != null && string.trim().length() > 0) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOpenTag(byte by, MutableInteger mutableInteger) {
        if (mutableInteger.getValue() < OPEN_TAG.length) {
            if (by == OPEN_TAG[mutableInteger.getValue()]) {
                mutableInteger.incr();
            } else {
                mutableInteger.setValue(0);
            }
        }
        return mutableInteger.getValue() >= OPEN_TAG.length;
    }

    private boolean isShortOpenTag(byte by, MutableInteger mutableInteger) {
        if (mutableInteger.getValue() < SHORT_OPEN_TAG.length && by == SHORT_OPEN_TAG[mutableInteger.getValue()]) {
            mutableInteger.incr();
        } else if (mutableInteger.getValue() >= SHORT_OPEN_TAG.length && Character.isWhitespace((char)by)) {
            mutableInteger.incr();
        } else {
            mutableInteger.setValue(0);
        }
        return mutableInteger.getValue() >= SHORT_OPEN_TAG.length + 1;
    }

    private static class Sign {
        private final byte[] signBytes;
        private int signBytesIdx;

        Sign(String string) {
            this.signBytes = string.getBytes();
        }

        void check(byte by) {
            if (this.signBytesIdx < this.signBytes.length) {
                this.signBytesIdx = by == this.signBytes[this.signBytesIdx] ? ++this.signBytesIdx : 0;
            }
        }

        boolean isSigned() {
            return this.signBytesIdx >= this.signBytes.length;
        }
    }

    private static class MutableInteger {
        private int value = 0;

        private MutableInteger() {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public void incr() {
            ++this.value;
        }
    }
}

