/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.CopyCommand;
import org.netbeans.modules.php.project.ui.actions.DebugCommand;
import org.netbeans.modules.php.project.ui.actions.DebugSingleCommand;
import org.netbeans.modules.php.project.ui.actions.DeleteCommand;
import org.netbeans.modules.php.project.ui.actions.Displayable;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.MoveCommand;
import org.netbeans.modules.php.project.ui.actions.RenameCommand;
import org.netbeans.modules.php.project.ui.actions.RunCommand;
import org.netbeans.modules.php.project.ui.actions.RunSingleCommand;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class PhpActionProvider
implements ActionProvider {
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();

    PhpActionProvider(PhpProject phpProject) {
        Command[] commandArray;
        for (Command command : commandArray = new Command[]{new RunCommand(phpProject), new DebugCommand(phpProject), new RunSingleCommand(phpProject), new DebugSingleCommand(phpProject), new DeleteCommand(phpProject), new CopyCommand(phpProject), new MoveCommand(phpProject), new RenameCommand(phpProject), new DownloadCommand(phpProject), new UploadCommand(phpProject)}) {
            this.commands.put(command.getCommandId(), command);
        }
    }

    public String[] getSupportedActions() {
        Set<String> set = this.commands.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void invokeAction(String string, final Lookup lookup) throws IllegalArgumentException {
        final Command command = this.getCommand(string);
        command.getProject().getCopySupport().waitFinished();
        if (command.saveRequired()) {
            LifecycleManager.getDefault().saveAll();
        }
        if (!command.asyncCallRequired()) {
            command.invokeAction(lookup);
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    command.invokeAction(lookup);
                }
            });
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        return this.getCommand(string).isActionEnabled(lookup);
    }

    public Command getCommand(String string) {
        Command command = this.commands.get(string);
        assert (command != null) : string;
        return command;
    }

    public Action getAction(String string) {
        Command command = this.getCommand(string);
        assert (command != null) : string;
        assert (command instanceof Displayable);
        return ProjectSensitiveActions.projectCommandAction((String)command.getCommandId(), (String)((Displayable)((Object)command)).getDisplayName(), null);
    }
}

