/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midpnb.propertyeditors.table.TableModelEditorElement;
import org.openide.util.NbBundle;

public class PropertyEditorTableModel
extends DesignPropertyEditor
implements PropertyEditorResourceElementListener {
    private WeakReference<DesignComponent> component;
    private JPanel customEditorPanel;
    private TableModelEditorElement customEditor;
    private PropertyValue values;
    private PropertyValue headers;

    private PropertyEditorTableModel() {
        this.initComponents();
    }

    public static PropertyEditorTableModel createInstance() {
        return new PropertyEditorTableModel();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.clean(designComponent);
            this.customEditor = null;
        }
        this.values = null;
        this.headers = null;
        if (this.customEditorPanel == null) {
            this.customEditorPanel.removeAll();
        }
        this.component = null;
    }

    private void initComponents() {
        this.customEditor = new TableModelEditorElement();
        this.customEditor.addPropertyEditorResourceElementListener(this);
        this.customEditorPanel = new JPanel(new BorderLayout());
        this.customEditorPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.customEditorPanel.add((Component)((Object)this.customEditor), "Center");
    }

    public void init(DesignComponent designComponent) {
        if (designComponent != null) {
            this.component = new WeakReference<DesignComponent>(designComponent);
        }
    }

    public Component getCustomEditor() {
        if (this.component != null && this.component.get() != null) {
            this.customEditor.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.customEditor.setAllEnabled(true);
        return this.customEditorPanel;
    }

    public Boolean canEditAsText() {
        return Boolean.FALSE;
    }

    public String getAsText() {
        return NbBundle.getMessage(PropertyEditorTableModel.class, (String)"DISP_PE_TableModel_GetAsText");
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.headers != null) {
            designComponent.writeProperty("columnNames", this.headers);
        }
        if (this.values != null) {
            designComponent.writeProperty("values", this.values);
        }
        return false;
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return true;
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void elementChanged(PropertyEditorResourceElementEvent propertyEditorResourceElementEvent) {
        PropertyValue propertyValue = propertyEditorResourceElementEvent.getPropertyValue();
        String string = propertyEditorResourceElementEvent.getPropertyName();
        if ("columnNames".equals(string)) {
            this.headers = propertyValue;
        } else if ("values".equals(string)) {
            this.values = propertyValue;
        } else {
            throw Debug.illegalArgument((Object[])new Object[]{"Illegal property value has been passed"});
        }
    }

    public boolean isDefaultValue() {
        if (this.component == null || this.component.get() == null) {
            return true;
        }
        final boolean[] blArray = new boolean[]{true};
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = (DesignComponent)PropertyEditorTableModel.this.component.get();
                boolean bl = PropertyValue.createNull().equals(designComponent.readProperty("columnNames"));
                boolean bl2 = PropertyValue.createNull().equals(designComponent.readProperty("values"));
                blArray[0] = bl && bl2;
            }
        });
        return blArray[0];
    }

    public boolean isResetToDefaultAutomatically() {
        return false;
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (this.component != null && this.component.get() != null) {
            DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.writeProperty("columnNames", PropertyValue.createNull());
            designComponent.writeProperty("values", PropertyValue.createNull());
        }
    }
}

