/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.microedition.m2g.SVGImage;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormFileObjectListener;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;

public class SVGFormFileChangePresneter
extends DynamicPresenter
implements DesignDocumentAwareness {
    private WeakReference<FileObject> svgFileObject;
    private SVGFormFileObjectListener imageFileListener;
    private boolean isInit;
    private DataObjectContext context;

    protected void notifyAttached(DesignComponent designComponent) {
    }

    protected void notifyDetached(DesignComponent designComponent) {
        this.removeListener();
    }

    private void init() {
        DesignComponent designComponent = this.getComponent().readProperty("svgImage").getComponent();
        if (designComponent == null) {
            return;
        }
        PropertyValue propertyValue = designComponent.readProperty("resourcePath");
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            FileObject fileObject;
            Map map = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)this.getComponent().getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
            Iterator iterator = map.keySet().iterator();
            FileObject fileObject2 = fileObject = iterator.hasNext() ? (FileObject)iterator.next() : null;
            if (fileObject != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SVGFormFileObjectListener.regenerateSVGComponentsStructure(fileObject, SVGFormFileChangePresneter.this.getComponent(), DataEditorView.Kind.CODE);
                        SVGFormFileChangePresneter.this.context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)SVGFormFileChangePresneter.this.getComponent().getDocument());
                        SVGFormFileChangePresneter.this.context.addDesignDocumentAwareness((DesignDocumentAwareness)SVGFormFileChangePresneter.this);
                    }
                });
            }
        }
    }

    protected DesignEventFilter getEventFilter() {
        return new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true);
    }

    protected void designChanged(DesignEvent designEvent) {
        DesignComponent designComponent = this.getComponent().readProperty("svgImage").getComponent();
        if (designEvent.isComponentPropertyChanged(designComponent, "resourcePath") || designEvent.isComponentPropertyChanged(this.getComponent(), "svgImage")) {
            this.checkSVGComponent();
            if (!this.isInit) {
                this.isInit = true;
                this.init();
            }
        }
    }

    private void checkSVGComponent() {
        DesignComponent designComponent;
        FileObject fileObject = null;
        if (this.svgFileObject != null && this.svgFileObject.get() != null) {
            fileObject = (FileObject)this.svgFileObject.get();
        }
        if (fileObject != null) {
            fileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
            this.imageFileListener = null;
        }
        if ((designComponent = this.getComponent().readProperty("svgImage").getComponent()) == null) {
            return;
        }
        FileObject fileObject2 = SVGFormSupport.getSVGFile(designComponent);
        if (fileObject2 != null) {
            try {
                SVGImage sVGImage = Util.createSVGImage((FileObject)fileObject2, (boolean)true);
                if (sVGImage != null) {
                    this.imageFileListener = new SVGFormFileObjectListener(this.getComponent(), designComponent, "resourcePath");
                    fileObject2.addFileChangeListener((FileChangeListener)this.imageFileListener);
                    ActiveViewSupport.getDefault().addActiveViewListener((ActiveViewSupport.Listener)this.imageFileListener);
                    this.svgFileObject = new WeakReference<FileObject>(fileObject2);
                }
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
        }
    }

    protected void presenterChanged(PresenterEvent presenterEvent) {
    }

    public void setDesignDocument(DesignDocument designDocument) {
        if (designDocument != null) {
            return;
        }
        if (this.context != null) {
            this.context.removeDesignDocumentAwareness((DesignDocumentAwareness)this);
        }
        this.removeListener();
    }

    private void removeListener() {
        if (this.svgFileObject == null || this.svgFileObject.get() == null) {
            return;
        }
        FileObject fileObject = (FileObject)this.svgFileObject.get();
        if (fileObject != null) {
            fileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        ActiveViewSupport.getDefault().removeActiveViewListener((ActiveViewSupport.Listener)this.imageFileListener);
        this.imageFileListener = null;
        this.svgFileObject = null;
    }
}

