/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.options.ContextOptionsListener;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.options.ContextSystemOption;
import org.openide.text.PrintSettings;
import org.openide.util.HelpCtx;

public class BasePrintOptions
extends OptionSupport {
    public static final String BASE = "base";
    public static final String PRINT_PREFIX = "print_";
    public static final String PRINT_COLORING_MAP_PROP = "printColoringMap";
    private static final String HELP_ID = "editing.fontsandcolors";
    static final String[] BASE_PROP_NAMES = new String[]{"printColoringMap"};
    static final long serialVersionUID = 7740651671176408299L;

    public BasePrintOptions() {
        this(BaseKit.class, BASE);
    }

    public BasePrintOptions(Class clazz, String string) {
        super(clazz, string);
    }

    public String displayName() {
        String string;
        try {
            string = this.getString("OPTIONS_print_" + this.getTypeName());
        }
        catch (Throwable throwable) {
            string = super.displayName();
        }
        return string;
    }

    public void init() {
        this.refreshContextListeners();
    }

    private void refreshContextListeners() {
        PrintSettings printSettings = (PrintSettings)PrintSettings.findObject(PrintSettings.class, (boolean)true);
        ContextOptionsListener.processExistingAndListen((ContextSystemOption)printSettings);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-print-options-initalizer";
    }

    public boolean getPrintLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setPrintLineNumberVisible(boolean bl) {
    }

    public Map getPrintColoringMap() {
        Map<String, Coloring> map = SettingsUtil.getColoringMap(this.getKitClass(), true, true);
        map.put(null, (Coloring)this.getKitClass().getName());
        return map;
    }

    public void setPrintColoringMap(Map map) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }
}

