/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.vertexitemeditor;

import java.awt.Component;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.MetalTextFieldBorder;
import org.netbeans.modules.soa.mappercore.vertexitemeditor.AbstractTextVertexItemEditor;

public class NumberVertexItemEditor
extends AbstractTextVertexItemEditor {
    private static final String FILTER_CHARS = "0123456789+-eE.";

    public NumberVertexItemEditor() {
        MetalTextFieldBorder.installIfItIsNeeded(this);
        this.setHorizontalAlignment(4);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new NumberDocumentFilter());
    }

    public Component getVertexItemEditorComponent(Mapper mapper, TreePath treePath, VertexItem vertexItem) {
        Number number = NumberVertexItemEditor.toNumber(vertexItem.getValue());
        this.setText(number == null ? "" : number.toString());
        return this;
    }

    public Object getVertexItemEditorValue() {
        return NumberVertexItemEditor.toNumber(this.getText());
    }

    private static String filterString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (FILTER_CHARS.indexOf(c) < 0) continue;
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private static Number toNumber(Object object) {
        String string;
        Number number = null;
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object != null && (string = object.toString()) != null) {
            try {
                number = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number == null) {
                try {
                    number = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return number;
    }

    private static class NumberDocumentFilter
    extends DocumentFilter {
        private NumberDocumentFilter() {
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            string = NumberVertexItemEditor.filterString(string);
            super.replace(filterBypass, n, n2, string, attributeSet);
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            string = NumberVertexItemEditor.filterString(string);
            super.insertString(filterBypass, n, string, attributeSet);
        }
    }
}

