/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Function;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSubset {
    private TreePath treePath;
    private Graph graph;
    private Vertex[] verteces;
    private Link[] links;
    private Vertex minXVertex;
    private Vertex minYVertex;
    private static final Vertex[] EMPTY_VERTECES = new Vertex[0];
    private static final Link[] EMPTY_LINKS = new Link[0];

    public GraphSubset(Vertex vertex) {
        this.treePath = null;
        this.graph = null;
        if (vertex != null) {
            this.verteces = new Vertex[]{vertex};
            this.minXVertex = vertex;
            this.minYVertex = vertex;
        } else {
            this.verteces = EMPTY_VERTECES;
        }
        this.links = EMPTY_LINKS;
    }

    public GraphSubset(TreePath treePath, Graph graph, List<Vertex> list) {
        this(treePath, graph, list, null);
    }

    public GraphSubset(TreePath treePath, Graph graph, List<Vertex> list, List<Link> list2) {
        this.treePath = treePath;
        this.graph = graph;
        this.verteces = list != null && !list.isEmpty() ? list.toArray(new Vertex[list.size()]) : EMPTY_VERTECES;
        Link[] linkArray = this.links = list2 != null && !list2.isEmpty() ? list2.toArray(new Link[list2.size()]) : EMPTY_LINKS;
        if (list != null && !list.isEmpty()) {
            Vertex vertex;
            int n;
            this.minXVertex = list.get(0);
            for (n = list.size() - 1; n > 0; --n) {
                vertex = list.get(n);
                if (this.minXVertex.getX() <= vertex.getX()) continue;
                this.minXVertex = vertex;
            }
            this.minYVertex = list.get(0);
            for (n = list.size() - 1; n > 0; --n) {
                vertex = list.get(n);
                if (this.minYVertex.getY() <= vertex.getY()) continue;
                this.minYVertex = vertex;
            }
        }
    }

    public GraphSubset(GraphSubset graphSubset) {
        this(graphSubset, graphSubset.getTreePath());
    }

    public GraphSubset(GraphSubset graphSubset, TreePath treePath) {
        int n;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        ArrayList<Link> arrayList2 = new ArrayList<Link>();
        for (n = 0; n < graphSubset.getVertexCount(); ++n) {
            arrayList.add(this.createVertex(graphSubset.getVertex(n)));
        }
        for (n = 0; n < graphSubset.getLinkCount(); ++n) {
            Link link = this.createLink(graphSubset.getLink(n), arrayList, graphSubset);
            if (link == null) continue;
            arrayList2.add(link);
        }
        this.treePath = treePath;
        this.graph = graphSubset.getGraph();
        this.verteces = arrayList != null && !arrayList.isEmpty() ? arrayList.toArray(new Vertex[arrayList.size()]) : EMPTY_VERTECES;
        this.links = arrayList2 != null && !arrayList2.isEmpty() ? arrayList2.toArray(new Link[arrayList2.size()]) : EMPTY_LINKS;
        this.minXVertex = graphSubset.getMinXVertex();
        this.minYVertex = graphSubset.getMinYVertex();
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public int getVertexCount() {
        return this.verteces.length;
    }

    public Vertex getVertex(int n) {
        return this.verteces[n];
    }

    public int getLinkCount() {
        return this.links.length;
    }

    public Link getLink(int n) {
        return this.links[n];
    }

    public boolean isEmpty() {
        return this.links.length == 0 && this.verteces.length == 0;
    }

    public boolean containVertex(Vertex vertex) {
        int n;
        for (int i = n = this.verteces.length - 1; i >= 0; --i) {
            if (this.verteces[i] != vertex) continue;
            return true;
        }
        return false;
    }

    public Vertex getMinXVertex() {
        return this.minXVertex;
    }

    public Vertex getMinYVertex() {
        return this.minYVertex;
    }

    private int ingexOf(Vertex vertex) {
        int n = this.verteces.length;
        for (int i = 0; i < n; ++i) {
            if (this.verteces[i] != vertex) continue;
            return i;
        }
        return -1;
    }

    private Vertex createVertex(Vertex vertex) {
        Object object;
        Vertex vertex2 = null;
        if (vertex instanceof Constant) {
            vertex2 = new Constant(vertex.getDataObject(), vertex.getIcon());
        }
        if (vertex instanceof Operation) {
            vertex2 = new Operation(vertex.getDataObject(), vertex.getIcon());
        }
        if (vertex instanceof Function) {
            String string = ((Function)vertex).getName();
            object = ((Function)vertex).getResultText();
            vertex2 = new Function(vertex.getDataObject(), vertex.getIcon(), string, (String)object);
        }
        for (int i = 0; i < vertex.getItemCount(); ++i) {
            object = vertex.getItem(i);
            new VertexItem(vertex2, ((VertexItem)object).getDataObject(), ((VertexItem)object).getValue(), ((VertexItem)object).getValueType(), ((VertexItem)object).getShortDescription(), ((VertexItem)object).isHairline());
            vertex2.addItem(new VertexItem(vertex2, ((VertexItem)object).getDataObject(), ((VertexItem)object).getValue(), ((VertexItem)object).getValueType(), ((VertexItem)object).getShortDescription(), ((VertexItem)object).isHairline()));
        }
        vertex2.setLocation(vertex.getX(), vertex.getY());
        vertex2.setWidth(vertex.getWidth());
        vertex2.setHeight(vertex.getHeight());
        vertex2.setResultText(vertex.getResultText());
        return vertex2;
    }

    private Link createLink(Link link, List<Vertex> list, GraphSubset graphSubset) {
        TargetPin targetPin = link.getTarget();
        SourcePin sourcePin = link.getSource();
        VertexItem vertexItem = null;
        SourcePin sourcePin2 = null;
        if (sourcePin instanceof TreeSourcePin) {
            sourcePin2 = sourcePin;
        }
        if (sourcePin instanceof Vertex) {
            int n = graphSubset.ingexOf((Vertex)sourcePin);
            sourcePin2 = n < 0 ? null : (SourcePin)list.get(n);
        }
        if (targetPin instanceof Graph) {
            vertexItem = null;
        }
        if (targetPin instanceof VertexItem) {
            VertexItem vertexItem2 = (VertexItem)targetPin;
            int n = graphSubset.ingexOf(vertexItem2.getVertex());
            int n2 = vertexItem2.getVertex().getItemIndex(vertexItem2);
            vertexItem = n < 0 ? null : list.get(n).getItem(n2);
        }
        if (sourcePin2 != null && vertexItem != null) {
            return new Link(sourcePin2, vertexItem);
        }
        return null;
    }
}

