/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.graphics;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Triangle
implements Shape {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;

    public Triangle(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.x3 = d5;
        this.y3 = d6;
    }

    public Rectangle getBounds() {
        int n = (int)Math.floor(this.getMinX());
        int n2 = (int)Math.floor(this.getMinY());
        return new Rectangle(n, n2, (int)Math.ceil(this.getMaxX()) - n, (int)Math.ceil(this.getMaxX()) - n2);
    }

    public Rectangle2D getBounds2D() {
        double d = this.getMinX();
        double d2 = this.getMinY();
        return new Rectangle2D.Double(d, d2, this.getMaxX() - d, this.getMaxY() - d2);
    }

    public double getMinX() {
        return Math.min(this.x1, Math.min(this.x2, this.x3));
    }

    public double getMinY() {
        return Math.min(this.y1, Math.min(this.y2, this.y3));
    }

    public double getMaxX() {
        return Math.max(this.x1, Math.max(this.x2, this.x3));
    }

    public double getMaxY() {
        return Math.max(this.y1, Math.max(this.y2, this.y3));
    }

    public boolean contains(double d, double d2) {
        d -= this.x1;
        d2 -= this.y1;
        double d3 = this.x2 - this.x1;
        double d4 = this.y2 - this.y1;
        double d5 = this.x3 - this.x1;
        double d6 = this.x3 - this.y1;
        if (d < Math.min(d3, d5)) {
            return false;
        }
        if (d2 < Math.min(d4, d6)) {
            return false;
        }
        if (d > Math.max(d3, d5)) {
            return false;
        }
        if (d2 > Math.max(d4, d6)) {
            return false;
        }
        double d7 = d3 * d6 - d5 * d4;
        double d8 = d5 * d2 - d6 * d;
        double d9 = d3 * d2 - d4 * d;
        double d10 = -d8 / d7;
        double d11 = d9 / d7;
        return 0.0 <= d10 && 0.0 <= d11 && d10 + d11 <= 1.0;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.getMaxX() < d) {
            return false;
        }
        if (this.getMaxY() < d2) {
            return false;
        }
        if (d + d3 < this.getMinX()) {
            return false;
        }
        return !(d2 + d4 < this.getMinY());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d + d3;
        double d6 = d2 + d4;
        return this.contains(d, d2) && this.contains(d5, d6) && this.contains(d5, d2) && this.contains(d, d6);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new TriangePathIterator(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    private static class TriangePathIterator
    implements PathIterator {
        private double[] coords;
        private int index = 0;

        public TriangePathIterator(double d, double d2, double d3, double d4, double d5, double d6, AffineTransform affineTransform) {
            this.coords = new double[]{d, d2, d3, d4, d5, d6};
            if (affineTransform != null) {
                affineTransform.transform(this.coords, 0, this.coords, 0, 3);
            }
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 6;
        }

        public void next() {
            this.index += 2;
        }

        public int currentSegment(float[] fArray) {
            if (this.index < 6) {
                fArray[0] = (float)this.coords[this.index];
                fArray[1] = (float)this.coords[this.index + 1];
                return this.index == 0 ? 0 : 1;
            }
            return 4;
        }

        public int currentSegment(double[] dArray) {
            if (this.index < 6) {
                dArray[0] = this.coords[this.index];
                dArray[1] = this.coords[this.index + 1];
                return this.index == 0 ? 0 : 1;
            }
            return 4;
        }
    }
}

