/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.AbstractMapperEventHandler;
import org.netbeans.modules.soa.mappercore.AutoScrollSelectionRightTree;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;

public class RightTreeEventHandler
extends AbstractMapperEventHandler {
    private MouseEvent initialEvent = null;
    private TreePath initialPath = null;
    private Graph initialTargetGraph = null;

    public RightTreeEventHandler(RightTree rightTree) {
        super(rightTree.getMapper(), rightTree);
        new AutoScrollSelectionRightTree(rightTree);
    }

    private void reset() {
        this.initialEvent = null;
        this.initialPath = null;
        this.initialTargetGraph = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.reset();
        this.initialEvent = mouseEvent;
        Mapper mapper = this.getMapper();
        RightTree rightTree = this.getRightTree();
        if (!rightTree.hasFocus()) {
            rightTree.requestFocusInWindow();
        }
        int n = mouseEvent.getY();
        int n2 = mouseEvent.getX();
        MapperNode mapperNode = this.getNodeAt(n);
        boolean bl = true;
        if (mapperNode != null) {
            n = mapperNode.yToNode(n);
            int n3 = rightTree.getWidth();
            int n4 = mapperNode.getIndent();
            int n5 = mapperNode.getContentHeight();
            int n6 = mapperNode.getHeight();
            int n7 = mapperNode.getContentCenterY();
            int n8 = n3 - n4 + mapper.getRightIndent();
            boolean bl2 = false;
            if (!mapperNode.isLeaf()) {
                if (Math.abs(n8 - n2) <= 8 && Math.abs(n7 - n) <= 8) {
                    bl2 = true;
                } else if (mapperNode.isCollapsed() && n5 < n6) {
                    int n9 = n3 - n4 - mapper.getTotalIndent();
                    Dimension dimension = rightTree.getChildrenLabel().getPreferredSize();
                    int n10 = n9 - dimension.width;
                    int n11 = n6 - 2;
                    int n12 = n5 + 1;
                    boolean bl3 = bl2 = n10 <= n2 && n2 < n9 && n12 <= n && n < n11;
                }
            }
            if (bl2) {
                mapper.switchCollapsedExpandedState(mapperNode);
                bl = false;
            } else if (n2 < n3 - n4) {
                mapper.setSelectedNode(mapperNode);
                if (mouseEvent.isPopupTrigger()) {
                    bl = false;
                    this.showPopupMenu(mouseEvent);
                }
            }
            this.initialTargetGraph = mapperNode.getGraph();
            this.initialPath = mapperNode.getTreePath();
        }
        if (!bl || this.initialTargetGraph == null || this.initialPath == null) {
            this.reset();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
        if (mouseEvent.isPopupTrigger() && this.getMapper().getNodeAt(mouseEvent.getY()) != null) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.initialEvent != null && this.initialEvent.getPoint().distance(mouseEvent.getPoint()) >= 5.0) {
            LinkTool linkTool = this.getMapper().getLinkTool();
            Transferable transferable = null;
            Link link = null;
            for (int i = this.initialTargetGraph.getLinkCount() - 1; i >= 0; --i) {
                if (!(this.initialTargetGraph.getLink(i).getTarget() instanceof Graph)) continue;
                link = this.initialTargetGraph.getLink(i);
            }
            if (link != null) {
                if (link.getSource() instanceof TreeSourcePin) {
                    TreeSourcePin treeSourcePin = (TreeSourcePin)link.getSource();
                    transferable = linkTool.activateOutgoing(treeSourcePin, link, this.initialPath);
                }
                if (link.getSource() instanceof Vertex && this.getMapper().getNode(this.initialPath, true).isGraphExpanded()) {
                    Vertex vertex = (Vertex)link.getSource();
                    transferable = linkTool.activateOutgoing(this.initialPath, vertex);
                }
            } else {
                transferable = linkTool.activateIngoing(this.initialPath, this.initialTargetGraph, null);
            }
            if (transferable != null) {
                this.startDrag(this.initialEvent, transferable, 2);
            }
            this.reset();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        Mapper mapper = this.getMapper();
        MapperNode mapperNode = mapper.getNodeAt(n);
        if (mapperNode != null && mouseEvent.getClickCount() == 2 && !mapperNode.isLeaf()) {
            mapper.setExpandedState(mapperNode.getTreePath(), mapperNode.isCollapsed());
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        MapperContext mapperContext = this.getMapper().getContext();
        MapperModel mapperModel = this.getMapper().getModel();
        if (mapperContext == null || mapperModel == null) {
            return;
        }
        TreePath treePath = this.getSelectionModel().getSelectedPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return;
        }
        JPopupMenu jPopupMenu = mapperContext.getRightPopupMenu(mapperModel, object);
        if (jPopupMenu != null) {
            jPopupMenu.show(this.getRightTree(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

