/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.source;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteFactory;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.palette.PaletteController;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class SVGSourceMultiViewElement
extends XmlMultiViewElement {
    private static final long serialVersionUID = 7525761714575627761L;

    public SVGSourceMultiViewElement(SVGDataObject sVGDataObject) {
        super((XmlMultiViewDataObject)sVGDataObject);
    }

    public Lookup getLookup() {
        try {
            PaletteController paletteController = SVGPaletteFactory.getPalette();
            return new ProxyLookup(new Lookup[]{this.dObj.getNodeDelegate().getLookup(), Lookups.singleton((Object)paletteController), Lookups.singleton((Object)new SelectionCookie(){

                public void updateSelection(SVGDataObject sVGDataObject, String string, int n, boolean bl) {
                    SVGSourceMultiViewElement.selectElement(sVGDataObject, n, bl);
                }
            })});
        }
        catch (IOException iOException) {
            SceneManager.error("Lookup creation failed", iOException);
            return super.getLookup();
        }
    }

    public void componentHidden() {
        ((SVGDataObject)this.dObj).setMultiViewElement(null);
        super.componentHidden();
    }

    public void componentOpened() {
        super.componentOpened();
        ((SVGDataObject)this.dObj).getModel().attachToOpenedDocument();
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(0);
        ((SVGDataObject)this.dObj).setMultiViewElement((MultiViewElement)this);
    }

    public static void selectElement(SVGDataObject sVGDataObject, int n, boolean bl) {
        if (n != -1) {
            SVGSourceMultiViewElement.selectPosition(sVGDataObject, n, bl);
        }
    }

    public static void selectPosition(final SVGDataObject sVGDataObject, final int n, final boolean bl) {
        SVGSourceMultiViewElement.openFileInEditor(sVGDataObject);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorCookie editorCookie = (EditorCookie)sVGDataObject.getCookie(EditorCookie.class);
                try {
                    if (editorCookie != null) {
                        editorCookie.openDocument();
                        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                        if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                            TopComponent topComponent;
                            JEditorPane jEditorPane = jEditorPaneArray[0];
                            jEditorPane.setSelectionStart(n);
                            jEditorPane.setSelectionEnd(n);
                            if (bl && (topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane)) != null) {
                                topComponent.requestActive();
                                topComponent.requestFocus();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    SceneManager.error("Select in editor failed.", exception);
                }
            }
        });
    }

    private static boolean openFileInEditor(SVGDataObject sVGDataObject) {
        EditCookie editCookie = (EditCookie)sVGDataObject.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)sVGDataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }
}

