/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataLoader;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SVGPaletteItemDataObject
extends MultiDataObject {
    private final SVGPaletteItemData m_data;

    public SVGPaletteItemDataObject(FileObject fileObject, SVGPaletteItemDataLoader sVGPaletteItemDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)sVGPaletteItemDataLoader);
        this.m_data = SVGPaletteItemData.get(fileObject);
    }

    public SVGPaletteItemData getData() {
        return this.m_data;
    }

    public File getReferencedFile() throws FileNotFoundException, IOException {
        return new File(this.m_data.getFilePath());
    }

    protected Node createNodeDelegate() {
        return new SVGPaletteItemDataNode(this, this.getLookup());
    }

    public Lookup getLookup() {
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new ActiveEditorDrop(){

            public boolean handleTransfer(JTextComponent jTextComponent) {
                SVGDataObject sVGDataObject = SVGDataObject.getActiveDataObject(jTextComponent);
                if (sVGDataObject != null) {
                    try {
                        File file = SVGPaletteItemDataObject.this.getReferencedFile();
                        if (file.exists() && file.isFile()) {
                            SceneManager.log(Level.INFO, "Dropping file " + file.getPath());
                            SVGPaletteItemDataObject.insert(sVGDataObject.getModel().getSVGBody(file, null), jTextComponent);
                            return true;
                        }
                        SceneManager.log(Level.SEVERE, "Nothing to drop, file " + file + " not found");
                    }
                    catch (Exception exception) {
                        SceneManager.error("Error during image merge", exception);
                    }
                } else {
                    SceneManager.log(Level.INFO, "SVGDataObject not found.");
                }
                return false;
            }
        });
        instanceContent.add((Object)this);
        return new AbstractLookup((AbstractLookup.Content)instanceContent);
    }

    private static void insert(String string, JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)document;
            Formatter formatter = baseDocument.getFormatter();
            try {
                baseDocument.atomicLock();
                Caret caret = jTextComponent.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                document.remove(n, n2 - n);
                int n3 = caret.getDot();
                document.insertString(n3, string, null);
                int n4 = n3 + string.length();
                formatter.reformatLock();
                formatter.reformat(baseDocument, n3, n4);
                formatter.reformatUnlock();
                baseDocument.atomicUnlock();
            }
            catch (Exception exception) {
                formatter.reformatUnlock();
                baseDocument.atomicUndo();
            }
        }
    }
}

