/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.text.ActiveEditorDrop;

public abstract class SVGComponentDrop
implements ActiveEditorDrop {
    protected static final String PATTERN = "%%";
    private static final String X_COORDINATE_PATTERN = "%%COORDINATE_X%%";
    private static final String Y_COORDINATE_PATTERN = "%%COORDINATE_Y%%";
    private SVGDataObject mySvgDataObject;
    private float[] myPoint;

    protected abstract boolean doTransfer();

    public static SVGComponentDrop getDefault(String string) {
        return new Default(string);
    }

    public boolean handleTransfer(SVGDataObject sVGDataObject, float[] fArray) {
        if (sVGDataObject == null) {
            SceneManager.log(Level.INFO, "SVGDataObject not found.");
            return false;
        }
        this.mySvgDataObject = sVGDataObject;
        this.myPoint = fArray;
        return this.doTransfer();
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        return false;
    }

    protected void setSelection(String string) {
        if (this.getSVGDataObject() != null) {
            this.getSVGDataObject().getSceneManager().setSelection(string, true);
        }
    }

    protected SVGDataObject getSVGDataObject() {
        return this.mySvgDataObject;
    }

    protected String replaceCoordinates(String string) {
        return string.replace(X_COORDINATE_PATTERN, String.valueOf(this.myPoint[0])).replace(Y_COORDINATE_PATTERN, String.valueOf(this.myPoint[1]));
    }

    private static class Default
    extends SVGComponentDrop {
        private String mySnippet;

        public Default(String string) {
            this.mySnippet = string;
        }

        protected boolean doTransfer() {
            try {
                if (this.mySnippet != null) {
                    String string = this.replaceCoordinates(this.mySnippet);
                    String string2 = this.getSVGDataObject().getModel().mergeImage(string, false);
                    this.setSelection(string2);
                }
                return true;
            }
            catch (Exception exception) {
                SceneManager.error("Error during image merge", exception);
                return false;
            }
        }
    }
}

