/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.util.ImageUtilities;

public final class SkewActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor SKEW_MOUSE_CURSOR = new ActionMouseCursor(Toolkit.getDefaultToolkit().createCustomCursor(ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/skew_cursor.png"), new Point(8, 8), "skewCursor"), 3);

    public SkewActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToSkewAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new SkewAction(sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        if (!bl && this.getObjectToSkewAt(mouseEvent) != null) {
            return SKEW_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getObjectToSkewAt(MouseEvent mouseEvent) {
        SVGObject sVGObject;
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0 && (sVGObject = sVGObjectArray[0]).getOutline().isAtSkewHandlePoint(mouseEvent.getX(), mouseEvent.getY())) {
            return sVGObject;
        }
        return null;
    }

    private final class SkewAction
    extends AbstractComposerAction {
        private final SVGObject m_skewed;
        private final int m_initialX;
        private final int m_initialY;

        public SkewAction(SVGObject sVGObject, MouseEvent mouseEvent) {
            super(SkewActionFactory.this);
            this.m_skewed = sVGObject;
            this.m_initialX = mouseEvent.getX();
            this.m_initialY = mouseEvent.getY();
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                double d;
                int n;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_skewed.getScreenBBox();
                float f = 0.0f;
                float f2 = 0.0f;
                if (rectangle.height > 0 && (n = mouseEvent.getX() - this.m_initialX) != 0) {
                    d = Math.atan((double)n / (double)rectangle.height);
                    f = (float)Math.toDegrees(d);
                }
                if (rectangle.width > 0 && (n = this.m_initialY - mouseEvent.getY()) != 0) {
                    d = Math.atan((double)n / (double)rectangle.width);
                    f2 = (float)Math.toDegrees(d);
                }
                this.m_skewed.skew(f, f2);
                rectangle.add(this.m_skewed.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else {
                this.actionCompleted();
                this.m_skewed.commitChanges();
            }
            return false;
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : SKEW_MOUSE_CURSOR;
        }

        public void actionCompleted() {
            this.m_skewed.repaint(5);
            this.m_skewed.applyTextChanges();
            this.m_skewed.commitChanges();
            super.actionCompleted();
        }
    }
}

