/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GameDesignTreeNodeRenderer
implements TreeCellRenderer {
    private static ImageIcon imgGame = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/game/integration/res/gamer_16.png"));
    private static ImageIcon imgSprite = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/game/model/adapter/res/sprite.png"));
    private static ImageIcon imgTiled = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/game/model/adapter/res/tiled.png"));
    private static ImageIcon imgScene = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/game/model/adapter/res/scene.png"));

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof Scene) {
            return new SceneNodeRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        if (object instanceof TiledLayer) {
            return new TiledLayerNodeRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        if (object instanceof Sprite) {
            return new SpriteNodeRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        if (object instanceof GlobalRepository) {
            return new GlobalRepositoryNodeRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        return new DefaultTreeCellRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    private class SpriteNodeRenderer
    extends DefaultTreeCellRenderer {
        private SpriteNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Sprite sprite = (Sprite)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setText(sprite.getName());
            defaultTreeCellRenderer.setIcon(imgSprite);
            defaultTreeCellRenderer.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.SpriteNode.tooltip", (Object)sprite.getName()));
            return defaultTreeCellRenderer;
        }
    }

    private class TiledLayerNodeRenderer
    extends DefaultTreeCellRenderer {
        private TiledLayerNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TiledLayer tiledLayer = (TiledLayer)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setText(tiledLayer.getName());
            defaultTreeCellRenderer.setIcon(imgTiled);
            defaultTreeCellRenderer.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.TiledLayerNode.tooltip", (Object)tiledLayer.getName()));
            return defaultTreeCellRenderer;
        }
    }

    private class SceneNodeRenderer
    extends DefaultTreeCellRenderer {
        private SceneNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Scene scene = (Scene)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setText(scene.getName());
            defaultTreeCellRenderer.setIcon(imgScene);
            defaultTreeCellRenderer.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.SceneNode.tooltip", (Object)scene.getName()));
            return defaultTreeCellRenderer;
        }
    }

    private class GlobalRepositoryNodeRenderer
    extends DefaultTreeCellRenderer {
        private GlobalRepositoryNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            GlobalRepository globalRepository = (GlobalRepository)object;
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            defaultTreeCellRenderer.setText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.GameDesignNode.name"));
            defaultTreeCellRenderer.setIcon(imgGame);
            this.setToolTipText(NbBundle.getMessage(GameDesignTreeNodeRenderer.class, (String)"GameDesignTreeNodeRenderer.GameDesignNode.tooltip"));
            return defaultTreeCellRenderer;
        }
    }
}

