/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConflictResolvedAction
extends ContextAction {
    private final VCSContext context;

    public ConflictResolvedAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        ConflictResolvedAction.resolved(this.context);
    }

    public static void resolved(VCSContext vCSContext) {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File[] fileArray = fileStatusCache.listFiles(vCSContext, 64);
        File file = HgUtils.getRootFile(vCSContext);
        if (file == null || fileArray == null || fileArray.length == 0) {
            return;
        }
        ConflictResolvedAction.conflictResolved(file, fileArray);
    }

    public boolean isEnabled() {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        return fileStatusCache.listFiles(this.context, 64).length != 0;
    }

    public static void conflictResolved(File file, final File[] fileArray) {
        if (file == null || fileArray == null || fileArray.length == 0) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    File file = fileArray[i];
                    ConflictResolvedAction.perform(file);
                }
            }
        };
        hgProgressSupport.start(requestProcessor, file.getAbsolutePath(), NbBundle.getMessage(ConflictResolvedAction.class, (String)"MSG_ConflictResolved_Progress"));
    }

    private static void perform(File file) {
        if (file == null) {
            return;
        }
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        HgCommand.deleteConflictFile(file.getAbsolutePath());
        Mercurial.LOG.log(Level.FINE, "ConflictResolvedAction.perform(): DELETE CONFLICT File: {0}", new Object[]{file.getAbsolutePath() + ".conflict~"});
        fileStatusCache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static void resolved(File file) {
        ConflictResolvedAction.perform(file);
    }
}

