/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rollback;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.rollback.Strip;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class StripAction
extends ContextAction {
    private final VCSContext context;
    private static String HG_STIP_SAVE_BUNDLE = "saving bundle to ";
    private static String HG_TIP = "tip";

    public StripAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        StripAction.strip(this.context);
    }

    public static void strip(final VCSContext vCSContext) {
        final File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        File[] fileArray = vCSContext != null ? vCSContext.getFiles().toArray(new File[0]) : null;
        String string = file.getAbsolutePath();
        String string2 = null;
        Strip strip = new Strip(file, fileArray);
        if (!strip.showDialog()) {
            return;
        }
        string2 = strip.getSelectionRevision();
        if (string2 == null) {
            string2 = HG_TIP;
        }
        final boolean bl = strip.isBackupRequested();
        final String string3 = string2;
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    block9: {
                        try {
                            File file2;
                            Object object;
                            outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_TITLE"));
                            outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_TITLE_SEP"));
                            outputLogger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_INFO_SEP", (Object)string3, (Object)file.getAbsolutePath()));
                            List<String> list = HgCommand.doStrip(file, string3, false, bl, outputLogger);
                            if (list == null || list.isEmpty()) break block9;
                            outputLogger.output(list);
                            if (HgCommand.isNoRevStrip(list.get(0))) {
                                outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_NO_REV_STRIP", (Object)string3));
                                break block9;
                            }
                            if (HgCommand.isLocalChangesStrip(list.get(0))) {
                                outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_LOCAL_CHANGES_STRIP"));
                                break block9;
                            }
                            if (HgCommand.isMultipleHeadsStrip(list.get(0))) {
                                outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_MULTI_HEADS_STRIP"));
                                break block9;
                            }
                            if (HgCommand.hasHistory(file).booleanValue()) {
                                object = Mercurial.getInstance().getFileStatusCache();
                                if (((FileStatusCache)object).listFiles(vCSContext, 64).length != 0) {
                                    ConflictResolvedAction.resolved(vCSContext);
                                }
                                HgUtils.forceStatusRefreshProject(vCSContext);
                                Mercurial.getInstance().changesetChanged(file);
                            }
                            if ((file2 = new File((String)(object = (object = list.get(list.size() - 1)) != null ? ((String)object).substring(HG_STIP_SAVE_BUNDLE.length()) : null))) == null || !file2.exists() || !file2.canRead()) break block9;
                            outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_RESTORE_INFO"));
                            outputLogger.output(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_RESTORE_INFO2", (Object)file2.getAbsoluteFile()));
                        }
                        catch (HgException hgException) {
                            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                            Object var6_8 = null;
                            outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_DONE"));
                            outputLogger.output("");
                        }
                    }
                    Object var6_7 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_DONE"));
                    outputLogger.output("");
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_DONE"));
                    outputLogger.output("");
                    throw throwable;
                }
            }
        };
        hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(StripAction.class, (String)"MSG_STRIP_PROGRESS"));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

