/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiff;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportDiffAction
extends ContextAction {
    private final VCSContext context;

    public ExportDiffAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        ExportDiffAction.exportDiff(this.context);
    }

    public boolean isEnabled() {
        Set set = this.context.getFiles();
        if (set == null) {
            return false;
        }
        if (HgUtils.getRootFile(this.context) == null) {
            return false;
        }
        for (File file : set) {
            FileInformation fileInformation = Mercurial.getInstance().getFileStatusCache().getCachedStatus(file);
            if (fileInformation == null || fileInformation.getStatus() != 4 && fileInformation.getStatus() != 4096) continue;
            return false;
        }
        return true;
    }

    private static void exportDiff(VCSContext vCSContext) {
        NotifyDescriptor.Confirmation confirmation;
        File[] fileArray;
        final File file = HgUtils.getRootFile(vCSContext);
        ExportDiff exportDiff = new ExportDiff(file, fileArray = vCSContext != null ? vCSContext.getFiles().toArray(new File[0]) : null);
        if (!exportDiff.showDialog()) {
            return;
        }
        final String string = exportDiff.getSelectionRevision();
        final String string2 = exportDiff.getOutputFileName();
        File file2 = new File(string2);
        if (file2.exists()) {
            confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3005", (Object)file2.getAbsolutePath()));
            confirmation.setOptionType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (!confirmation.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                return;
            }
        }
        HgModuleConfig.getDefault().setExportFolder(file2.getParent());
        confirmation = Mercurial.getInstance().getRequestProcessor(file.getAbsolutePath());
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                ExportDiffAction.performExport(file, string, string2, outputLogger);
            }
        };
        hgProgressSupport.start((RequestProcessor)confirmation, file.getAbsolutePath(), NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress"));
    }

    public static void exportDiffFileRevision(RepositoryRevision.Event event) {
        NotifyDescriptor.Confirmation confirmation;
        if (event == null) {
            return;
        }
        final File file = event.getFile();
        RepositoryRevision repositoryRevision = event.getLogInfoHeader();
        if (repositoryRevision.getRepositoryRootUrl() == null || repositoryRevision.getRepositoryRootUrl().equals("")) {
            return;
        }
        final File file2 = new File(repositoryRevision.getRepositoryRootUrl());
        ExportDiff exportDiff = new ExportDiff(file2, repositoryRevision, null, file);
        final String string = repositoryRevision.getLog().getRevision();
        if (!exportDiff.showDialog()) {
            return;
        }
        final String string2 = exportDiff.getOutputFileName();
        File file3 = new File(string2);
        if (file3.exists()) {
            confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3005", (Object)file3.getAbsolutePath()));
            confirmation.setOptionType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (!confirmation.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                return;
            }
        }
        HgModuleConfig.getDefault().setExportFolder(file3.getParent());
        confirmation = Mercurial.getInstance().getRequestProcessor(file2.getAbsolutePath());
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                ExportDiffAction.performExportFile(file2, string, file, string2, outputLogger);
            }
        };
        hgProgressSupport.start((RequestProcessor)confirmation, file2.getAbsolutePath(), NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress"));
    }

    public static void exportDiffRevision(RepositoryRevision repositoryRevision, File[] fileArray) {
        NotifyDescriptor.Confirmation confirmation;
        if (repositoryRevision == null || repositoryRevision.getRepositoryRootUrl() == null || repositoryRevision.getRepositoryRootUrl().equals("")) {
            return;
        }
        final File file = new File(repositoryRevision.getRepositoryRootUrl());
        ExportDiff exportDiff = new ExportDiff(file, repositoryRevision, fileArray);
        final String string = repositoryRevision.getLog().getRevision();
        if (!exportDiff.showDialog()) {
            return;
        }
        final String string2 = exportDiff.getOutputFileName();
        File file2 = new File(string2);
        if (file2.exists()) {
            confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3005", (Object)file2.getAbsolutePath()));
            confirmation.setOptionType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (!confirmation.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                return;
            }
        }
        HgModuleConfig.getDefault().setExportFolder(file2.getParent());
        confirmation = Mercurial.getInstance().getRequestProcessor(file.getAbsolutePath());
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                ExportDiffAction.performExport(file, string, string2, outputLogger);
            }
        };
        hgProgressSupport.start((RequestProcessor)confirmation, file.getAbsolutePath(), NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExport(File file, String string, String string2, OutputLogger outputLogger) {
        try {
            block5: {
                try {
                    File file2;
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE_SEP"));
                    if (string != null && NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_Revision_Default").startsWith(string)) {
                        outputLogger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
                        break block5;
                    }
                    List<String> list = HgCommand.doExport(file, string, string2, outputLogger);
                    outputLogger.output(list);
                    if (list.isEmpty() || list.size() <= 1 || (file2 = new File(list.get(1))) == null || !file2.canRead()) break block5;
                    Utils.openFile((File)FileUtil.normalizeFile((File)file2));
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                    Object var7_9 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_DONE"));
                    outputLogger.output("");
                }
            }
            Object var7_8 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_DONE"));
            outputLogger.output("");
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_DONE"));
            outputLogger.output("");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExportFile(File file, String string, File file2, String string2, OutputLogger outputLogger) {
        try {
            block5: {
                try {
                    File file3;
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE_SEP"));
                    if (NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_Revision_Default").startsWith(string)) {
                        outputLogger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
                        break block5;
                    }
                    List<String> list = HgCommand.doExportFileDiff(file, file2, string, string2, outputLogger);
                    String string3 = file.getAbsolutePath();
                    String string4 = file2.getAbsolutePath();
                    string4 = string4.substring(string3.length() + 1);
                    outputLogger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE", (Object)string4, (Object)string, (Object)string2));
                    if (list.isEmpty() || list.size() <= 1 || (file3 = new File(string2)) == null || !file3.canRead()) break block5;
                    Utils.openFile((File)FileUtil.normalizeFile((File)file3));
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                    Object var10_12 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_DONE"));
                    outputLogger.output("");
                }
            }
            Object var10_11 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_DONE"));
            outputLogger.output("");
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            outputLogger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_DONE"));
            outputLogger.output("");
            throw throwable;
        }
    }
}

