/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Cursor;
import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.RegionResizeHandler;

public final class RegionResizeAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy mStrategy;
    private MoveProvider mProvider;
    private Widget movingWidget;
    private Point dragSceneLocation;
    private Point originalSceneLocation;
    private CasaModelGraphScene mScene;
    private Widget mLeftResizer;
    private Widget mMiddleResizer;

    public RegionResizeAction(CasaModelGraphScene casaModelGraphScene, Widget widget, Widget widget2, RegionResizeHandler regionResizeHandler) {
        this.mScene = casaModelGraphScene;
        this.mLeftResizer = widget;
        this.mMiddleResizer = widget2;
        this.mProvider = regionResizeHandler;
        this.mStrategy = regionResizeHandler;
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            if (this.isLeftHit(widgetMouseEvent)) {
                widget = this.mLeftResizer;
            } else if (this.isMiddleHit(widgetMouseEvent)) {
                widget = this.mMiddleResizer;
            } else {
                return WidgetAction.State.REJECTED;
            }
            widget.setOpaque(true);
            this.movingWidget = widget;
            this.originalSceneLocation = this.mProvider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widgetMouseEvent.getPoint();
            this.mProvider.movementStarted(widget);
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        widget = this.movingWidget;
        widget.setOpaque(false);
        boolean bl = this.move(widget, widgetMouseEvent.getPoint());
        if (bl) {
            this.movingWidget = null;
            this.mProvider.movementFinished(widget);
        }
        return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (!this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        widget = this.movingWidget;
        return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.movingWidget != widget) {
            return false;
        }
        point = widget.convertLocalToScene(point);
        Point point2 = new Point(this.originalSceneLocation.x + point.x - this.dragSceneLocation.x, this.originalSceneLocation.y + point.y - this.dragSceneLocation.y);
        this.mProvider.setNewLocation(widget, this.mStrategy.locationSuggested(widget, this.originalSceneLocation, point2));
        return true;
    }

    private boolean isLeftHit(WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.mLeftResizer.isHitAt(this.mLeftResizer.convertSceneToLocal(widgetMouseEvent.getPoint()));
    }

    private boolean isMiddleHit(WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        return this.mMiddleResizer.isHitAt(this.mMiddleResizer.convertSceneToLocal(widgetMouseEvent.getPoint()));
    }

    public WidgetAction.State mouseMoved(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.REJECTED;
        }
        if (this.isLeftHit(widgetMouseEvent)) {
            this.mScene.getView().setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.isMiddleHit(widgetMouseEvent)) {
            this.mScene.getView().setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.mScene.getView().getCursor() != Cursor.getPredefinedCursor(0)) {
            this.mScene.getView().setCursor(Cursor.getPredefinedCursor(0));
        }
        return WidgetAction.State.REJECTED;
    }
}

