/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.api.CasaPaletteItemID;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngineExternal;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.palette.CasaCommonAcceptProvider;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPalette;
import org.openide.ErrorManager;

public class AcceptProviderEngineNode
extends CasaCommonAcceptProvider {
    public AcceptProviderEngineNode(CasaModelGraphScene casaModelGraphScene) {
        super(casaModelGraphScene);
    }

    public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
        ConnectorState connectorState = ConnectorState.REJECT;
        try {
            CasaPaletteItemID casaPaletteItemID;
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor) && (casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor)) != null) {
                String string = casaPaletteItemID.getCategory();
                connectorState = string.equals(CasaPalette.CATEGORY_ID_END_POINTS) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return connectorState;
    }

    public void accept(Widget widget, Point point, Transferable transferable) {
        try {
            String string;
            CasaPaletteItemID casaPaletteItemID;
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor) && (casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor)) != null && (string = casaPaletteItemID.getCategory()).equals(CasaPalette.CATEGORY_ID_END_POINTS)) {
                this.highlightExtSUs(false);
                this.addEndpoint(widget, casaPaletteItemID);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private void addEndpoint(Widget widget, CasaPaletteItemID casaPaletteItemID) {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaModelGraphScene.findObject(widget);
        if (casaPaletteItemID.equals(CasaPalette.ITEM_ID_CONSUME)) {
            casaModelGraphScene.getModel().addExternalEndpoint(casaServiceEngineServiceUnit, true);
        } else if (casaPaletteItemID.equals(CasaPalette.ITEM_ID_PROVIDE)) {
            casaModelGraphScene.getModel().addExternalEndpoint(casaServiceEngineServiceUnit, false);
        }
    }

    private void highlightExtSUs(boolean bl) {
        for (Widget widget : this.getScene().getExternalRegion().getChildren()) {
            if (!(widget instanceof CasaNodeWidgetEngineExternal)) continue;
            ((CasaNodeWidgetEngineExternal)widget).setHighlighted(bl);
        }
    }

    public void acceptFinished() {
        super.acceptFinished();
    }

    public void acceptStarted(Transferable transferable) {
        super.acceptStarted(transferable);
    }
}

