/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor;

import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.jbi.CasaModelFactory;
import org.netbeans.modules.compapp.casaeditor.multiview.CasaGraphMultiViewElement;
import org.netbeans.modules.compapp.casaeditor.multiview.CasaMultiViewFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaDataEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
LineCookie,
CloseCookie {
    private transient Task prepareTask2;
    private transient CasaModelGraphScene mScene;
    private static Map<DataObject, CasaWrapperModel> modelMap = new HashMap<DataObject, CasaWrapperModel>();

    public CasaDataEditorSupport(CasaDataObject casaDataObject) {
        super((DataObject)casaDataObject, (CloneableEditorSupport.Env)new CasaEditorEnv(casaDataObject));
        this.setMIMEType("text/xml");
    }

    public CasaEditorEnv getEnv() {
        return (CasaEditorEnv)this.env;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = CasaMultiViewFactory.createMultiView((CasaDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    public static boolean isLastView(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CasaDataEditorSupport.this.updateTitles();
            }
        });
    }

    protected void updateTitles() {
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent;
                ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
                DataObject dataObject = CasaDataEditorSupport.this.getDataObject();
                TopComponent topComponent2 = TopComponent.getRegistry().getActivated();
                if (topComponent2 != null && dataObject == (DataObject)topComponent2.getLookup().lookup(DataObject.class)) {
                    arrayList.add(topComponent2);
                }
                Set set = TopComponent.getRegistry().getOpened();
                for (Object object : set) {
                    topComponent = (TopComponent)object;
                    if (dataObject != (DataObject)topComponent.getLookup().lookup(DataObject.class)) continue;
                    arrayList.add(topComponent);
                }
                for (TopComponent topComponent3 : arrayList) {
                    topComponent = MultiViews.findMultiViewHandler((TopComponent)topComponent3);
                    if (topComponent == null) continue;
                    topComponent3.setHtmlDisplayName(CasaDataEditorSupport.this.messageHtmlName());
                    String string = CasaDataEditorSupport.this.messageName();
                    topComponent3.setDisplayName(string);
                    topComponent3.setName(string);
                    topComponent3.setToolTipText(CasaDataEditorSupport.this.messageToolTip());
                    JEditorPane[] jEditorPaneArray = CasaDataEditorSupport.this.getOpenedPanes();
                    if (jEditorPaneArray == null) continue;
                    for (JEditorPane jEditorPane : jEditorPaneArray) {
                        jEditorPane.setEditable(false);
                    }
                }
            }
        });
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (task != this.prepareTask2) {
            this.prepareTask2 = task;
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    QuietUndoManager quietUndoManager = CasaDataEditorSupport.this.getUndoManager();
                    StyledDocument styledDocument = CasaDataEditorSupport.this.getDocument();
                    QuietUndoManager quietUndoManager2 = quietUndoManager;
                    synchronized (quietUndoManager2) {
                        quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                        if (!quietUndoManager.isCompound()) {
                            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            CasaDataEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                        }
                    }
                    CasaDataEditorSupport.this.prepareTask2 = null;
                }
            });
        }
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = CasaDataEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = CasaDataEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound()) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            try {
                CasaWrapperModel casaWrapperModel = this.getModel();
                if (casaWrapperModel != null) {
                    casaWrapperModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                }
                quietUndoManager.setModel(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.notifyClosed();
    }

    public void setScene(CasaModelGraphScene casaModelGraphScene) {
        this.mScene = casaModelGraphScene;
    }

    public CasaModelGraphScene getScene() {
        return this.mScene;
    }

    public CasaWrapperModel getModel() {
        CasaDataObject casaDataObject = this.getEnv().getCasaDataObject();
        return CasaDataEditorSupport.getModel((DataObject)casaDataObject);
    }

    private static CasaWrapperModel getModel(DataObject dataObject) {
        ModelSource modelSource;
        CasaWrapperModel casaWrapperModel = modelMap.get(dataObject);
        if (casaWrapperModel == null && (modelSource = Utilities.getModelSource((FileObject)dataObject.getPrimaryFile(), (boolean)true)) != null) {
            casaWrapperModel = (CasaWrapperModel)CasaModelFactory.getInstance().getModel(modelSource);
            modelMap.put(dataObject, casaWrapperModel);
        }
        return casaWrapperModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            try {
                CasaWrapperModel casaWrapperModel = this.getModel();
                if (casaWrapperModel != null) {
                    casaWrapperModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                }
                quietUndoManager.setModel(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        try {
            CasaWrapperModel casaWrapperModel = this.getModel();
            if (casaWrapperModel != null) {
                casaWrapperModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                casaWrapperModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.setModel((Model)casaWrapperModel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public void show(Validator.ResultItem resultItem) {
        if (!(resultItem.getModel() instanceof CasaModel)) {
            return;
        }
        final CasaComponent casaComponent = (CasaComponent)resultItem.getComponents();
        DataObject dataObject = this.getDataObject();
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (lineCookie == null || editCookie == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editCookie.edit();
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                if (multiViewHandler == null) {
                    return;
                }
                MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
                if (multiViewPerspective.preferredID().equals("casa-graphview")) {
                    List list = CasaDataEditorSupport.this.getAssociatedTopComponents();
                    for (TopComponent topComponent2 : list) {
                        MultiViewHandler multiViewHandler2 = MultiViews.findMultiViewHandler((TopComponent)topComponent2);
                        if (multiViewHandler2 == null || topComponent2 == null) continue;
                        topComponent2.getLookup().lookupAll(Object.class);
                        CasaGraphMultiViewElement casaGraphMultiViewElement = (CasaGraphMultiViewElement)((Object)topComponent2.getLookup().lookup(CasaGraphMultiViewElement.class));
                        if (casaGraphMultiViewElement == null) {
                            return;
                        }
                        casaGraphMultiViewElement.select(casaComponent);
                    }
                }
            }
        });
    }

    private List<TopComponent> getAssociatedTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        DataObject dataObject = this.getDataObject();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && dataObject == topComponent.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object e : set) {
            TopComponent topComponent2 = (TopComponent)e;
            if (dataObject != topComponent2.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent2);
        }
        return arrayList;
    }

    public void saveDocument() throws IOException {
        DataObject dataObject = this.getDataObject();
        FileObject fileObject = dataObject.getPrimaryFile();
        CasaWrapperModel casaWrapperModel = this.getModel();
        Project project = casaWrapperModel.getJBIProject();
        FileChangeListener fileChangeListener = (FileChangeListener)project.getLookup().lookup(FileChangeListener.class);
        if (fileChangeListener != null) {
            fileObject.removeFileChangeListener(fileChangeListener);
            fileObject.addFileChangeListener(fileChangeListener);
        }
        super.saveDocument();
        casaWrapperModel.saveDocument();
        dataObject.setModified(false);
    }

    public void syncModel() {
        try {
            if (this.getModel() != null) {
                this.getModel().sync();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ErrorManager.getDefault().notify(throwable);
        }
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        static final long serialVersionUID = -3085696462320564244L;
        private DataObject myDataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject dataObject) {
            this.myDataObject = dataObject;
        }

        private CasaDataEditorSupport getCasaDataEditorSupport() {
            return this.myDataObject instanceof CasaDataObject ? ((CasaDataObject)this.myDataObject).getEditorSupport() : null;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            boolean bl;
            CasaDataEditorSupport casaDataEditorSupport = this.getCasaDataEditorSupport();
            boolean bl2 = bl = casaDataEditorSupport != null ? casaDataEditorSupport.canClose() : true;
            if (bl) {
                this.myDataObject.setModified(false);
                CasaWrapperModel casaWrapperModel = CasaDataEditorSupport.getModel(this.myDataObject);
                if (casaWrapperModel != null) {
                    casaWrapperModel.discardRelatedDataObjects();
                }
                try {
                    this.myDataObject.setValid(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
                modelMap.remove(this.myDataObject);
            }
            return bl;
        }
    }

    protected static class CasaEditorEnv
    extends DataEditorSupport.Env {
        static final long serialVersionUID = -4541024350167923282L;

        public CasaEditorEnv(CasaDataObject casaDataObject) {
            super((DataObject)casaDataObject);
        }

        public CloneableEditorSupport findTextEditorSupport() {
            return this.getCasaDataObject().getEditorSupport();
        }

        public CasaDataObject getCasaDataObject() {
            return (CasaDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.getDataObject().getPrimaryFile().lock();
        }
    }
}

