/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.railsprojects.database.ConfigurableRailsAdapter;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapterFactory;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RailsAdaptersPanel
extends SettingsPanel {
    private String projectName;
    private boolean manuallyEdited;
    private DocumentListener databaseNameListener;
    private JTextField databaseNameField;
    private JLabel databaseNameLabel;
    private JComboBox developmentComboBox;
    private JLabel developmentLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField userNameField;
    private JLabel userNameLabel;

    public RailsAdaptersPanel() {
        this.initComponents();
        List<RailsDatabaseConfiguration> list = RailsAdapterFactory.getAdapters();
        this.developmentComboBox.setModel(new AdapterListModel(list));
        this.developmentComboBox.setRenderer(new AdapterListCellRendered());
        this.developmentComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RailsAdaptersPanel.this.initDatabaseNameField();
            }
        });
        this.databaseNameListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }
        };
    }

    private void initDatabaseNameField() {
        if (this.manuallyEdited) {
            return;
        }
        RailsDatabaseConfiguration railsDatabaseConfiguration = (RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem();
        this.databaseNameField.getDocument().removeDocumentListener(this.databaseNameListener);
        this.databaseNameField.setText(railsDatabaseConfiguration.getDatabaseName(this.projectName));
        this.databaseNameField.getDocument().addDocumentListener(this.databaseNameListener);
    }

    private void initComponents() {
        this.developmentLabel = new JLabel();
        this.developmentComboBox = new JComboBox();
        this.databaseNameLabel = new JLabel();
        this.databaseNameField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.developmentLabel.setLabelFor(this.developmentComboBox);
        Mnemonics.setLocalizedText((JLabel)this.developmentLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_DatabaseAdapter"));
        this.databaseNameLabel.setLabelFor(this.databaseNameField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_DatabaseName"));
        this.userNameLabel.setLabelFor(this.userNameField);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_UserName"));
        this.userNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RailsAdaptersPanel.this.userNameFieldActionPerformed(actionEvent);
            }
        });
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_Password"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.developmentLabel).add((Component)this.databaseNameLabel).add((Component)this.userNameLabel).add((Component)this.passwordLabel)).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.developmentComboBox, 0, 374, Short.MAX_VALUE)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.passwordField, -1, 374, Short.MAX_VALUE).add(2, (Component)this.userNameField, -1, 374, Short.MAX_VALUE).add((Component)this.databaseNameField, -1, 374, Short.MAX_VALUE))))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.developmentLabel).add((Component)this.developmentComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.databaseNameLabel).add((Component)this.databaseNameField, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.userNameLabel).add((Component)this.userNameField, -2, 21, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordField, -2, 22, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.developmentLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ACSD_DatabaseAdapter"));
        this.databaseNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_DatabaseName"));
        this.userNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_UserName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_Password"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCN_RailsAdapterPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_RailsAdapterPanel"));
        this.getAccessibleContext().setAccessibleParent(this);
    }

    private void userNameFieldActionPerformed(ActionEvent actionEvent) {
    }

    void store(WizardDescriptor wizardDescriptor) {
        boolean bl = wizardDescriptor.getProperty("useJdbc") != null ? (Boolean)wizardDescriptor.getProperty("useJdbc") : false;
        RailsDatabaseConfiguration railsDatabaseConfiguration = (RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem();
        railsDatabaseConfiguration = new ConfigurableRailsAdapter((RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem(), this.userNameField.getText(), String.valueOf(this.passwordField.getPassword()), this.databaseNameField.getText(), bl);
        wizardDescriptor.putProperty("railsDatabase.development", (Object)railsDatabaseConfiguration);
    }

    void read(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("name");
        if (!string.equals(this.projectName)) {
            this.projectName = string;
            this.initDatabaseNameField();
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private static class AdapterListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public AdapterListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            RailsDatabaseConfiguration railsDatabaseConfiguration = (RailsDatabaseConfiguration)object;
            this.setText(railsDatabaseConfiguration.getDisplayName());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdapterListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<? extends RailsDatabaseConfiguration> adapters;
        private Object selected;

        public AdapterListModel(List<? extends RailsDatabaseConfiguration> list) {
            this.adapters = list;
            this.selected = list.get(0);
        }

        @Override
        public int getSize() {
            return this.adapters.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.adapters.get(n);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selected != object) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }
    }
}

