/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.ui.CreateDatabasePanel;
import org.netbeans.modules.db.mysql.util.Utils;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapterFactory;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.RailsJdbcAsAdapterConnection;
import org.netbeans.modules.ruby.railsprojects.database.RailsJdbcConnection;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JdbcConnectionsPanel
extends SettingsPanel {
    private static final Logger LOGGER = Logger.getLogger(JdbcConnectionsPanel.class.getName());
    private final ConnectionManager connectionManager = ConnectionManager.getDefault();
    private int connectionCount = this.connectionManager.getConnections().length;
    private JButton createDevelopmentDb;
    private JButton createProductionDb;
    private JButton createTestDb;
    private JComboBox developmentComboBox;
    private JLabel developmentLabel;
    private JComboBox productionComboBox;
    private JLabel productionLabel;
    private JComboBox testComboBox;
    private JLabel testLabel;

    public JdbcConnectionsPanel() {
        this.initComponents();
        DatabaseExplorerUIs.connect((JComboBox)this.developmentComboBox, (ConnectionManager)this.connectionManager);
        DatabaseExplorerUIs.connect((JComboBox)this.productionComboBox, (ConnectionManager)this.connectionManager);
        DatabaseExplorerUIs.connect((JComboBox)this.testComboBox, (ConnectionManager)this.connectionManager);
    }

    void updateConnectionCombos() {
        int n = this.connectionManager.getConnections().length;
        if (n == this.connectionCount) {
            return;
        }
        this.connectionCount = n;
        this.developmentComboBox = this.replaceCombo(this.developmentComboBox);
        this.testComboBox = this.replaceCombo(this.testComboBox);
        this.productionComboBox = this.replaceCombo(this.productionComboBox);
    }

    private JComboBox replaceCombo(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        JComboBox jComboBox2 = new JComboBox();
        DatabaseExplorerUIs.connect(jComboBox2, (ConnectionManager)this.connectionManager);
        ((GroupLayout)this.getLayout()).replace((Component)jComboBox, jComboBox2);
        jComboBox2.setSelectedItem(object);
        return jComboBox2;
    }

    private void initComponents() {
        this.developmentLabel = new JLabel();
        this.productionLabel = new JLabel();
        this.testLabel = new JLabel();
        this.developmentComboBox = new JComboBox();
        this.productionComboBox = new JComboBox();
        this.testComboBox = new JComboBox();
        this.createDevelopmentDb = new JButton();
        this.createTestDb = new JButton();
        this.createProductionDb = new JButton();
        this.developmentLabel.setLabelFor(this.developmentComboBox);
        Mnemonics.setLocalizedText((JLabel)this.developmentLabel, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_DevelopmentConnection"));
        this.productionLabel.setLabelFor(this.productionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.productionLabel, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_ProductionConnection"));
        this.testLabel.setLabelFor(this.testComboBox);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_TestConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.createDevelopmentDb, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_CreateMySqlDb_Devel"));
        this.createDevelopmentDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JdbcConnectionsPanel.this.createDevelopmentDbActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createTestDb, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_CreateMySqlDb_Test"));
        this.createTestDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JdbcConnectionsPanel.this.createTestDbActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createProductionDb, (String)NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"LBL_CreateMySqlDb_Production"));
        this.createProductionDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JdbcConnectionsPanel.this.createProductionDbActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.testLabel).add((Component)this.productionLabel).add((Component)this.developmentLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.testComboBox, 0, 313, Short.MAX_VALUE).add((Component)this.productionComboBox, 0, 313, Short.MAX_VALUE).add((Component)this.developmentComboBox, 0, 313, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.createTestDb, -1, -1, Short.MAX_VALUE).add((Component)this.createProductionDb, -1, -1, Short.MAX_VALUE).add((Component)this.createDevelopmentDb, -1, -1, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.developmentLabel).add((Component)this.createDevelopmentDb).add((Component)this.developmentComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.testLabel).add((Component)this.testComboBox, -2, -1, -2).add((Component)this.createTestDb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.productionLabel).add((Component)this.productionComboBox, -2, -1, -2).add((Component)this.createProductionDb)).addContainerGap(-1, Short.MAX_VALUE)));
        this.developmentLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ACSD_DevelopmentConnection"));
        this.productionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ACSD_ProductionConnection"));
        this.testLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ACSD_TestConnection"));
        this.createDevelopmentDb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ASCN_CreateMySqlDb"));
        this.createDevelopmentDb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ASCD_CreateMySqlDb"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ASCN_JdbcPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JdbcConnectionsPanel.class, (String)"ASCD_JdbcPanel"));
        this.getAccessibleContext().setAccessibleParent(this);
    }

    private void createDevelopmentDbActionPerformed(ActionEvent actionEvent) {
        DatabaseConnection databaseConnection = this.createMySqlDb();
        if (databaseConnection != null) {
            this.developmentComboBox.setSelectedItem(databaseConnection);
        }
    }

    private void createTestDbActionPerformed(ActionEvent actionEvent) {
        DatabaseConnection databaseConnection = this.createMySqlDb();
        if (databaseConnection != null) {
            this.testComboBox.setSelectedItem(databaseConnection);
        }
    }

    private void createProductionDbActionPerformed(ActionEvent actionEvent) {
        DatabaseConnection databaseConnection = this.createMySqlDb();
        if (databaseConnection != null) {
            this.productionComboBox.setSelectedItem(databaseConnection);
        }
    }

    private DatabaseConnection createMySqlDb() {
        DatabaseServer databaseServer = DatabaseServerManager.getDatabaseServer();
        DatabaseConnection databaseConnection = null;
        try {
            CreateDatabasePanel createDatabasePanel = new CreateDatabasePanel(databaseServer);
            databaseConnection = createDatabasePanel.showCreateDatabaseDialog();
            this.updateConnectionCombos();
        }
        catch (DatabaseException databaseException) {
            Utils.displayErrorMessage((String)databaseException.getMessage());
        }
        return databaseConnection;
    }

    void store(WizardDescriptor wizardDescriptor) {
        boolean bl;
        DatabaseConnection databaseConnection = (DatabaseConnection)this.developmentComboBox.getSelectedItem();
        DatabaseConnection databaseConnection2 = (DatabaseConnection)this.productionComboBox.getSelectedItem();
        DatabaseConnection databaseConnection3 = (DatabaseConnection)this.testComboBox.getSelectedItem();
        RailsDatabaseConfiguration railsDatabaseConfiguration = null;
        Boolean bl2 = (Boolean)wizardDescriptor.getProperty("useJdbc");
        boolean bl3 = bl2 != null ? bl2 : false;
        boolean bl4 = bl = bl2 == false && databaseConnection == null && databaseConnection2 == null && databaseConnection3 == null;
        railsDatabaseConfiguration = bl ? RailsAdapterFactory.getDefaultAdapter() : (bl3 ? new RailsJdbcConnection(databaseConnection, databaseConnection3, databaseConnection2) : new RailsJdbcAsAdapterConnection(databaseConnection, databaseConnection3, databaseConnection2));
        wizardDescriptor.putProperty("railsDatabase.development", (Object)railsDatabaseConfiguration);
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }
}

