/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.ruby.railsprojects.plugins.InstallationSettingsPanel;
import org.netbeans.modules.ruby.railsprojects.plugins.NewUrlPanel;
import org.netbeans.modules.ruby.railsprojects.plugins.Plugin;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginManager;
import org.netbeans.modules.ruby.railsprojects.plugins.RepositorySelectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class PluginPanel
extends JPanel {
    private final PluginManager pluginManager;
    private List<Plugin> installedPlugins;
    private List<Plugin> newPlugins;
    private List<String> activeRepositories;
    private boolean installedInitialized;
    private boolean newInitialized;
    private boolean repositoriesInitialized;
    private boolean installedModified;
    private boolean newModified;
    private boolean repositoriesModified;
    private boolean pluginsModified;
    private JButton addUrlButton;
    private JButton discoverButton;
    private JLabel instSearchLbl;
    private JTextField instSearchText;
    private JButton installButton;
    private JList installedList;
    private JPanel installedPanel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList newList;
    private JPanel newPanel;
    private JLabel newSearchLbl;
    private JTabbedPane pluginsTab;
    private JButton proxyButton;
    private JButton reloadInstalledButton;
    private JButton reloadNewButton;
    private JButton reloadReposButton;
    private JLabel repSearchLbl;
    private JList repositoryList;
    private JPanel repositoryPanel;
    private JTextField searchNewText;
    private JTextField searchReposText;
    private JButton uninstallButton;
    private JButton unregisterButton;
    private JButton updateAllButton;
    private JButton updateButton;

    public PluginPanel(PluginManager pluginManager) {
        Parameters.notNull((CharSequence)"pluginManager", (Object)pluginManager);
        this.initComponents();
        this.pluginManager = pluginManager;
    }

    public boolean isModified() {
        return this.pluginsModified;
    }

    private void refreshInstalled() {
        this.refreshPluginList(this.getPluginFilter(true), true, this.installedList, true);
        this.pluginsModified = this.pluginsModified || this.installedModified;
        this.installedModified = false;
    }

    private void refreshNew() {
        this.refreshPluginList(this.getPluginFilter(false), true, this.newList, false);
        this.newModified = false;
    }

    private void refreshRepositories() {
        this.refreshRepositoryList(this.getRepositoryFilter(false), true, this.repositoryList, true);
        this.repositoriesModified = false;
    }

    private void initComponents() {
        this.pluginsTab = new JTabbedPane();
        this.installedPanel = new JPanel();
        this.instSearchText = new JTextField();
        this.instSearchLbl = new JLabel();
        this.reloadInstalledButton = new JButton();
        this.uninstallButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.installedList = new JList();
        this.updateButton = new JButton();
        this.updateAllButton = new JButton();
        this.newPanel = new JPanel();
        this.searchNewText = new JTextField();
        this.newSearchLbl = new JLabel();
        this.reloadNewButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.newList = new JList();
        this.repositoryPanel = new JPanel();
        this.searchReposText = new JTextField();
        this.repSearchLbl = new JLabel();
        this.reloadReposButton = new JButton();
        this.unregisterButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.repositoryList = new JList();
        this.discoverButton = new JButton();
        this.addUrlButton = new JButton();
        this.jPanel1 = new JPanel();
        this.proxyButton = new JButton();
        FormListener formListener = new FormListener();
        this.installedPanel.addComponentListener(formListener);
        this.instSearchText.setColumns(14);
        this.instSearchText.addActionListener(formListener);
        this.instSearchLbl.setLabelFor(this.instSearchText);
        Mnemonics.setLocalizedText((JLabel)this.instSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.instSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(formListener);
        this.jScrollPane1.setViewportView(this.installedList);
        this.installedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedList.AccessibleContext.accessibleName"));
        this.installedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateAllButton.text"));
        this.updateAllButton.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.reloadInstalledButton).addPreferredGap(0, 376, Short.MAX_VALUE).add((Component)this.instSearchLbl).addPreferredGap(0).add((Component)this.instSearchText, -2, 156, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.uninstallButton).addPreferredGap(0).add((Component)this.updateButton).addPreferredGap(0).add((Component)this.updateAllButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.instSearchLbl).add((Component)this.reloadInstalledButton).add((Component)this.instSearchText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uninstallButton).add((Component)this.updateAllButton).add((Component)this.updateButton)).addContainerGap()));
        this.instSearchText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.instSearchText.AccessibleContext.accessibleDescription"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadInstalledButton.AccessibleContext.accessibleDescription"));
        this.uninstallButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.uninstallButton.AccessibleContext.accessibleDescription"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateButton.AccessibleContext.accessibleDescription"));
        this.updateAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateAllButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedPanel.TabConstraints.tabTitle"), this.installedPanel);
        this.newPanel.addComponentListener(formListener);
        this.searchNewText.setColumns(14);
        this.searchNewText.addActionListener(formListener);
        this.newSearchLbl.setLabelFor(this.searchNewText);
        Mnemonics.setLocalizedText((JLabel)this.newSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadNewButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadNewButton.text"));
        this.reloadNewButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(formListener);
        this.jScrollPane2.setViewportView(this.newList);
        this.newList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newList.AccessibleContext.accessibleName"));
        this.newList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newList.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.newPanel);
        this.newPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.reloadNewButton).addPreferredGap(0, 376, Short.MAX_VALUE).add((Component)this.newSearchLbl).addPreferredGap(0).add((Component)this.searchNewText, -2, 156, -2)).add((Component)this.installButton)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.newSearchLbl).add((Component)this.reloadNewButton).add((Component)this.searchNewText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.installButton).addContainerGap()));
        this.searchNewText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.searchNewText.AccessibleContext.accessibleDescription"));
        this.reloadNewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadNewButton.AccessibleContext.accessibleDescription"));
        this.installButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newPanel.TabConstraints.tabTitle"), this.newPanel);
        this.repositoryPanel.addComponentListener(formListener);
        this.searchReposText.setColumns(14);
        this.searchReposText.addActionListener(formListener);
        this.repSearchLbl.setLabelFor(this.searchReposText);
        Mnemonics.setLocalizedText((JLabel)this.repSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadReposButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadReposButton.text"));
        this.reloadReposButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.unregisterButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.unregisterButton.text"));
        this.unregisterButton.setEnabled(false);
        this.unregisterButton.addActionListener(formListener);
        this.jScrollPane3.setViewportView(this.repositoryList);
        this.repositoryList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryList.AccessibleContext.accessibleName"));
        this.repositoryList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.discoverButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.discoverButton.text"));
        this.discoverButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addUrlButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.addUrlButton.text"));
        this.addUrlButton.addActionListener(formListener);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.repositoryPanel);
        this.repositoryPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.discoverButton).addPreferredGap(1).add((Component)this.addUrlButton).addPreferredGap(1).add((Component)this.reloadReposButton).addPreferredGap(0, 144, Short.MAX_VALUE).add((Component)this.repSearchLbl).addPreferredGap(0).add((Component)this.searchReposText, -2, 156, -2)).add((Component)this.unregisterButton)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.repSearchLbl).add((Component)this.searchReposText, -2, -1, -2).add((Component)this.discoverButton).add((Component)this.addUrlButton).add((Component)this.reloadReposButton)).addPreferredGap(0).add((Component)this.jScrollPane3, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.unregisterButton).addContainerGap()));
        this.searchReposText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.searchReposText.AccessibleContext.accessibleDescription"));
        this.reloadReposButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadReposButton.AccessibleContext.accessibleDescription"));
        this.unregisterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.unregisterButton.AccessibleContext.accessibleDescription"));
        this.discoverButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.discoverButton.AccessibleContext.accessibleDescription"));
        this.addUrlButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.addUrlButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryPanel.TabConstraints.tabTitle"), this.repositoryPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(564, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(406, Short.MAX_VALUE)));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.pluginsTab, -1, 721, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.pluginsTab, -1, 468, Short.MAX_VALUE).addContainerGap()));
        this.pluginsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.pluginsTab.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.AccessibleContext.accessibleDescription"));
    }

    private void reloadNewButtonActionPerformed(ActionEvent actionEvent) {
        this.refreshNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUrlButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        assert (SwingUtilities.isEventDispatchThread());
        NewUrlPanel newUrlPanel = new NewUrlPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newUrlPanel, NbBundle.getMessage(PluginPanel.class, (String)"AddUrl"));
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (string = newUrlPanel.getUrl()) != null) {
            this.pluginManager.addRepositories(new String[]{string}, this, null, true, new RepositoryListRefresher(this.repositoryList, true));
            this.newModified = true;
            this.repositoriesModified = true;
        }
    }

    private void proxyButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        assert (SwingUtilities.isEventDispatchThread());
        String string = this.getWaitMsg();
        RepositorySelectionPanel repositorySelectionPanel = new RepositorySelectionPanel();
        JList jList = repositorySelectionPanel.getList();
        jList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.List"));
        jList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.List.AccessibleContext.accessibleDescription"));
        jList.setSelectionMode(2);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositorySelectionPanel, NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos"));
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.AccessibleContext.accessibleDescription"));
            this.refreshRepositoryList(null, true, jList, false);
            dialog.setVisible(true);
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (objectArray = jList.getSelectedValues()) != null && objectArray.length > 0 && !string.equals(objectArray[0])) {
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            this.pluginManager.addRepositories(stringArray, this, null, true, new RepositoryListRefresher(this.repositoryList, true));
            this.newModified = true;
            this.repositoriesModified = true;
        }
    }

    private void searchNewTextActionPerformed(ActionEvent actionEvent) {
        this.refreshPluginList(this.getPluginFilter(false), false, this.newList, false);
    }

    private void searchReposTextActionPerformed(ActionEvent actionEvent) {
        this.refreshRepositoryList(this.getRepositoryFilter(true), false, this.repositoryList, true);
    }

    private void reloadReposButtonActionPerformed(ActionEvent actionEvent) {
        this.refreshRepositories();
    }

    private void unregisterButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.repositoryList.getSelectedIndices();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (nArray != null) {
            object = this.getWaitMsg();
            for (int n : nArray) {
                assert (n >= 0);
                String string = this.repositoryList.getModel().getElementAt(n).toString();
                if (((String)object).equals(string)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.size() > 0) {
            object = new RepositoryListRefresher(this.repositoryList, true);
            this.pluginManager.removeRepositories(arrayList.toArray(new String[arrayList.size()]), this, null, true, (Runnable)object);
            this.repositoriesModified = true;
            this.newModified = true;
        }
    }

    private void repositoryPanelComponentShown(ComponentEvent componentEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.repositoriesInitialized) {
            this.repositoriesInitialized = true;
            this.repositoryList.setSelectionMode(2);
            this.repositoryList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    int n = PluginPanel.this.repositoryList.getSelectedIndex();
                    PluginPanel.this.unregisterButton.setEnabled(n != -1);
                }
            });
            this.repositoriesModified = true;
        }
        if (this.repositoriesModified) {
            this.refreshRepositories();
        }
    }

    private void newPanelComponentShown(ComponentEvent componentEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.newInitialized) {
            this.newInitialized = true;
            this.newList.setSelectionMode(2);
            this.newList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.newList, new JButton[]{this.installButton}));
            this.newModified = true;
        }
        if (this.newModified) {
            this.refreshNew();
        }
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        Plugin plugin;
        Object object;
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.newList.getSelectedIndices();
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        for (int n : nArray) {
            object = this.newList.getModel().getElementAt(n);
            if (!(object instanceof Plugin)) continue;
            plugin = (Plugin)object;
            arrayList.add(plugin);
        }
        if (arrayList.size() > 0) {
            Object object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Plugin plugin2 = (Plugin)object2.next();
                InstallationSettingsPanel installationSettingsPanel = new InstallationSettingsPanel(plugin2);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)installationSettingsPanel, NbBundle.getMessage(PluginPanel.class, (String)"ChoosePluginSettings"));
                dialogDescriptor.setOptionType(2);
                dialogDescriptor.setModal(true);
                dialogDescriptor.setHelpCtx(new HelpCtx(InstallationSettingsPanel.class));
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (!object.equals(NotifyDescriptor.OK_OPTION)) continue;
                plugin = new Plugin(installationSettingsPanel.getPluginName(), null);
                PluginListRefresher pluginListRefresher = new PluginListRefresher(this.newList, false);
                boolean bl = this.pluginManager.install(new Plugin[]{plugin}, this, null, installationSettingsPanel.isSvnExternals(), installationSettingsPanel.isSvnCheckout(), installationSettingsPanel.getRevision(), true, pluginListRefresher);
                this.installedModified = this.installedModified || bl;
            }
        }
    }

    private void instSearchTextActionPerformed(ActionEvent actionEvent) {
        this.refreshPluginList(this.getPluginFilter(true), false, this.installedList, true);
    }

    private void updateAllButtonActionPerformed(ActionEvent actionEvent) {
        PluginListRefresher pluginListRefresher = new PluginListRefresher(this.installedList, true);
        this.pluginManager.update(null, null, null, this, true, pluginListRefresher);
        this.installedModified = true;
    }

    private void updateButtonActionPerformed(ActionEvent actionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.installedList.getSelectedIndices();
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.installedList.getModel().getElementAt(n);
                if (!(e instanceof Plugin)) continue;
                Plugin plugin = (Plugin)e;
                arrayList.add(plugin);
            }
        }
        if (arrayList.size() > 0) {
            PluginListRefresher pluginListRefresher = new PluginListRefresher(this.installedList, true);
            this.pluginManager.update(arrayList.toArray(new Plugin[arrayList.size()]), null, null, this, true, pluginListRefresher);
            this.installedModified = true;
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] nArray = this.installedList.getSelectedIndices();
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        if (nArray != null) {
            for (int n : nArray) {
                assert (n >= 0);
                Object e = this.installedList.getModel().getElementAt(n);
                if (!(e instanceof Plugin)) continue;
                Plugin plugin = (Plugin)e;
                arrayList.add(plugin);
            }
        }
        if (arrayList.size() > 0) {
            PluginListRefresher pluginListRefresher = new PluginListRefresher(this.installedList, true);
            this.pluginManager.uninstall(arrayList.toArray(new Plugin[arrayList.size()]), null, this, true, pluginListRefresher);
            this.installedModified = true;
        }
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent actionEvent) {
        this.refreshInstalled();
    }

    private void installedPanelComponentShown(ComponentEvent componentEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.installedInitialized) {
            this.installedInitialized = true;
            this.installedList.setSelectionMode(2);
            this.installedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.installedList, new JButton[]{this.updateButton, this.uninstallButton}));
            this.installedModified = true;
        }
        if (this.installedModified) {
            this.refreshInstalled();
        }
    }

    private String getWaitMsg() {
        return NbBundle.getMessage(PluginPanel.class, (String)"PleaseWait");
    }

    private void refreshPluginList(final String string, final boolean bl, final JList jList, final boolean bl2) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean bl3 = true;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    List list;
                    final DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
                    ArrayList<String> arrayList = new ArrayList<String>(500);
                    if (bl2) {
                        if (bl || PluginPanel.this.installedPlugins == null) {
                            PluginPanel.this.installedPlugins = PluginPanel.this.pluginManager.getInstalledPlugins(true, null, arrayList);
                        }
                        list = PluginPanel.this.installedPlugins;
                    } else {
                        if (bl || PluginPanel.this.newPlugins == null) {
                            PluginPanel.this.newPlugins = PluginPanel.this.pluginManager.getAvailablePlugins(true, null, arrayList);
                        }
                        list = PluginPanel.this.newPlugins;
                    }
                    Pattern pattern = null;
                    String string5 = null;
                    if (string != null && (string.indexOf(42) != -1 || string.indexOf(94) != -1 || string.indexOf(36) != -1)) {
                        try {
                            pattern = Pattern.compile(string, 2);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {}
                    } else if (string != null) {
                        string5 = string.toLowerCase();
                    }
                    for (Plugin object : list) {
                        if (string == null || string.length() == 0) {
                            defaultListModel.addElement(object);
                            continue;
                        }
                        if (pattern == null) {
                            if (string5 != null) {
                                String string2;
                                String string3 = object.getName().toLowerCase();
                                if (string3.indexOf(string5) != -1) {
                                    defaultListModel.addElement(object);
                                    continue;
                                }
                                if (object.getRepository() == null || (string2 = object.getRepository().toLowerCase()).indexOf(string5) == -1) continue;
                                defaultListModel.addElement(object);
                                continue;
                            }
                            defaultListModel.addElement(object);
                            continue;
                        }
                        if (!pattern.matcher(object.getName()).find() && (object.getRepository() == null || !pattern.matcher(object.getRepository()).find())) continue;
                        defaultListModel.addElement(object);
                    }
                    if (bl && list.size() == 0) {
                        if (!bl2) {
                            defaultListModel.addElement(NbBundle.getMessage(PluginPanel.class, (String)"NoNetwork"));
                        }
                        for (String string4 : arrayList) {
                            defaultListModel.addElement("<html><span color=\"red\">" + string4 + "</span></html>");
                        }
                    }
                    final int n = list.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string;
                            jList.clearSelection();
                            jList.setModel(defaultListModel);
                            jList.invalidate();
                            jList.repaint();
                            if (n > 0) {
                                jList.setSelectedIndex(0);
                            }
                            int n3 = bl2 ? 0 : 1;
                            String string2 = string = PluginPanel.this.pluginsTab.getTitleAt(n3);
                            int n2 = string.lastIndexOf(40);
                            if (n2 != -1) {
                                string = string.substring(0, n2);
                            }
                            if (!(string = string + "(" + n + ")").equals(string2)) {
                                PluginPanel.this.pluginsTab.setTitleAt(n3, string);
                            }
                        }
                    });
                }
            }
        };
        if (bl || bl2 && this.installedPlugins == null || !bl2 && this.newPlugins == null) {
            if (bl3) {
                DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                defaultListModel.addElement(NbBundle.getMessage(PluginPanel.class, (String)(bl2 ? "FetchingLocalPlugins" : "FetchingRemotePlugins")));
                jList.setModel(defaultListModel);
            }
            RequestProcessor.getDefault().post(runnable, 50);
        } else {
            runnable.run();
        }
    }

    private void refreshRepositoryList(final String string, final boolean bl, final JList jList, final boolean bl2) {
        assert (SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    List list;
                    final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                    ArrayList arrayList = new ArrayList(500);
                    if (bl2) {
                        if (bl || PluginPanel.this.activeRepositories == null) {
                            PluginPanel.this.activeRepositories = PluginPanel.this.pluginManager.getRepositories(bl2);
                        }
                        list = PluginPanel.this.activeRepositories;
                    } else {
                        list = PluginPanel.this.pluginManager.getRepositories(bl2);
                    }
                    Pattern pattern = null;
                    String string4 = null;
                    if (string != null && (string.indexOf(42) != -1 || string.indexOf(94) != -1 || string.indexOf(36) != -1)) {
                        try {
                            pattern = Pattern.compile(string, 2);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {}
                    } else if (string != null) {
                        string4 = string.toLowerCase();
                    }
                    Collections.sort(list);
                    for (String string2 : list) {
                        if (string == null || string.length() == 0) {
                            defaultListModel.addElement(string2);
                            continue;
                        }
                        if (pattern == null) {
                            if (string4 != null) {
                                String string3 = string2.toLowerCase();
                                if (string3.indexOf(string4) == -1) continue;
                                defaultListModel.addElement(string2);
                                continue;
                            }
                            defaultListModel.addElement(string2);
                            continue;
                        }
                        if (!pattern.matcher(string2).find()) continue;
                        defaultListModel.addElement(string2);
                    }
                    if (bl && list.size() == 0) {
                        defaultListModel.addElement(NbBundle.getMessage(PluginPanel.class, (String)"NoNetwork"));
                        for (String string2 : arrayList) {
                            defaultListModel.addElement("<html><span color=\"red\">" + string2 + "</span></html>");
                        }
                    }
                    final int n = list.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            jList.clearSelection();
                            jList.setModel(defaultListModel);
                            jList.invalidate();
                            jList.repaint();
                            if (n > 0) {
                                jList.setSelectedIndex(0);
                            }
                        }
                    });
                }
            }
        };
        if (bl || bl2 && this.activeRepositories == null || !bl2) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            defaultListModel.addElement(NbBundle.getMessage(PluginPanel.class, (String)(bl2 ? "FetchingLocalRepos" : "FetchingRemoteRepos")));
            jList.setModel(defaultListModel);
            RequestProcessor.getDefault().post(runnable, 50);
        } else {
            runnable.run();
        }
    }

    private String getRepositoryFilter(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        String string = null;
        if (bl && (string = this.searchReposText.getText().trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private String getPluginFilter(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        String string = null;
        JTextField jTextField = bl ? this.instSearchText : this.searchNewText;
        string = jTextField.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private JButton[] buttons;
        private JList list;

        private MyListSelectionListener(JList jList, JButton[] jButtonArray) {
            this.list = jList;
            this.buttons = jButtonArray;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = this.list.getSelectedIndex();
            if (n != -1 && (object = this.list.getModel().getElementAt(n)) instanceof Plugin) {
                for (JButton jButton : this.buttons) {
                    jButton.setEnabled(true);
                }
                return;
            }
            for (JButton jButton : this.buttons) {
                jButton.setEnabled(n != -1);
            }
        }
    }

    private class RepositoryListRefresher
    implements Runnable {
        private JList list;
        private boolean local;

        public RepositoryListRefresher(JList jList, boolean bl) {
            this.list = jList;
            this.local = bl;
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            PluginPanel.this.refreshRepositoryList(PluginPanel.this.getRepositoryFilter(this.local), true, this.list, this.local);
            if (this.list == PluginPanel.this.repositoryList) {
                PluginPanel.this.repositoriesModified = false;
            }
        }
    }

    private class PluginListRefresher
    implements Runnable {
        private JList list;
        private boolean local;

        public PluginListRefresher(JList jList, boolean bl) {
            this.list = jList;
            this.local = bl;
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            PluginPanel.this.refreshPluginList(PluginPanel.this.getPluginFilter(this.local), true, this.list, this.local);
            if (this.list == PluginPanel.this.newList) {
                PluginPanel.this.newModified = false;
            } else if (this.list == PluginPanel.this.installedList) {
                PluginPanel.this.pluginsModified = PluginPanel.this.pluginsModified || PluginPanel.this.installedModified;
                PluginPanel.this.installedModified = false;
            }
        }
    }

    private class FormListener
    implements ActionListener,
    ComponentListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PluginPanel.this.instSearchText) {
                PluginPanel.this.instSearchTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.reloadInstalledButton) {
                PluginPanel.this.reloadInstalledButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.uninstallButton) {
                PluginPanel.this.uninstallButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.updateButton) {
                PluginPanel.this.updateButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.updateAllButton) {
                PluginPanel.this.updateAllButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.searchNewText) {
                PluginPanel.this.searchNewTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.reloadNewButton) {
                PluginPanel.this.reloadNewButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.installButton) {
                PluginPanel.this.installButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.searchReposText) {
                PluginPanel.this.searchReposTextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.reloadReposButton) {
                PluginPanel.this.reloadReposButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.unregisterButton) {
                PluginPanel.this.unregisterButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.discoverButton) {
                PluginPanel.this.discoverButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.addUrlButton) {
                PluginPanel.this.addUrlButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == PluginPanel.this.proxyButton) {
                PluginPanel.this.proxyButtonActionPerformed(actionEvent);
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == PluginPanel.this.installedPanel) {
                PluginPanel.this.installedPanelComponentShown(componentEvent);
            } else if (componentEvent.getSource() == PluginPanel.this.newPanel) {
                PluginPanel.this.newPanelComponentShown(componentEvent);
            } else if (componentEvent.getSource() == PluginPanel.this.repositoryPanel) {
                PluginPanel.this.repositoryPanelComponentShown(componentEvent);
            }
        }
    }
}

