/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathProvider;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.railsprojects.classpath.BootClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.JavascriptsClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.PublicClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.SourcePathImplementation;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final String BUILD_CLASSES_DIR = "build.classes.dir";
    private static final String DIST_JAR = "dist.jar";
    private static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    private static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    private static final String RUN_CLASSPATH = "run.classpath";
    private static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    private final RakeProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[9];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(RakeProjectHelper rakeProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = rakeProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)rakeProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private synchronized FileObject getDir(String string) {
        String string2;
        FileObject fileObject = this.dirCache.get(string);
        if (!(fileObject != null && fileObject.isValid() || (string2 = this.evaluator.getProperty(string)) == null)) {
            fileObject = this.helper.resolveFileObject(string2);
            this.dirCache.put(string, fileObject);
        }
        return fileObject;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private ClassPath getPublicWebClassPath() {
        ClassPath classPath = this.cache[8];
        if (classPath == null) {
            this.cache[8] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new PublicClassPathImplementation(this.projectDirectory));
            return classPath;
        }
        return classPath;
    }

    private ClassPath getJavascriptsWebClassPath() {
        ClassPath classPath = this.cache[8];
        if (classPath == null) {
            this.cache[8] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new JavascriptsClassPathImplementation(this.projectDirectory));
            return classPath;
        }
        return classPath;
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(BUILD_CLASSES_DIR);
    }

    private FileObject getDistJar() {
        return this.getDir(DIST_JAR);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(BUILD_TEST_CLASSES_DIR);
    }

    private int getType(FileObject fileObject) {
        return 0;
    }

    private synchronized ClassPath getSourcepath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getSourcepath(n);
    }

    private ClassPath getSourcepath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[n];
        if (classPath == null) {
            switch (n) {
                case 0: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots));
                }
            }
        }
        this.cache[n] = classPath;
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.projectDirectory, this.evaluator));
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (string.equals("classpath/compile")) {
            return this.getBootClassPath();
        }
        if (string.equals("js/library")) {
            return this.getJavascriptsWebClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/source".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return classPathArray;
        }
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }

    public String getPropertyName(SourceGroup sourceGroup, String string) {
        int n;
        FileObject fileObject = sourceGroup.getRootFolder();
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return JAVAC_CLASSPATH;
            }
            if ("classpath/execute".equals(string)) {
                return RUN_CLASSPATH;
            }
            return null;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return JAVAC_TEST_CLASSPATH;
            }
            if ("classpath/execute".equals(string)) {
                return RUN_TEST_CLASSPATH;
            }
            return null;
        }
        return null;
    }
}

