/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class GotoActionView
extends AbstractAction {
    public GotoActionView() {
        super(NbBundle.getMessage(GotoActionView.class, (String)"rails-goto-action-view"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GotoActionView.class).getString("editor-popup-goto-action-view"));
    }

    private FileObject getCurrentFile() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        return fileObject;
    }

    public boolean isEnabled() {
        FileObject fileObject = this.getCurrentFile();
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        if ("application/x-httpd-eruby".equals(string)) {
            return true;
        }
        if ("text/x-ruby".equals(string)) {
            String string2 = fileObject.getName();
            if (string2.endsWith("_controller") || string2.endsWith("_helper")) {
                return true;
            }
            String string3 = fileObject.getExt();
            if (!string3.equals("rb")) {
                for (String string4 : RubyUtils.RUBY_VIEW_EXTS) {
                    if (!string3.equalsIgnoreCase(string4)) continue;
                    return true;
                }
            }
            return false;
        }
        return "haml".equals(fileObject.getExt());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = GsfUtilities.getOpenPane();
        FileObject fileObject = this.getCurrentFile();
        if (fileObject != null && jTextComponent != null) {
            this.actionPerformed(jTextComponent, fileObject);
        }
    }

    private void actionPerformed(JTextComponent jTextComponent, FileObject fileObject) {
        if (fileObject != null) {
            if (fileObject.getName().endsWith("_controller")) {
                this.gotoView(jTextComponent, fileObject, false, "_controller");
            } else if (fileObject.getName().endsWith("_helper")) {
                this.gotoView(jTextComponent, fileObject, true, "_helper");
            } else if (RubyUtils.isRhtmlFile((FileObject)fileObject)) {
                this.gotoAction(jTextComponent, fileObject);
            } else {
                String string = fileObject.getExt();
                for (String string2 : RubyUtils.RUBY_VIEW_EXTS) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    this.gotoAction(jTextComponent, fileObject);
                    return;
                }
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToControllers"));
            }
        }
    }

    private void notFound(JTextComponent jTextComponent) {
        Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(GotoActionView.class, (String)"ControllerNotFound"));
    }

    private void gotoView(JTextComponent jTextComponent, FileObject fileObject, boolean bl, String string) {
        String string2;
        FileObject fileObject2;
        if (!fileObject.getName().endsWith(string)) {
            Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToActions"));
            return;
        }
        FileObject fileObject3 = fileObject;
        int n = 0;
        if (jTextComponent.getCaret() != null) {
            n = jTextComponent.getCaret().getDot();
        }
        if ((fileObject2 = RubyUtils.getRailsViewFor((FileObject)fileObject, (String)(string2 = AstUtilities.getMethodName((FileObject)fileObject3, (int)n)), (boolean)bl, (boolean)false)) == null) {
            this.notFound(jTextComponent);
        } else {
            GsfUtilities.open((FileObject)fileObject2, (int)0, null);
        }
    }

    private void gotoAction(JTextComponent jTextComponent, FileObject fileObject) {
        String string = fileObject.getExt();
        boolean bl = false;
        for (String string2 : RubyUtils.RUBY_VIEW_EXTS) {
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        if (!RubyUtils.isRhtmlFile((FileObject)fileObject) && !bl) {
            Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)NbBundle.getMessage(GotoActionView.class, (String)"AppliesToViews"));
            return;
        }
        String string3 = fileObject.getName();
        FileObject fileObject2 = RubyUtils.getRailsControllerFor((FileObject)fileObject);
        if (fileObject2 == null) {
            this.notFound(jTextComponent);
            return;
        }
        int n = AstUtilities.findOffset((FileObject)fileObject2, (String)string3);
        GsfUtilities.open((FileObject)fileObject2, (int)n, (String)("def " + string3));
    }
}

