/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.AddOperationCookie;
import org.netbeans.modules.websvc.core.AddWsOperationHelper;
import org.netbeans.modules.websvc.core._RetoucheUtil;
import org.netbeans.modules.websvc.design.schema2java.OperationGeneratorHelper;
import org.netbeans.modules.websvc.design.util.WSDLUtils;
import org.netbeans.modules.websvc.design.view.actions.AddOperationFromSchemaPanel;
import org.netbeans.modules.websvc.design.view.actions.ParamModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOperationAction
extends AbstractAction
implements AddOperationCookie {
    private FileObject implementationClass;
    private Service service;
    private File wsdlFile;

    public AddOperationAction(Service service, FileObject fileObject) {
        super(AddOperationAction.getName());
        this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/design/view/resources/operation.png")));
        this.putValue("ShortDescription", NbBundle.getMessage(AddOperationAction.class, (String)"Hint_AddOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation_mnem_pos")));
        this.service = service;
        this.implementationClass = fileObject;
        this.wsdlFile = this.getWSDLFile();
    }

    private static String getName() {
        return NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation");
    }

    private File getWSDLFile() {
        FileObject fileObject;
        JAXWSSupport jAXWSSupport;
        String string = this.service.getLocalWsdlFile();
        if (string != null && (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.implementationClass)) != null && (fileObject = jAXWSSupport.getLocalWsdlFolderForService(this.service.getName(), false)) != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            return new File(file.getAbsolutePath() + File.separator + string);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.wsdlFile != null && this.wsdlFile.exists()) {
            final AddOperationFromSchemaPanel addOperationFromSchemaPanel = new AddOperationFromSchemaPanel(this.wsdlFile);
            final String string = OperationGeneratorHelper.getPortTypeNameFromImpl(this.implementationClass);
            boolean bl = false;
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addOperationFromSchemaPanel, NbBundle.getMessage(AddOperationAction.class, (String)"TTL_AddWsOperation"));
            while (!bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    if (this.wsdlOperationExists(addOperationFromSchemaPanel.getWSDLModel(), addOperationFromSchemaPanel.getOperationName(), string)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddOperationAction.class, (String)"TXT_OperationExists")));
                        continue;
                    }
                    bl = true;
                    final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(AddOperationAction.class, (String)"MSG_AddingOperation", (Object)addOperationFromSchemaPanel.getOperationName()));
                    Task task = new Task(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                progressHandle.start();
                                AddOperationAction.this.addWSDLOperation(addOperationFromSchemaPanel, string);
                            }
                            catch (Exception exception) {
                                progressHandle.finish();
                                ErrorManager.getDefault().notify((Throwable)exception);
                            }
                            finally {
                                progressHandle.finish();
                            }
                        }
                    });
                    RequestProcessor.getDefault().post((Runnable)task);
                    continue;
                }
                bl = true;
            }
        } else {
            try {
                this.addJavaMethod();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void saveImplementationClass(FileObject fileObject) throws IOException {
        SaveCookie saveCookie;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject.isModified() && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
    }

    private void addJavaMethod() throws IOException {
        AddWsOperationHelper addWsOperationHelper = new AddWsOperationHelper(AddOperationAction.getName());
        String string = _RetoucheUtil.getMainClassName((FileObject)this.implementationClass);
        if (string != null) {
            addWsOperationHelper.addMethod(this.implementationClass, string);
            this.saveImplementationClass(this.implementationClass);
        }
    }

    private void retrieveNewSchemas(Set<Schema> set) throws FileStateInvalidException, URISyntaxException, UnknownHostException, URISyntaxException, IOException {
        JAXWSSupport jAXWSSupport = null;
        FileObject fileObject = null;
        for (Schema schema : set) {
            FileObject fileObject2 = (FileObject)schema.getModel().getModelSource().getLookup().lookup(FileObject.class);
            if (fileObject2 == null) continue;
            if (jAXWSSupport == null) {
                jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.implementationClass);
                fileObject = jAXWSSupport.getLocalWsdlFolderForService(this.service.getName(), false);
            }
            WSUtils.retrieveResource(fileObject, (URI)fileObject2.getURL().toURI());
        }
    }

    private void addWSDLOperation(AddOperationFromSchemaPanel addOperationFromSchemaPanel, String string) throws IOException, FileStateInvalidException, URISyntaxException, UnknownHostException {
        OperationGeneratorHelper operationGeneratorHelper = new OperationGeneratorHelper(this.wsdlFile);
        WSDLModel wSDLModel = WSDLUtils.getWSDLModel(FileUtil.toFileObject((File)this.wsdlFile), true);
        Set<Schema> set = addOperationFromSchemaPanel.getNewSchemas();
        if (set.size() > 0) {
            this.changeSchemaLocation(set, wSDLModel);
            this.retrieveNewSchemas(set);
        }
        String string2 = addOperationFromSchemaPanel.getOperationName();
        List<ParamModel> list = addOperationFromSchemaPanel.getParameterTypes();
        ReferenceableSchemaComponent referenceableSchemaComponent = addOperationFromSchemaPanel.getReturnType();
        List<ParamModel> list2 = addOperationFromSchemaPanel.getFaultTypes();
        operationGeneratorHelper.addWsOperation(string, string2, list, referenceableSchemaComponent, list2);
        this.saveWsdlFile(FileUtil.toFileObject((File)this.wsdlFile));
        operationGeneratorHelper.generateJavaArtifacts(this.service.getName(), this.implementationClass, string2, false);
        this.saveImplementationClass(this.implementationClass);
    }

    private void saveWsdlFile(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        saveCookie.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSchemaLocation(Set<Schema> set, WSDLModel wSDLModel) throws FileStateInvalidException, URISyntaxException {
        Definitions definitions = wSDLModel.getDefinitions();
        Types types = definitions.getTypes();
        Collection collection = types.getSchemas();
        for (Schema schema : set) {
            FileObject fileObject = (FileObject)schema.getModel().getModelSource().getLookup().lookup(FileObject.class);
            URI uRI = fileObject.getURL().toURI();
            for (Schema schema2 : collection) {
                Collection collection2 = schema2.getImports();
                for (Import import_ : collection2) {
                    URI uRI2 = new URI(import_.getSchemaLocation());
                    if (!uRI2.equals(uRI)) continue;
                    try {
                        wSDLModel.startTransaction();
                        import_.setSchemaLocation(fileObject.getNameExt());
                    }
                    finally {
                        wSDLModel.endTransaction();
                    }
                }
            }
        }
    }

    private boolean wsdlOperationExists(WSDLModel wSDLModel, String string, String string2) {
        assert (wSDLModel != null);
        Collection collection = wSDLModel.getDefinitions().getPortTypes();
        Object object = null;
        for (Object object2 : collection) {
            if (!object2.getName().equals(string2)) continue;
            object = object2;
            break;
        }
        if (object != null) {
            Object object2;
            Collection collection2 = object.getOperations();
            object2 = collection2.iterator();
            while (object2.hasNext()) {
                Operation operation = (Operation)object2.next();
                if (!operation.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addOperation(FileObject fileObject) {
        this.actionPerformed(null);
    }

    public boolean isEnabledInEditor(FileObject fileObject) {
        return this.service != null && this.service.getWsdlUrl() != null;
    }
}

