/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.UploadFilterDeferredFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class UploadFilterFileItem
implements FileItem {
    private static final long DEFAULT_MAX_FILE_SIZE = 1000000L;
    private static int counter = 0;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private UploadFilterDeferredFileOutputStream dfos;
    private long maxFileSize = 1000000L;
    private List errorLog = new ArrayList();
    private String clientFilePath;

    UploadFilterFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    UploadFilterFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository, long maxFileSize) {
        this(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
        this.maxFileSize = maxFileSize;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.dfos.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public String getClientFilePath() {
        return this.clientFilePath;
    }

    public String setClientFilePath(String clientFilePath) {
        this.clientFilePath = clientFilePath;
        return this.clientFilePath;
    }

    public boolean isInMemory() {
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.dfos.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.dfos.getFile());
            fis.read(fileData);
        }
        catch (IOException e) {
            fileData = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString() {
        return new String(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
            }
        }
        File outputFile = this.getStoreLocation();
        if (outputFile != null) {
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] bytes = new byte[2048];
                    int s = 0;
                    while ((s = in.read(bytes)) != -1) {
                        ((BufferedOutputStream)out).write(bytes, 0, s);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            throw new FileUploadException("Cannot write uploaded file to disk.");
        }
    }

    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            try {
                File outputFile = this.getTempFile();
                this.dfos = new UploadFilterDeferredFileOutputStream(this.sizeThreshold, outputFile, this.maxFileSize, this.errorLog);
            }
            catch (Exception e) {
                this.errorLog.add(e);
                this.dfos = new UploadFilterDeferredFileOutputStream();
                return this.dfos;
            }
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos.getFile();
    }

    public List getErrorLog() {
        return this.errorLog;
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected File getTempFile() {
        File tempDir = this.repository;
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        String fileName = "upload_" + UploadFilterFileItem.getUniqueId() + ".tmp";
        File f = new File(tempDir, fileName);
        f.deleteOnExit();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        Class<UploadFilterFileItem> clazz = UploadFilterFileItem.class;
        synchronized (UploadFilterFileItem.class) {
            int current = counter++;
            // ** MonitorExit[var1] (shouldn't be in output)
            String id = Integer.toString(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }
}

