/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.theme.JSFThemeContext;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeContext;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaScriptUtilities {
    private static final String DEBUG_KEY = "com_sun_webui_jsf_util_debug";
    private static final String JSFX_KEY = "com_sun_webui_jsf_util_jsfx";
    private static final String PARSE_ONLOAD_KEY = "com_sun_webui_jsf_util_parseOnLoad";
    private static final String STYLESHEET_KEY = "com_sun_webui_jsf_util_styleSheet";
    private static final String WEBUI_ALL_KEY = "com_sun_webui_jsf_util_webuiAll";
    private static final String WEBUI_JSFX_KEY = "com_sun_webui_jsf_util_webuiJsfx";

    public static boolean isDebug() {
        return JavaScriptUtilities.isEnabled(DEBUG_KEY, "debug");
    }

    public static void setDebug(boolean enable) {
        JavaScriptUtilities.getRequestMap().put(DEBUG_KEY, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isJsfx() {
        return JavaScriptUtilities.isEnabled(JSFX_KEY, "jsfx");
    }

    public static void setJsfx(boolean include) {
        JavaScriptUtilities.getRequestMap().put(JSFX_KEY, include ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isParseOnLoad() {
        return JavaScriptUtilities.isEnabled(PARSE_ONLOAD_KEY, "parseOnLoad");
    }

    public static void setParseOnLoad(boolean enable) {
        JavaScriptUtilities.getRequestMap().put(PARSE_ONLOAD_KEY, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isStyleSheet() {
        return JavaScriptUtilities.isEnabled(STYLESHEET_KEY, "styleSheet");
    }

    public static void setStyleSheet(boolean enable) {
        JavaScriptUtilities.getRequestMap().put(STYLESHEET_KEY, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isWebuiAll() {
        return JavaScriptUtilities.isEnabled(WEBUI_ALL_KEY, "webuiAll");
    }

    public static void setWebuiAll(boolean include) {
        JavaScriptUtilities.getRequestMap().put(WEBUI_ALL_KEY, include ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isWebuiJsfx() {
        return JavaScriptUtilities.isEnabled(WEBUI_JSFX_KEY, "webuiJsfx");
    }

    public static void setWebuiJsfx(boolean include) {
        JavaScriptUtilities.getRequestMap().put(WEBUI_JSFX_KEY, include ? Boolean.TRUE : Boolean.FALSE);
    }

    public static String getDomNode(FacesContext context, UIComponent component) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("document.getElementById('").append(component.getClientId(context)).append("')");
        return buff.toString();
    }

    public static String getModule(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getModuleName("dojo")).append(".require('").append(JavaScriptUtilities.getModuleName(name)).append("');");
        return buff.toString();
    }

    public static String getModuleName(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getTheme().getJSString("module"));
        if (name != null) {
            buff.append(".").append(name);
        }
        return buff.toString();
    }

    public static String getWidget(FacesContext context, UIComponent component) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getModuleName("dojo")).append(".widget.byId('").append(component.getClientId(context)).append("')");
        return buff.toString();
    }

    public static void renderBootstrap(UIComponent component, ResponseWriter writer) throws IOException, JSONException {
        JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getBootstrapConfig());
        JavaScriptUtilities.renderBootstrapInclude(component, writer);
        if (JavaScriptUtilities.isJsfx() && JavaScriptUtilities.isWebuiJsfx()) {
            JavaScriptUtilities.renderPrototypeInclude(component, writer);
            JavaScriptUtilities.renderJsfxInclude(component, writer);
        }
    }

    public static void renderJavaScript(UIComponent component, ResponseWriter writer, String js) throws IOException {
        JavaScriptUtilities.renderJavaScript(component, writer, js, false);
    }

    public static void renderJavaScript(UIComponent component, ResponseWriter writer, String js, boolean defer) throws IOException {
        if (js == null) {
            return;
        }
        JavaScriptUtilities.renderJavaScriptBegin(component, writer, defer);
        writer.write(js);
        JavaScriptUtilities.renderJavaScriptEnd(component, writer, defer);
    }

    public static void renderJavaScriptBegin(UIComponent component, ResponseWriter writer, boolean defer) throws IOException {
        if (JavaScriptUtilities.isDebug()) {
            writer.write("\n");
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (defer) {
            writer.write(JavaScriptUtilities.getModuleName("dojo"));
            writer.write(".addOnLoad(function() {");
        }
    }

    public static void renderJavaScriptEnd(UIComponent component, ResponseWriter writer, boolean defer) throws IOException {
        if (defer) {
            writer.write("});");
        }
        writer.endElement("script");
    }

    private static JSONObject getAjaxConfig() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("module", (Object)JavaScriptUtilities.getTheme().getPathToJSFile("ajaxModule")).put("isJsfx", JavaScriptUtilities.isJsfx());
        return json;
    }

    private static String getBootstrapConfig() throws JSONException {
        Theme theme = JavaScriptUtilities.getTheme();
        JSONObject json = new JSONObject();
        StringBuffer buff = new StringBuffer(256);
        buff.append("var ").append(JavaScriptUtilities.getModuleName(null).replace('.', '_')).append("=");
        json.put("ajax", (Object)JavaScriptUtilities.getAjaxConfig()).put("isDebug", JavaScriptUtilities.isDebug()).put("modulePath", (Object)theme.getPathToJSFile(JavaScriptUtilities.isDebug() ? "modulePathUncompressed" : "modulePath")).put("parseOnLoad", JavaScriptUtilities.isParseOnLoad()).put("theme", (Object)JavaScriptUtilities.getThemeConfig(FacesContext.getCurrentInstance())).put("isStyleSheet", JavaScriptUtilities.isStyleSheet()).put("webuiAll", JavaScriptUtilities.isWebuiAll()).put("webuiJsfx", JavaScriptUtilities.isWebuiJsfx());
        buff.append(JSONUtilities.getString(json)).append(";");
        return buff.toString();
    }

    private static JSONObject getThemeConfig(FacesContext context) throws JSONException {
        Theme theme = JavaScriptUtilities.getTheme();
        String themeModulePath = theme.getPathToJSFile(JavaScriptUtilities.isDebug() ? "themeModulePathUncompressed" : "themeModulePath");
        String themeBundle = theme.getJSString("themeBundle");
        String themeLocale = context.getViewRoot().getLocale().toString().toLowerCase().replaceAll("_", "-");
        ThemeContext themeContext = JSFThemeContext.getInstance(context);
        JSONArray customThemes = null;
        String[] customThemeResources = themeContext.getThemeResources();
        if (customThemeResources != null) {
            customThemes = new JSONArray();
            for (int i = 0; i < customThemeResources.length; ++i) {
                customThemes.put(i, (Object)customThemeResources[i]);
            }
        }
        JSONObject json = new JSONObject();
        json.put("bundle", (Object)themeBundle).put("custom", (Object)customThemes).put("locale", (Object)themeLocale).put("modulePath", (Object)themeModulePath);
        return json;
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static Map getRequestMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
    }

    private static Map getRequestParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    private static boolean isEnabled(String requestKey, String paramKey) {
        boolean result = false;
        String s = (String)JavaScriptUtilities.getRequestParameterMap().get(paramKey);
        if (s != null) {
            result = true;
            StringTokenizer st = new StringTokenizer(s, "=");
            if (st.hasMoreTokens()) {
                result = new Boolean(st.nextToken());
            }
        } else {
            Boolean b = (Boolean)JavaScriptUtilities.getRequestMap().get(requestKey);
            if (b != null) {
                result = b;
            }
        }
        return result;
    }

    private static void renderBootstrapInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, JavaScriptUtilities.isDebug() ? "bootstrapUncompressed" : "bootstrap");
    }

    private static void renderJavaScriptInclude(UIComponent component, ResponseWriter writer, String file) throws IOException {
        if (file == null) {
            return;
        }
        String jsFile = JavaScriptUtilities.getTheme().getPathToJSFile(file);
        if (jsFile == null) {
            return;
        }
        if (JavaScriptUtilities.isDebug()) {
            writer.write("\n");
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)jsFile, null);
        writer.endElement("script");
    }

    private static void renderJsfxInclude(UIComponent component, ResponseWriter writer) throws IOException {
        Map requestMap = JavaScriptUtilities.getRequestMap();
        if (!requestMap.containsKey("com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax.js")) {
            requestMap.put("com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax.js", Boolean.TRUE);
        }
    }

    private static void renderPrototypeInclude(UIComponent component, ResponseWriter writer) throws IOException {
        Map map = JavaScriptUtilities.getRequestMap();
        if (!map.containsKey("com.sun.faces.extensions.avatar.LINKED/prototype.js")) {
            map.put("com.sun.faces.extensions.avatar.LINKED/prototype.js", Boolean.TRUE);
        }
    }
}

