/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.renderkit.widget.RbCbRendererBase;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;

public class CheckboxRenderer
extends RbCbRendererBase {
    public void decode(FacesContext context, UIComponent component) {
        String[] newValues;
        Map requestParameterValuesMap;
        if (!(component instanceof Checkbox)) {
            throw new IllegalArgumentException("CheckboxRenderer can only decode Checkbox components.");
        }
        if (ComponentUtilities.isDisabled(component) || ComponentUtilities.isReadOnly(component)) {
            return;
        }
        Checkbox checkbox = (Checkbox)component;
        String name = checkbox.getName();
        boolean inGroup = name != null;
        String componentId = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            componentId = ((ComplexComponent)component).getLabeledElementId(context);
        }
        if (name == null) {
            name = componentId;
        }
        if ((requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap()).containsKey(name) && ((newValues = (String[])requestParameterValuesMap.get(name)) != null || newValues.length != 0)) {
            String selectedValueAsString = null;
            Object selectedValue = checkbox.getSelectedValue();
            if (inGroup && selectedValue instanceof Boolean) {
                selectedValueAsString = componentId;
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{selectedValue.toString()});
                    return;
                }
            } else {
                selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{newValues[i]});
                    return;
                }
            }
            ((UIInput)component).setSubmittedValue((Object)new String[0]);
            return;
        }
        ((UIInput)component).setSubmittedValue((Object)new String[0]);
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.checkbox");
    }

    protected boolean isSelected(FacesContext context, UIComponent component) {
        return ((Checkbox)component).isChecked();
    }
}

