/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Accordion;
import com.sun.webui.jsf.component.AccordionTab;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccordionTabRenderer
extends RendererBase {
    private static final String[] intAttributes = new String[]{"contentHeight"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String hiddenFieldId = id + ":selectedState";
        Object valueObject = params.get(hiddenFieldId);
        String value = null;
        if (valueObject != null) {
            value = ((String)valueObject).trim();
            AccordionTab accTab = (AccordionTab)component;
            boolean selectedState = Boolean.parseBoolean(value);
            accTab.setSelected(selectedState);
            if (selectedState) {
                Accordion pAcc;
                UIComponent parent = accTab.getParent();
                if (parent instanceof AccordionTab) {
                    AccordionTab pTab = (AccordionTab)parent;
                    if (!pTab.isMultipleSelect()) {
                        pTab.setSelectedTab(accTab);
                    }
                } else if (parent instanceof Accordion && !(pAcc = (Accordion)parent).isMultipleSelect()) {
                    pAcc.setSelectedTab(accTab);
                }
            }
        }
    }

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws IOException, JSONException {
        AccordionTab content = (AccordionTab)component;
        JSONObject json = new JSONObject();
        json.put("className", (Object)content.getStyleClass()).put("style", (Object)content.getStyle()).put("selected", content.isSelected()).put("visible", content.isVisible()).put("focusId", (Object)content.getFocusId()).put("title", (Object)content.getTitle());
        JSONArray tabContent = new JSONArray();
        this.appendChildProps(content, context, tabContent);
        json.put("tabContent", (Object)tabContent);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        return JavaScriptUtilities.getModuleName("widget.accordionTab");
    }

    private void appendChildProps(AccordionTab component, FacesContext context, JSONArray jArray) throws IOException, JSONException {
        if (component.getTabChildCount() == 0) {
            for (UIComponent kid : component.getChildren()) {
                if (kid.getId().equals("selectedState")) continue;
                jArray.put((Object)WidgetUtilities.renderComponent(context, kid));
            }
        } else {
            for (UIComponent kid : component.getChildren()) {
                if (!(kid instanceof AccordionTab)) continue;
                this.appendChildProps((AccordionTab)kid, context, jArray);
            }
        }
    }
}

