/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Tree;
import com.sun.webui.jsf.component.TreeNode;
import com.sun.webui.jsf.renderkit.html.TreeNodeRenderer;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONObject;

public class TreeRenderer
extends TreeNodeRenderer {
    private static final String SKIPTREE_LINK = "skipTreeLink";

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String childID;
        TreeNode childNode;
        boolean hasRootImageFacet;
        Iterator messages = context.getMessages();
        if (messages != null) {
            while (messages.hasNext()) {
                FacesMessage fm = (FacesMessage)messages.next();
                LogUtil.fine(fm.getSummary());
                LogUtil.fine(fm.getDetail());
            }
        }
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Tree node = (Tree)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.write("\n\n\n");
        writer.startElement("div", (UIComponent)node);
        writer.writeAttribute("id", (Object)node.getClientId(context), null);
        String nodeStyleClass = theme.getStyleClass("TREE");
        if (!node.isVisible()) {
            nodeStyleClass = theme.getStyleClass("HIDDEN");
        } else if (node.getStyleClass() != null) {
            nodeStyleClass = node.getStyleClass();
        }
        writer.writeAttribute("class", (Object)nodeStyleClass, null);
        if (node.getStyle() != null) {
            writer.writeAttribute("style", (Object)node.getStyle(), null);
        }
        writer.write("\n");
        RenderingUtilities.renderSkipLink(SKIPTREE_LINK, theme.getStyleClass("SKIP_WHITE"), null, theme.getMessage("tree.skipTagAltText"), null, (UIComponent)node, context);
        writer.write("\n");
        writer.write("\n");
        String rootText = node.getText();
        String rootImageURL = node.getImageURL();
        boolean hasRootContentFacet = node.getFacet("content") != null;
        boolean bl = hasRootImageFacet = node.getFacet("image") != null;
        if (rootText != null && rootText.length() > 0 || rootImageURL != null || hasRootImageFacet || hasRootContentFacet) {
            String titlebarSpacerDivID = node.getClientId(context) + "TitleBarSpacer";
            String titlebarDivID = node.getClientId(context) + "TitleBar";
            String lineImageDivID = node.getClientId(context) + "LineImages";
            String lineTxtDivID = node.getClientId(context) + "LineText";
            writer.startElement("div", (UIComponent)node);
            writer.writeAttribute("id", (Object)titlebarSpacerDivID, null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TREE_ROOT_ROW_HEADER"), null);
            writer.endElement("div");
            writer.write("\n");
            writer.startElement("div", (UIComponent)node);
            writer.writeAttribute("id", (Object)titlebarDivID, null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TREE_ROOT_ROW"), null);
            writer.write("\n");
            Iterator imageIter = node.getImageKeys().iterator();
            if (node.getUrl() != null && node.getUrl().length() > 0 || hasRootContentFacet) {
                this.renderTreeRow(node, imageIter, context, writer);
            } else {
                writer.write("\n");
                writer.startElement("span", (UIComponent)node);
                writer.writeAttribute("class", (Object)theme.getStyleClass("TREE_TITLE"), null);
                writer.write("\n");
                this.renderTreeRow(node, imageIter, context, writer);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
        Iterator iter = node.getChildren().iterator();
        String clientID = node.getClientId(context);
        writer.startElement("div", (UIComponent)node);
        writer.writeAttribute("id", (Object)(clientID + "_children"), null);
        while (iter.hasNext()) {
            UIComponent comp = (UIComponent)iter.next();
            if (!(comp instanceof TreeNode)) continue;
            RenderingUtilities.renderComponent(comp, context);
        }
        writer.endElement("div");
        String nodeID = null;
        if (node.getSelected() != null && (childNode = node.getChildNode(childID = node.getSelected())) != null) {
            nodeID = childNode.getClientId(context);
        }
        try {
            StringBuffer buff = new StringBuffer(256);
            JSONObject json = new JSONObject();
            json.put("id", (Object)clientID);
            String jsObject = JavaScriptUtilities.getDomNode(context, (UIComponent)node);
            buff.append(JavaScriptUtilities.getModule("tree")).append("\n").append(JavaScriptUtilities.getModuleName("tree._init")).append("(").append(JSONUtilities.getString(json)).append(");\n");
            if (nodeID != null) {
                buff.append(jsObject).append(".selectTreeNode('").append(nodeID).append("');");
            } else {
                buff.append(jsObject).append(".updateHighlight('").append(clientID).append("');");
            }
            JavaScriptUtilities.renderJavaScript(component, writer, buff.toString(), JavaScriptUtilities.isParseOnLoad());
            RenderingUtilities.renderAnchor(SKIPTREE_LINK, (UIComponent)node, context);
            writer.write("\n");
            writer.endElement("div");
        }
        catch (Exception e) {
            LogUtil.warning(e.getMessage(), e);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }
}

