/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model.login;

import com.sun.webui.jsf.model.login.JaasController;
import com.sun.webui.jsf.model.login.LoginCallback;
import com.sun.webui.jsf.model.login.LoginCallbackHandler;
import com.sun.webui.jsf.model.login.LoginConstants;
import com.sun.webui.jsf.model.login.LoginController;
import com.sun.webui.jsf.util.LogUtil;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JaasLoginController
implements LoginController {
    private LoginCallbackHandler acbh = null;
    private LoginCallback lcb = null;
    private Subject subject = null;
    private String serviceName = null;

    public void initialize(Object requestObj, String serviceName) {
        HttpServletRequest request = (HttpServletRequest)requestObj;
        this.serviceName = serviceName;
        this.acbh = new LoginCallbackHandler(request);
        this.subject = new Subject();
        JaasController jc = new JaasController(request, this.acbh, serviceName, this.subject);
        Thread loginThread = new Thread(jc);
        loginThread.start();
        request.getSession().setAttribute("loginThread", (Object)loginThread);
        request.getSession().removeAttribute("moduleClass");
        try {
            this.handleCommunication(request, loginThread);
        }
        catch (IOException e) {
            this.abort(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Object requestObj, LoginCallback lcb) {
        HttpServletRequest request = (HttpServletRequest)requestObj;
        LoginConstants.LOGINSTATE state = lcb.getLoginState();
        if (state.equals((Object)LoginConstants.LOGINSTATE.INIT)) {
            this.acbh = new LoginCallbackHandler(request);
            this.subject = new Subject();
            JaasController jc = new JaasController(request, this.acbh, this.serviceName, this.subject);
            Thread loginThread2 = new Thread(jc);
            loginThread2.start();
            request.getSession().setAttribute("loginThread", (Object)loginThread2);
            request.getSession().removeAttribute("moduleClass");
            try {
                this.handleCommunication(request, loginThread2);
            }
            catch (IOException e) {
                this.abort(request);
            }
        } else if (state.equals((Object)LoginConstants.LOGINSTATE.CONTINUE)) {
            Thread loginThread = (Thread)request.getSession().getAttribute("loginThread");
            if (loginThread != null) {
                Thread loginThread2 = loginThread;
                synchronized (loginThread2) {
                    request.getSession().setAttribute("clientconv", (Object)"dataEntryComplete");
                    loginThread.notifyAll();
                    request.getSession().setAttribute("dataParms", (Object)lcb);
                    request.getSession().setAttribute("clientconv", (Object)"dataEntryComplete");
                }
            } else {
                this.acbh = new LoginCallbackHandler(request);
                this.subject = new Subject();
                JaasController jc = new JaasController(request, this.acbh, this.serviceName, this.subject);
                request.getSession().setAttribute("dataParms", (Object)lcb);
                request.getSession().setAttribute("clientconv", (Object)"dataEntryComplete");
                loginThread = new Thread(jc);
                loginThread.start();
                request.getSession().setAttribute("loginThread", (Object)loginThread);
            }
            try {
                this.handleCommunication(request, loginThread);
            }
            catch (IOException e) {
                this.abort(request);
            }
        } else {
            LogUtil.severe("Login component has reached an invalid state: " + (Object)((Object)state));
        }
    }

    public void commit(Object requestObj) {
        HttpServletRequest request = (HttpServletRequest)requestObj;
    }

    public void abort(Object requestObj) {
        HttpServletRequest request = (HttpServletRequest)requestObj;
    }

    public LoginCallback getCallbackObject() {
        return this.lcb;
    }

    public LoginConstants.LOGINSTATE getLoginState() {
        return this.lcb.getLoginState();
    }

    public Object getAuthenticatedEntity() {
        if (this.getLoginState().equals((Object)LoginConstants.LOGINSTATE.SUCCESS)) {
            return this.subject;
        }
        return null;
    }

    private void handleCommunication(HttpServletRequest request, Thread loginThread) throws IOException {
        HttpSession session = request.getSession();
        session = request.getSession(true);
        this.lcb = this.getCallbackResponse(loginThread, session);
        if (this.lcb != null) {
            LoginConstants.LOGINSTATE loginState = this.lcb.getLoginState();
            if (loginState.equals((Object)LoginConstants.LOGINSTATE.FAILURE)) {
                Exception ex = (Exception)session.getAttribute("jaasloginexception");
                if (ex != null) {
                    this.lcb.setMessage("ERROR", "login.errorSummary", "login.errorDetail");
                }
                this.subject = null;
                this.acbh = null;
            } else if (loginState.equals((Object)LoginConstants.LOGINSTATE.SUCCESS)) {
                this.acbh = null;
            } else {
                this.lcb.setLoginState(LoginConstants.LOGINSTATE.CONTINUE);
            }
        } else {
            LogUtil.warning("null callback object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginCallback getCallbackResponse(Thread loginThread, HttpSession session) {
        try {
            Thread thread = loginThread;
            synchronized (thread) {
                LoginCallback callbackStatus = (LoginCallback)session.getAttribute("serverconv");
                while (callbackStatus == null) {
                    loginThread.wait();
                    callbackStatus = (LoginCallback)session.getAttribute("serverconv");
                }
                session.removeAttribute("serverconv");
                return callbackStatus;
            }
        }
        catch (Exception ex) {
            LogUtil.severe("Exception iwaiting for server", ex);
            return null;
        }
    }
}

