/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSourceTaskFactory {
    private static final Logger LOG = Logger.getLogger(JavaSourceTaskFactory.class.getName());
    static final String BEFORE_ADDING_REMOVING_TASKS = "beforeAddingRemovingTasks";
    static final String FILEOBJECTS_COMPUTATION = "fileObjectsComputation";
    private final JavaSource.Phase phase;
    private final JavaSource.Priority priority;
    static boolean SYNCHRONOUS_EVENTS = false;
    private final Map<FileObject, CancellableTask<CompilationInfo>> file2Task;
    private final Map<FileObject, JavaSource> file2JS;
    private static RequestProcessor WORKER = new RequestProcessor("JavaSourceTaskFactory", 1);
    static Accessor2 ACCESSOR2;

    protected JavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority) {
        this.phase = phase;
        this.priority = priority;
        this.file2Task = new HashMap<FileObject, CancellableTask<CompilationInfo>>();
        this.file2JS = new HashMap<FileObject, JavaSource>();
    }

    protected abstract CancellableTask<CompilationInfo> createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        LOG.log(Level.FINEST, FILEOBJECTS_COMPUTATION);
        final ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.getFileObjects());
        if (SYNCHRONOUS_EVENTS) {
            this.stateChangedImpl(arrayList);
        } else {
            WORKER.post(new Runnable(){

                public void run() {
                    JavaSourceTaskFactory.this.stateChangedImpl(arrayList);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(List<FileObject> list) {
        HashMap<JavaSource, CancellableTask<CompilationInfo>> hashMap = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        HashMap<JavaSource, CancellableTask<CompilationInfo>> hashMap2 = new HashMap<JavaSource, CancellableTask<CompilationInfo>>();
        Iterator iterator = this;
        synchronized (iterator) {
            JavaSource javaSource;
            Map.Entry entry = new ArrayList<FileObject>(list);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.file2Task.keySet());
            entry.removeAll(this.file2Task.keySet());
            arrayList.removeAll(list);
            for (FileObject fileObject : arrayList) {
                javaSource = this.file2JS.remove(fileObject);
                if (javaSource == null) continue;
                hashMap.put(javaSource, this.file2Task.remove(fileObject));
            }
            Iterator iterator2 = entry.iterator();
            while (iterator2.hasNext()) {
                FileObject fileObject;
                fileObject = (FileObject)iterator2.next();
                if (fileObject == null || !fileObject.isValid() || (javaSource = JavaSource.forFileObject(fileObject)) == null) continue;
                CancellableTask<CompilationInfo> cancellableTask = this.createTask(fileObject);
                hashMap2.put(javaSource, cancellableTask);
                this.file2Task.put(fileObject, cancellableTask);
                this.file2JS.put(fileObject, javaSource);
            }
        }
        LOG.log(Level.FINEST, BEFORE_ADDING_REMOVING_TASKS);
        for (Map.Entry entry : hashMap.entrySet()) {
            ACCESSOR2.removePhaseCompletionTask((JavaSource)entry.getKey(), (CancellableTask)entry.getValue());
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            try {
                ACCESSOR2.addPhaseCompletionTask((JavaSource)entry.getKey(), (CancellableTask)entry.getValue(), this.phase, this.priority);
            }
            catch (FileObjects.InvalidFileException invalidFileException) {
                LOG.info("JavaSource.addPhaseCompletionTask called on deleted file");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected final synchronized void reschedule(FileObject fileObject) throws IllegalArgumentException {
        JavaSource javaSource = this.file2JS.get(fileObject);
        if (javaSource == null) {
            return;
        }
        CancellableTask<CompilationInfo> cancellableTask = this.file2Task.get(fileObject);
        if (cancellableTask == null) {
            return;
        }
        ACCESSOR2.rescheduleTask(javaSource, cancellableTask);
    }

    static {
        JavaSourceTaskFactoryManager.ACCESSOR = new JavaSourceTaskFactoryManager.Accessor(){

            public void fireChangeEvent(JavaSourceTaskFactory javaSourceTaskFactory) {
                javaSourceTaskFactory.fileObjectsChanged();
            }
        };
        ACCESSOR2 = new Accessor2(){

            @Override
            public void addPhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask, JavaSource.Phase phase, JavaSource.Priority priority) throws IOException {
                javaSource.addPhaseCompletionTask(cancellableTask, phase, priority);
            }

            @Override
            public void removePhaseCompletionTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
                javaSource.removePhaseCompletionTask(cancellableTask);
            }

            @Override
            public void rescheduleTask(JavaSource javaSource, CancellableTask<CompilationInfo> cancellableTask) {
                javaSource.rescheduleTask(cancellableTask);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Accessor2 {
        public void addPhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2, JavaSource.Phase var3, JavaSource.Priority var4) throws IOException;

        public void removePhaseCompletionTask(JavaSource var1, CancellableTask<CompilationInfo> var2);

        public void rescheduleTask(JavaSource var1, CancellableTask<CompilationInfo> var2);
    }
}

