/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.DefaultPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformNode;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformConvertor
implements Environment.Provider,
InstanceCookie.Of,
PropertyChangeListener,
Runnable,
InstanceContent.Convertor {
    private static final String CLASSIC = "classic";
    private static final String MODERN = "modern";
    private static final String JAVAC13 = "javac1.3";
    static final String[] IMPORTANT_TOOLS = new String[]{"javac", "java", "javadoc"};
    private static final String PLATFORM_DTD_ID = "-//NetBeans//DTD Java PlatformDefinition 1.0//EN";
    InstanceContent cookies = new InstanceContent();
    private XMLDataObject holder;
    private boolean defaultPlatform;
    private Lookup lookup;
    private RequestProcessor.Task saveTask;
    private Reference<JavaPlatform> refPlatform = new WeakReference<Object>(null);
    private LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
    static int DELAY = 2000;
    static final String ELEMENT_PROPERTIES = "properties";
    static final String ELEMENT_SYSPROPERTIES = "sysproperties";
    static final String ELEMENT_PROPERTY = "property";
    static final String ELEMENT_PLATFORM = "platform";
    static final String ELEMENT_JDKHOME = "jdkhome";
    static final String ELEMENT_SOURCEPATH = "sources";
    static final String ELEMENT_JAVADOC = "javadoc";
    static final String ELEMENT_RESOURCE = "resource";
    static final String ATTR_PLATFORM_NAME = "name";
    static final String ATTR_PLATFORM_DEFAULT = "default";
    static final String ATTR_PROPERTY_NAME = "name";
    static final String ATTR_PROPERTY_VALUE = "value";

    private PlatformConvertor() {
    }

    public static PlatformConvertor createProvider(FileObject fileObject) {
        return new PlatformConvertor();
    }

    public Lookup getEnvironment(DataObject dataObject) {
        return new PlatformConvertor((XMLDataObject)dataObject).getLookup();
    }

    private PlatformConvertor(XMLDataObject xMLDataObject) {
        this.holder = xMLDataObject;
        this.holder.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(final FileEvent fileEvent) {
                if (!PlatformConvertor.this.defaultPlatform) {
                    try {
                        ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                            public Void run() throws IOException {
                                String string = fileEvent.getFile().getName();
                                String string2 = "platforms." + string + ".";
                                boolean bl = false;
                                EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                                Iterator iterator = editableProperties.keySet().iterator();
                                while (iterator.hasNext()) {
                                    String string3 = (String)iterator.next();
                                    if (!string3.startsWith(string2)) continue;
                                    iterator.remove();
                                    bl = true;
                                }
                                if (bl) {
                                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                                }
                                return null;
                            }
                        });
                    }
                    catch (MutexException mutexException) {
                        ErrorManager.getDefault().notify((Throwable)mutexException);
                    }
                }
            }
        });
        this.cookies = new InstanceContent();
        this.cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.cookies);
        this.cookies.add(Node.class, (InstanceContent.Convertor)this);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public Class instanceClass() {
        return JavaPlatform.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            XMLReader xMLReader;
            JavaPlatform javaPlatform = this.refPlatform.get();
            if (javaPlatform != null) {
                return javaPlatform;
            }
            H h = new H();
            try {
                xMLReader = XMLUtil.createXMLReader();
                InputSource inputSource = new InputSource(this.holder.getPrimaryFile().getInputStream());
                inputSource.setSystemId(this.holder.getPrimaryFile().getURL().toExternalForm());
                xMLReader.setContentHandler(h);
                xMLReader.setErrorHandler(h);
                xMLReader.setEntityResolver(h);
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                sAXException.printStackTrace();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(sAXException.getMessage());
            }
            xMLReader = this.createPlatform(h);
            this.refPlatform = new WeakReference<XMLReader>(xMLReader);
            return xMLReader;
        }
    }

    JavaPlatform createPlatform(H h) {
        JavaPlatform javaPlatform;
        if (h.isDefault) {
            javaPlatform = DefaultPlatformImpl.create(h.properties, h.sources, h.javadoc);
            this.defaultPlatform = true;
        } else {
            javaPlatform = new J2SEPlatformImpl(h.name, h.installFolders, h.properties, h.sysProperties, h.sources, h.javadoc);
            this.defaultPlatform = false;
        }
        javaPlatform.addPropertyChangeListener((PropertyChangeListener)this);
        return javaPlatform;
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public boolean instanceOf(Class<?> clazz) {
        return clazz.isAssignableFrom(JavaPlatform.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            if (this.saveTask == null) {
                this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
            }
        }
        platformConvertor = this;
        synchronized (platformConvertor) {
            this.keepAlive.add(propertyChangeEvent);
        }
        this.saveTask.schedule(DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PropertyChangeEvent propertyChangeEvent;
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            propertyChangeEvent = this.keepAlive.removeFirst();
        }
        platformConvertor = (JavaPlatform)propertyChangeEvent.getSource();
        try {
            this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new W((JavaPlatform)platformConvertor, (MultiDataObject)this.holder, this.defaultPlatform));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public Object convert(Object object) {
        if (object == Node.class) {
            try {
                J2SEPlatformImpl j2SEPlatformImpl = (J2SEPlatformImpl)((Object)this.instanceCreate());
                return new J2SEPlatformNode(j2SEPlatformImpl, (DataObject)this.holder);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    public String displayName(Object object) {
        return ((Class)object).getName();
    }

    public String id(Object object) {
        return object.toString();
    }

    public Class type(Object object) {
        return (Class)object;
    }

    public static DataObject create(final JavaPlatform javaPlatform, DataFolder dataFolder, final String string) throws IOException {
        W w = new W(javaPlatform, dataFolder, string);
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)w);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    PlatformConvertor.generatePlatformProperties(javaPlatform, string, editableProperties);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exception exception = mutexException.getException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IllegalStateException();
        }
        return w.holder;
    }

    public static void generatePlatformProperties(JavaPlatform javaPlatform, String string, EditableProperties editableProperties) throws IOException {
        String string2 = PlatformConvertor.createName(string, "home");
        String string3 = PlatformConvertor.createName(string, "bootclasspath");
        String string4 = PlatformConvertor.createName(string, "compiler");
        if (editableProperties.getProperty(string2) != null || editableProperties.getProperty(string3) != null || editableProperties.getProperty(string4) != null) {
            String string5 = NbBundle.getMessage(J2SEWizardIterator.class, (String)"ERROR_InvalidName");
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string5), 256, null, string5, null, null);
        }
        Collection collection = javaPlatform.getInstallFolders();
        if (collection.size() > 0) {
            Object object;
            URL uRL;
            File file = FileUtil.toFile((FileObject)((FileObject)collection.iterator().next()));
            editableProperties.setProperty(string2, file.getAbsolutePath());
            ClassPath classPath = javaPlatform.getBootstrapLibraries();
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object2 : classPath.entries()) {
                uRL = object2.getURL();
                if ("jar".equals(uRL.getProtocol())) {
                    uRL = FileUtil.getArchiveFile((URL)uRL);
                }
                object = new File(URI.create(uRL.toExternalForm()));
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append(PlatformConvertor.normalizePath((File)object, file, string2));
            }
            editableProperties.setProperty(string3, stringBuffer.toString());
            editableProperties.setProperty(string4, PlatformConvertor.getCompilerType(javaPlatform));
            for (int i = 0; i < IMPORTANT_TOOLS.length; ++i) {
                Object object2;
                object2 = IMPORTANT_TOOLS[i];
                uRL = javaPlatform.findTool((String)object2);
                if (uRL != null) {
                    if (PlatformConvertor.isDefaultLocation((FileObject)uRL, javaPlatform.getInstallFolders())) continue;
                    object = PlatformConvertor.createName(string, (String)object2);
                    editableProperties.setProperty((String)object, PlatformConvertor.normalizePath(PlatformConvertor.getToolPath((FileObject)uRL), file, string2));
                    continue;
                }
                throw new BrokenPlatformException((String)object2);
            }
        }
    }

    public static String createName(String string, String string2) {
        return "platforms." + string + "." + string2;
    }

    private static String getCompilerType(JavaPlatform javaPlatform) {
        assert (javaPlatform != null);
        String string = (String)javaPlatform.getSystemProperties().get("java.specification.version");
        assert (string != null);
        SpecificationVersion specificationVersion = new SpecificationVersion(string);
        SpecificationVersion specificationVersion2 = new SpecificationVersion("1.3");
        int n = specificationVersion.compareTo((Object)specificationVersion2);
        if (n < 0) {
            return CLASSIC;
        }
        if (n == 0) {
            return JAVAC13;
        }
        return MODERN;
    }

    private static boolean isDefaultLocation(FileObject fileObject, Collection<FileObject> collection) {
        assert (fileObject != null && collection != null);
        if (collection.size() != 1) {
            return false;
        }
        FileObject fileObject2 = collection.iterator().next();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return stringTokenizer.countTokens() == 2 && "bin".equals(stringTokenizer.nextToken());
    }

    private static File getToolPath(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        return new File(URI.create(fileObject.getURL().toExternalForm()));
    }

    private static String normalizePath(File file, File file2, String string) {
        String string2;
        String string3 = file2.getAbsolutePath();
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        if ((string2 = file.getAbsolutePath()).startsWith(string3)) {
            return "${" + string + "}" + File.separator + string2.substring(string3.length());
        }
        return string2;
    }

    static class H
    extends DefaultHandler
    implements EntityResolver {
        Map<String, String> properties;
        Map<String, String> sysProperties;
        List<URL> sources;
        List<URL> javadoc;
        List<URL> installFolders;
        String name;
        boolean isDefault;
        private Map<String, String> propertyMap;
        private StringBuffer buffer;
        private List<URL> path;

        H() {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (PlatformConvertor.ELEMENT_PLATFORM.equals(string3)) {
                this.name = attributes.getValue("name");
                this.isDefault = "yes".equals(attributes.getValue(PlatformConvertor.ATTR_PLATFORM_DEFAULT));
            } else if (PlatformConvertor.ELEMENT_PROPERTIES.equals(string3)) {
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>(17);
                }
                this.propertyMap = this.properties;
            } else if (PlatformConvertor.ELEMENT_SYSPROPERTIES.equals(string3)) {
                if (this.sysProperties == null) {
                    this.sysProperties = new HashMap<String, String>(17);
                }
                this.propertyMap = this.sysProperties;
            } else if (PlatformConvertor.ELEMENT_PROPERTY.equals(string3)) {
                if (this.propertyMap == null) {
                    throw new SAXException("property w/o properties or sysproperties");
                }
                String string4 = attributes.getValue("name");
                if (string4 == null || "".equals(string4)) {
                    throw new SAXException("missing name");
                }
                String string5 = attributes.getValue(PlatformConvertor.ATTR_PROPERTY_VALUE);
                this.propertyMap.put(string4, string5);
            } else if (PlatformConvertor.ELEMENT_SOURCEPATH.equals(string3)) {
                this.sources = new ArrayList<URL>();
                this.path = this.sources;
            } else if (PlatformConvertor.ELEMENT_JAVADOC.equals(string3)) {
                this.javadoc = new ArrayList<URL>();
                this.path = this.javadoc;
            } else if (PlatformConvertor.ELEMENT_JDKHOME.equals(string3)) {
                this.installFolders = new ArrayList<URL>();
                this.path = this.installFolders;
            } else if (PlatformConvertor.ELEMENT_RESOURCE.equals(string3)) {
                this.buffer = new StringBuffer();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (PlatformConvertor.ELEMENT_PROPERTIES.equals(string3) || PlatformConvertor.ELEMENT_SYSPROPERTIES.equals(string3)) {
                this.propertyMap = null;
            } else if (PlatformConvertor.ELEMENT_SOURCEPATH.equals(string3) || PlatformConvertor.ELEMENT_JAVADOC.equals(string3)) {
                this.path = null;
            } else if (PlatformConvertor.ELEMENT_RESOURCE.equals(string3)) {
                try {
                    this.path.add(new URL(this.buffer.toString()));
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify((Throwable)malformedURLException);
                }
                this.buffer = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(cArray, n, n2);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (PlatformConvertor.PLATFORM_DTD_ID.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class W
    implements FileSystem.AtomicAction {
        JavaPlatform instance;
        MultiDataObject holder;
        String name;
        DataFolder f;
        boolean defaultPlatform;

        W(JavaPlatform javaPlatform, MultiDataObject multiDataObject, boolean bl) {
            this.instance = javaPlatform;
            this.holder = multiDataObject;
            this.defaultPlatform = bl;
        }

        W(JavaPlatform javaPlatform, DataFolder dataFolder, String string) {
            this.instance = javaPlatform;
            this.name = string;
            this.f = dataFolder;
            this.defaultPlatform = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            Object object;
            FileLock fileLock;
            FileObject fileObject;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.write(byteArrayOutputStream);
            }
            finally {
                byteArrayOutputStream.close();
            }
            if (this.holder != null) {
                fileObject = this.holder.getPrimaryEntry().getFile();
                fileLock = this.holder.getPrimaryEntry().takeLock();
            } else {
                object = this.f.getPrimaryFile();
                String string = FileUtil.findFreeFileName((FileObject)object, (String)this.name, (String)"xml");
                fileObject = object.createData(string, "xml");
                fileLock = fileObject.lock();
            }
            try {
                object = fileObject.getOutputStream(fileLock);
                try {
                    ((OutputStream)object).write(byteArrayOutputStream.toByteArray());
                    ((OutputStream)object).flush();
                }
                finally {
                    ((OutputStream)object).close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
            if (this.holder == null) {
                this.holder = (MultiDataObject)DataObject.find((FileObject)fileObject);
            }
        }

        void write(OutputStream outputStream) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Map map = this.instance.getProperties();
            Map map2 = this.instance.getSystemProperties();
            Document document = XMLUtil.createDocument((String)PlatformConvertor.ELEMENT_PLATFORM, null, (String)PlatformConvertor.PLATFORM_DTD_ID, (String)"http://www.netbeans.org/dtds/java-platformdefinition-1_0.dtd");
            Element element = document.getDocumentElement();
            element.setAttribute("name", this.instance.getDisplayName());
            element.setAttribute(PlatformConvertor.ATTR_PLATFORM_DEFAULT, this.defaultPlatform ? "yes" : "no");
            Element element2 = document.createElement(PlatformConvertor.ELEMENT_PROPERTIES);
            this.writeProperties(map, element2, document);
            element.appendChild(element2);
            if (!this.defaultPlatform) {
                object5 = document.createElement(PlatformConvertor.ELEMENT_SYSPROPERTIES);
                this.writeProperties(map2, (Element)object5, document);
                element.appendChild((org.w3c.dom.Node)object5);
                object4 = document.createElement(PlatformConvertor.ELEMENT_JDKHOME);
                object3 = this.instance.getInstallFolders().iterator();
                while (object3.hasNext()) {
                    object2 = ((FileObject)object3.next()).getURL();
                    object = document.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    object.appendChild(document.createTextNode(((URL)object2).toExternalForm()));
                    object4.appendChild((org.w3c.dom.Node)object);
                }
                element.appendChild((org.w3c.dom.Node)object4);
            }
            if ((object5 = this.instance.getSourceFolders().entries()).size() > 0 && this.shouldWriteSources()) {
                object4 = document.createElement(PlatformConvertor.ELEMENT_SOURCEPATH);
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = ((ClassPath.Entry)object3.next()).getURL();
                    object = document.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    object.appendChild(document.createTextNode(((URL)object2).toExternalForm()));
                    object4.appendChild((org.w3c.dom.Node)object);
                }
                element.appendChild((org.w3c.dom.Node)object4);
            }
            if ((object4 = this.instance.getJavadocFolders()).size() > 0 && this.shouldWriteJavadoc()) {
                object3 = document.createElement(PlatformConvertor.ELEMENT_JAVADOC);
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = (URL)object2.next();
                    Element element3 = document.createElement(PlatformConvertor.ELEMENT_RESOURCE);
                    element3.appendChild(document.createTextNode(((URL)object).toExternalForm()));
                    object3.appendChild(element3);
                }
                element.appendChild((org.w3c.dom.Node)object3);
            }
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF8");
        }

        void writeProperties(Map<String, String> map, Element element, Document document) throws IOException {
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            for (String string : treeSet) {
                String string2 = map.get(string);
                try {
                    XMLUtil.toAttributeValue((String)string);
                    XMLUtil.toAttributeValue((String)string2);
                    Element element2 = document.createElement(PlatformConvertor.ELEMENT_PROPERTY);
                    element2.setAttribute("name", string);
                    element2.setAttribute(PlatformConvertor.ATTR_PROPERTY_VALUE, string2);
                    element.appendChild(element2);
                }
                catch (CharConversionException charConversionException) {
                    Logger.getLogger("global").log(Level.WARNING, "Cannot store property: " + string + " value: " + string2);
                }
            }
        }

        private boolean shouldWriteSources() {
            if (this.defaultPlatform) {
                assert (this.instance instanceof DefaultPlatformImpl);
                DefaultPlatformImpl defaultPlatformImpl = (DefaultPlatformImpl)this.instance;
                List list = defaultPlatformImpl.getSourceFolders().entries();
                List<URL> list2 = DefaultPlatformImpl.getSources(FileUtil.normalizeFile((File)new File((String)defaultPlatformImpl.getSystemProperties().get("jdk.home"))));
                if (list2 == null || list.size() != list2.size()) {
                    return true;
                }
                Iterator iterator = list.iterator();
                Iterator<URL> iterator2 = list2.iterator();
                while (iterator.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)iterator.next();
                    URL uRL = iterator2.next();
                    if (uRL.equals(entry.getURL())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean shouldWriteJavadoc() {
            if (this.defaultPlatform) {
                assert (this.instance instanceof DefaultPlatformImpl);
                DefaultPlatformImpl defaultPlatformImpl = (DefaultPlatformImpl)this.instance;
                List<URL> list = defaultPlatformImpl.getJavadocFolders();
                List<URL> list2 = DefaultPlatformImpl.getJavadoc(FileUtil.normalizeFile((File)new File((String)defaultPlatformImpl.getSystemProperties().get("jdk.home"))));
                return list2 == null || !((Object)list).equals(list2);
            }
            return true;
        }
    }

    public static class BrokenPlatformException
    extends IOException {
        private final String toolName;

        public BrokenPlatformException(String string) {
            super("Cannot locate " + string + " command");
            this.toolName = string;
        }

        public String getMissingTool() {
            return this.toolName;
        }
    }
}

