/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.debugger;

import java.awt.Component;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.Util;

public class DebuggerWindowOperator
extends TopComponentOperator {
    ComponentOperator desktop = null;
    JTextComponentOperator query = null;
    private JToggleButtonOperator _tbSessions;
    private JToggleButtonOperator _tbThreads;
    private JToggleButtonOperator _tbCallStack;
    private JToggleButtonOperator _tbLocalVariables;
    private JToggleButtonOperator _tbAllInOne;
    private JToggleButtonOperator _tbWatches;
    private JToggleButtonOperator _tbClasses;
    private JToggleButtonOperator _tbBreakpoints;
    private JToggleButtonOperator _tbProperties;
    private JToggleButtonOperator _tbPublic;
    private JToggleButtonOperator _tbProtected;
    private JToggleButtonOperator _tbPrivate;
    private JToggleButtonOperator _tbPackagePrivate;
    private JToggleButtonOperator _tbStatic;
    private JToggleButtonOperator _tbInherited;
    private JTableOperator _tabTreeTable;
    private String[] views = new String[]{"Sessions", "Threads", "CallStack", "LocalVariables", "AllInOne", "Watches", "Classes", "Breakpoints", "Properties"};

    public DebuggerWindowOperator(ContainerOperator containerOperator) {
        super(containerOperator, new DebuggerWindowChooser("Debugger"));
    }

    public DebuggerWindowOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public DebuggerWindowOperator show() {
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(false, true));
        Util.getMainTab().setSelectedIndex(Util.getMainTab().findPage("Debugger"));
        return new DebuggerWindowOperator((ContainerOperator)Util.getMainWindow());
    }

    public JToggleButtonOperator tbSessions() {
        this._tbSessions = new JToggleButtonOperator((ContainerOperator)this, "", 0);
        return this._tbSessions;
    }

    public JToggleButtonOperator tbThreads() {
        this._tbThreads = new JToggleButtonOperator((ContainerOperator)this, "", 1);
        return this._tbThreads;
    }

    public JToggleButtonOperator tbCallStack() {
        this._tbCallStack = new JToggleButtonOperator((ContainerOperator)this, "", 2);
        return this._tbCallStack;
    }

    public JToggleButtonOperator tbLocalVariables() {
        this._tbLocalVariables = new JToggleButtonOperator((ContainerOperator)this, "", 3);
        return this._tbLocalVariables;
    }

    public JToggleButtonOperator tbAllInOne() {
        this._tbAllInOne = new JToggleButtonOperator((ContainerOperator)this, "", 4);
        return this._tbAllInOne;
    }

    public JToggleButtonOperator tbWatches() {
        this._tbWatches = new JToggleButtonOperator((ContainerOperator)this, "", 5);
        return this._tbWatches;
    }

    public JToggleButtonOperator tbClasses() {
        this._tbClasses = new JToggleButtonOperator((ContainerOperator)this, "", 6);
        return this._tbClasses;
    }

    public JToggleButtonOperator tbBreakpoints() {
        this._tbBreakpoints = new JToggleButtonOperator((ContainerOperator)this, "", 7);
        return this._tbBreakpoints;
    }

    public JToggleButtonOperator tbProperties() {
        this._tbProperties = new JToggleButtonOperator((ContainerOperator)this, "", 8);
        return this._tbProperties;
    }

    public JToggleButtonOperator tbPublic() {
        this._tbPublic = new JToggleButtonOperator((ContainerOperator)this, "", 9);
        return this._tbPublic;
    }

    public JToggleButtonOperator tbProtected() {
        this._tbProtected = new JToggleButtonOperator((ContainerOperator)this, "", 10);
        return this._tbProtected;
    }

    public JToggleButtonOperator tbPrivate() {
        this._tbPrivate = new JToggleButtonOperator((ContainerOperator)this, "", 11);
        return this._tbPrivate;
    }

    public JToggleButtonOperator tbPackagePrivate() {
        this._tbPackagePrivate = new JToggleButtonOperator((ContainerOperator)this, "", 12);
        return this._tbPackagePrivate;
    }

    public JToggleButtonOperator tbStatic() {
        this._tbStatic = new JToggleButtonOperator((ContainerOperator)this, "", 13);
        return this._tbStatic;
    }

    public JToggleButtonOperator tbInherited() {
        this._tbInherited = new JToggleButtonOperator((ContainerOperator)this, "", 14);
        return this._tbInherited;
    }

    public void checkBreakpoints(boolean bl) {
        if (this.tbBreakpoints().isSelected() != bl) {
            this.tbBreakpoints().push();
        }
    }

    public boolean getBreakpointsState() {
        return this.tbBreakpoints().isSelected();
    }

    public void checkSessions(boolean bl) {
        if (this.tbSessions().isSelected() != bl) {
            this.tbSessions().push();
        }
    }

    public boolean getSessionsState() {
        return this.tbSessions().isSelected();
    }

    public void checkThreads(boolean bl) {
        if (this.tbThreads().isSelected() != bl) {
            this.tbThreads().push();
        }
    }

    public boolean getThreadsState() {
        return this.tbThreads().isSelected();
    }

    public void checkCallStack(boolean bl) {
        if (this.tbCallStack().isSelected() != bl) {
            this.tbCallStack().push();
        }
    }

    public boolean getCallStackState() {
        return this.tbCallStack().isSelected();
    }

    public void checkLocalVariables(boolean bl) {
        if (this.tbLocalVariables().isSelected() != bl) {
            this.tbLocalVariables().push();
        }
    }

    public boolean getLocalVariablesState() {
        return this.tbLocalVariables().isSelected();
    }

    public void checkAllInOne(boolean bl) {
        if (this.tbAllInOne().isSelected() != bl) {
            this.tbAllInOne().push();
        }
    }

    public boolean getAllInOneState() {
        return this.tbAllInOne().isSelected();
    }

    public void checkWatches(boolean bl) {
        if (this.tbWatches().isSelected() != bl) {
            this.tbWatches().push();
        }
    }

    public boolean getWatchesState() {
        return this.tbWatches().isSelected();
    }

    public void checkClasses(boolean bl) {
        if (this.tbClasses().isSelected() != bl) {
            this.tbClasses().push();
        }
    }

    public boolean getClassesState() {
        return this.tbClasses().isSelected();
    }

    public void checkProperties(boolean bl) {
        if (this.tbProperties().isSelected() != bl) {
            this.tbProperties().push();
        }
    }

    public boolean getPropertiesState() {
        return this.tbProperties().isSelected();
    }

    public JTableOperator getJTableOperator(String string) {
        int n = -1;
        int n2 = -1;
        do {
            switch (++n) {
                case 0: {
                    if (this.views[n].equals(string)) {
                        this.checkSessions(true);
                        ++n2;
                        break;
                    }
                    if (!this.getSessionsState()) break;
                    ++n2;
                    break;
                }
                case 1: {
                    if (this.views[n].equals(string)) {
                        this.checkThreads(true);
                        ++n2;
                        break;
                    }
                    if (!this.getThreadsState()) break;
                    ++n2;
                    break;
                }
                case 2: {
                    if (this.views[n].equals(string)) {
                        this.checkCallStack(true);
                        ++n2;
                        break;
                    }
                    if (!this.getCallStackState()) break;
                    ++n2;
                    break;
                }
                case 3: {
                    if (this.views[n].equals(string)) {
                        this.checkLocalVariables(true);
                        ++n2;
                        break;
                    }
                    if (!this.getLocalVariablesState()) break;
                    ++n2;
                    break;
                }
                case 4: {
                    if (this.views[n].equals(string)) {
                        this.checkAllInOne(true);
                        ++n2;
                        break;
                    }
                    if (!this.getAllInOneState()) break;
                    ++n2;
                    break;
                }
                case 5: {
                    if (this.views[n].equals(string)) {
                        this.checkWatches(true);
                        ++n2;
                        break;
                    }
                    if (!this.getWatchesState()) break;
                    ++n2;
                    break;
                }
                case 6: {
                    if (this.views[n].equals(string)) {
                        this.checkClasses(true);
                        ++n2;
                        break;
                    }
                    if (!this.getClassesState()) break;
                    ++n2;
                    break;
                }
                case 7: {
                    if (this.views[n].equals(string)) {
                        this.checkBreakpoints(true);
                        ++n2;
                        break;
                    }
                    if (!this.getBreakpointsState()) break;
                    ++n2;
                    break;
                }
                case 8: {
                    if (this.views[n].equals(string)) {
                        this.checkProperties(true);
                        ++n2;
                        break;
                    }
                    if (!this.getPropertiesState()) break;
                    ++n2;
                }
            }
        } while (!this.views[n].equals(string));
        this._tabTreeTable = new JTableOperator((ContainerOperator)this, n2);
        return this._tabTreeTable;
    }

    public static class DebuggerWindowChooser
    implements ComponentChooser {
        String ID;
        private Operator.StringComparator comparator;

        public DebuggerWindowChooser(String string) {
            this(string, (Operator.StringComparator)new Operator.DefaultStringComparator(false, false));
        }

        public DebuggerWindowChooser(String string, Operator.StringComparator stringComparator) {
            this.ID = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            if (component != null && component.getName() != null) {
                return component instanceof Component && component.getName().equals(this.ID);
            }
            return false;
        }

        public String getDescription() {
            return "A Component with \"" + this.ID + "\" ID";
        }
    }
}

