/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.util;

import com.sun.rave.web.ui.util.TypeConversion;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class TypeConverter {
    private static final Map typeConversions = new HashMap();
    public static final String TYPE_UNKNOWN = "null";
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_CHARACTER = "character";
    public static final String TYPE_BIG_DECIMAL = "bigdecimal";
    public static final String TYPE_SQL_DATE = "sqldate";
    public static final String TYPE_SQL_TIME = "sqltime";
    public static final String TYPE_SQL_TIMESTAMP = "sqltimestamp";
    public static final TypeConversion UNKNOWN_TYPE_CONVERSION = new UnknownTypeConversion();
    public static final TypeConversion OBJECT_TYPE_CONVERSION = new ObjectTypeConversion();
    public static final TypeConversion STRING_TYPE_CONVERSION = new StringTypeConversion();
    public static final TypeConversion INTEGER_TYPE_CONVERSION = new IntegerTypeConversion();
    public static final TypeConversion DOUBLE_TYPE_CONVERSION = new DoubleTypeConversion();
    public static final TypeConversion BOOLEAN_TYPE_CONVERSION = new BooleanTypeConversion();
    public static final TypeConversion LONG_TYPE_CONVERSION = new LongTypeConversion();
    public static final TypeConversion FLOAT_TYPE_CONVERSION = new FloatTypeConversion();
    public static final TypeConversion SHORT_TYPE_CONVERSION = new ShortTypeConversion();
    public static final TypeConversion BIG_DECIMAL_TYPE_CONVERSION = new BigDecimalTypeConversion();
    public static final TypeConversion BYTE_TYPE_CONVERSION = new ByteTypeConversion();
    public static final TypeConversion CHARACTER_TYPE_CONVERSION = new CharacterTypeConversion();
    public static final TypeConversion SQL_DATE_TYPE_CONVERSION = new SqlDateTypeConversion();
    public static final TypeConversion SQL_TIME_TYPE_CONVERSION = new SqlTimeTypeConversion();
    public static final TypeConversion SQL_TIMESTAMP_TYPE_CONVERSION = new SqlTimestampTypeConversion();

    private TypeConverter() {
    }

    public static Map getTypeConversions() {
        return typeConversions;
    }

    public static void registerTypeConversion(Object key, TypeConversion conversion) {
        typeConversions.put(key, conversion);
    }

    public static Object asType(Object typeKey, Object value) {
        if (value == null) {
            return null;
        }
        if (typeKey == null) {
            return value;
        }
        if (typeKey instanceof Class && (Class)typeKey != Object.class && ((Class)typeKey).isInstance(value)) {
            return value;
        }
        TypeConversion conversion = (TypeConversion)typeConversions.get(typeKey);
        if (conversion != null) {
            return conversion.convertValue(value);
        }
        throw new IllegalArgumentException("Could not find type conversion for type \"" + typeKey + "\" (value = \"" + value + "\"");
    }

    public static byte asByte(Object value) {
        return TypeConverter.asByte(value, (byte)0);
    }

    public static byte asByte(Object value, byte defaultValue) {
        value = TypeConverter.asType(Byte.class, value);
        if (value != null) {
            return (Byte)value;
        }
        return defaultValue;
    }

    public static short asShort(Object value) {
        return TypeConverter.asShort(value, (short)0);
    }

    public static short asShort(Object value, short defaultValue) {
        value = TypeConverter.asType(Short.class, value);
        if (value != null) {
            return (Short)value;
        }
        return defaultValue;
    }

    public static int asInt(Object value) {
        return TypeConverter.asInt(value, 0);
    }

    public static int asInt(Object value, int defaultValue) {
        value = TypeConverter.asType(Integer.class, value);
        if (value != null) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public static long asLong(Object value) {
        return TypeConverter.asLong(value, 0L);
    }

    public static long asLong(Object value, long defaultValue) {
        value = TypeConverter.asType(Long.class, value);
        if (value != null) {
            return (Long)value;
        }
        return defaultValue;
    }

    public static float asFloat(Object value) {
        return TypeConverter.asFloat(value, 0.0f);
    }

    public static float asFloat(Object value, float defaultValue) {
        value = TypeConverter.asType(Float.class, value);
        if (value != null) {
            return ((Float)value).floatValue();
        }
        return defaultValue;
    }

    public static double asDouble(Object value) {
        return TypeConverter.asDouble(value, 0.0);
    }

    public static double asDouble(Object value, double defaultValue) {
        value = TypeConverter.asType(Double.class, value);
        if (value != null) {
            return (Double)value;
        }
        return defaultValue;
    }

    public static char asChar(Object value) {
        return TypeConverter.asChar(value, '\u0000');
    }

    public static char asChar(Object value, char defaultValue) {
        value = TypeConverter.asType(Character.class, value);
        if (value != null) {
            return ((Character)value).charValue();
        }
        return defaultValue;
    }

    public static boolean asBoolean(Object value) {
        return TypeConverter.asBoolean(value, false);
    }

    public static boolean asBoolean(Object value, boolean defaultValue) {
        value = TypeConverter.asType(Boolean.class, value);
        if (value != null) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static String asString(Object value) {
        return (String)TypeConverter.asType(String.class, value);
    }

    public static String asString(Object value, String defaultValue) {
        value = TypeConverter.asType(String.class, value);
        if (value != null) {
            return (String)value;
        }
        return defaultValue;
    }

    static {
        TypeConverter.registerTypeConversion(Object.class, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(String.class, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.class, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.TYPE, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.class, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.TYPE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.class, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.TYPE, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.class, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.TYPE, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.class, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.TYPE, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.class, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.TYPE, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(BigDecimal.class, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.class, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.TYPE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.class, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.TYPE, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Date.class, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Time.class, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Timestamp.class, SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Object.class.getName(), OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(String.class.getName(), STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.class.getName(), INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.class.getName(), DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.class.getName(), BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.class.getName(), LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.class.getName(), FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.class.getName(), SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(BigDecimal.class.getName(), BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.class.getName(), BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.class.getName(), CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Date.class.getName(), SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Time.class.getName(), SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Timestamp.class.getName(), SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_UNKNOWN, UNKNOWN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_OBJECT, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_STRING, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INT, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INTEGER, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_DOUBLE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BOOLEAN, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_LONG, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_FLOAT, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SHORT, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BIG_DECIMAL, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BYTE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHAR, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHARACTER, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_DATE, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIME, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIMESTAMP, SQL_TIMESTAMP_TYPE_CONVERSION);
    }

    private static class Test
    extends TestSuperclass {
        private Test() {
        }

        public static void main(String[] args) {
            if (!(TypeConverter.asString(new Integer(12)) instanceof String)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer, "12") instanceof Integer)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverter.class$("java.lang.Long")) : class$java$lang$Long, "12") instanceof Long)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverter.class$("java.lang.Float")) : class$java$lang$Float, "12.0") instanceof Float)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverter.class$("java.lang.Double")) : class$java$lang$Double, "12.0") instanceof Double)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverter.class$("java.lang.Short")) : class$java$lang$Short, "12") instanceof Short)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, "12") instanceof BigDecimal)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, "true") instanceof Boolean)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte, "12") instanceof Byte)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverter.class$("java.lang.Character")) : class$java$lang$Character, "1") instanceof Character)) {
                throw new Error();
            }
            System.out.println("Test passed.");
        }
    }

    private static class TestSuperclass {
        private TestSuperclass() {
        }
    }

    public static class ObjectTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            return value;
        }
    }

    public static class SqlTimestampTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Timestamp)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Timestamp.valueOf(v);
            }
            return value;
        }
    }

    public static class SqlTimeTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Time)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Time.valueOf(v);
            }
            return value;
        }
    }

    public static class SqlDateTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Date)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Date.valueOf(v);
            }
            return value;
        }
    }

    public static class CharacterTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Character)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Character(v.charAt(0));
            }
            return value;
        }
    }

    public static class ByteTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Byte)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Byte(v);
            }
            return value;
        }
    }

    public static class BigDecimalTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof BigDecimal)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new BigDecimal(v);
            }
            return value;
        }
    }

    public static class ShortTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Short)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Short(v);
            }
            return value;
        }
    }

    public static class FloatTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Float)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Float(v);
            }
            return value;
        }
    }

    public static class LongTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Long)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Long(v);
            }
            return value;
        }
    }

    public static class BooleanTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Boolean)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Boolean.valueOf(v);
            }
            return value;
        }
    }

    public static class DoubleTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Double)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Double(v);
            }
            return value;
        }
    }

    public static class IntegerTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Integer)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Integer(v);
            }
            return value;
        }
    }

    public static class StringTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    value = new String((byte[])value);
                } else if (value.getClass().getComponentType() == Character.TYPE) {
                    value = new String((char[])value);
                }
            } else if (!(value instanceof String)) {
                value = value.toString();
            }
            return value;
        }
    }

    public static class UnknownTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            return value;
        }
    }
}

