/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Head;
import com.sun.rave.web.ui.component.util.Util;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class HeadRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"profile"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("head", component);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Head head = (Head)component;
        if (!RenderingUtilities.isPortlet(context)) {
            HeadRenderer.addStringAttributes(context, component, writer, stringAttributes);
            writer.write("\n");
            this.renderMetaTag("no-cache", "Pragma", writer, head);
            this.renderMetaTag("no-cache", "Cache-Control", writer, head);
            this.renderMetaTag("no-store", "Cache-Control", writer, head);
            this.renderMetaTag("max-age=0", "Cache-Control", writer, head);
            this.renderMetaTag("1", "Expires", writer, head);
            String title = head.getTitle();
            if (title == null) {
                title = "";
            }
            writer.startElement("title", (UIComponent)head);
            writer.write(title);
            writer.endElement("title");
            writer.write("\n");
            if (head.isDefaultBase()) {
                writer.startElement("base", (UIComponent)head);
                writer.writeURIAttribute("href", (Object)Util.getBase(context), null);
                writer.endElement("base");
                writer.write("\n");
            }
            Theme theme = ThemeUtilities.getTheme(context);
            RenderingUtilities.renderJavaScript((UIComponent)head, theme, context, writer);
            RenderingUtilities.renderStyleSheetLink((UIComponent)head, theme, context, writer);
            writer.write(this.getCookieScript(context));
        }
    }

    private String getCookieScript(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
        StringBuffer jsBuffer = new StringBuffer(256);
        jsBuffer.append("\n<script type=\"text/javascript\">\nvar ");
        jsBuffer.append("sjwuic_ScrollCookie");
        jsBuffer.append(" = new sjwuic_ScrollCookie('");
        jsBuffer.append(viewId);
        jsBuffer.append("', '");
        jsBuffer.append(urlString);
        jsBuffer.append("'); \n</script>\n");
        return jsBuffer.toString();
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("head");
            writer.write("\n");
        }
    }

    private void renderMetaTag(String content, String httpEquivalent, ResponseWriter writer, Head head) throws IOException {
        writer.startElement("meta", (UIComponent)head);
        writer.writeAttribute("content", (Object)content, null);
        writer.writeAttribute("http-equiv", (Object)httpEquivalent, null);
        writer.endElement("meta");
        writer.writeText((Object)"\n", null);
    }
}

