/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.CalendarMonth;
import com.sun.rave.web.ui.component.DateManager;
import com.sun.rave.web.ui.component.DropDown;
import com.sun.rave.web.ui.component.Icon;
import com.sun.rave.web.ui.component.IconHyperlink;
import com.sun.rave.web.ui.model.Option;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class CalendarMonthRenderer
extends AbstractRenderer {
    private static final boolean DEBUG = false;
    private static final String SKIP_SECTION = "skipSection";
    private static final String CURR_YEAR_ATTR = "currYear";
    private static final String CURR_MONTH_ATTR = "currMonth";

    private void renderDayHeaderRow(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)calendarMonth);
        writer.write("\n");
        int firstDay = calendarMonth.getCalendar().getFirstDayOfWeek();
        String[] daysOfWeek = new String[8];
        daysOfWeek[2] = styles[10];
        daysOfWeek[3] = styles[11];
        daysOfWeek[4] = styles[12];
        daysOfWeek[5] = styles[13];
        daysOfWeek[6] = styles[14];
        daysOfWeek[7] = styles[15];
        daysOfWeek[1] = styles[16];
        String styleClass = styles[17];
        for (int i = 0; i < 7; ++i) {
            this.renderCalendarHeader(calendarMonth, writer, styleClass, daysOfWeek[firstDay]);
            writer.write("\n");
            if (++firstDay != 8) continue;
            firstDay = 1;
        }
        writer.endElement("tr");
        writer.write("\n");
    }

    private void renderCalendarHeader(CalendarMonth calendarMonth, ResponseWriter writer, String styleClass, String header) throws IOException {
        writer.startElement("th", (UIComponent)calendarMonth);
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeAttribute("scope", (Object)"col", null);
        writer.write("\n");
        writer.startElement("span", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write("\n");
        writer.writeText((Object)header, null);
        writer.write("\n");
        writer.endElement("span");
        writer.write("\n");
        writer.endElement("th");
    }

    private void renderDays(CalendarMonth calendarMonth, String id, String[] styles, ResponseWriter writer) throws IOException {
        int i;
        String rowId;
        Calendar monthToShow = calendarMonth.getCalendar();
        monthToShow.set(1, calendarMonth.getCurrentYear());
        monthToShow.set(2, calendarMonth.getCurrentMonth() - 1);
        monthToShow.set(5, 1);
        int weekStartDay = monthToShow.getFirstDayOfWeek();
        Calendar startDate = (Calendar)monthToShow.clone();
        while (startDate.get(7) != weekStartDay) {
            startDate.add(5, -1);
            startDate.getTime();
        }
        Calendar endDate = (Calendar)monthToShow.clone();
        endDate.add(2, 1);
        endDate.getTime();
        if (endDate.get(7) == weekStartDay) {
            endDate.add(5, -1);
            endDate.getTime();
        } else {
            while (endDate.get(7) != weekStartDay) {
                endDate.add(5, 1);
                endDate.getTime();
            }
            endDate.add(5, -1);
            endDate.getTime();
        }
        DateFormat format = calendarMonth.getDateFormat();
        String rowIdPrefix = id.concat(":row");
        String dateLinkPrefix = id.concat(":dateLink");
        int displayedMonth = monthToShow.get(2);
        Calendar todaysDate = calendarMonth.getCalendar();
        int dateLinkId = 0;
        int rowNum = 0;
        while (startDate.before(endDate)) {
            writer.startElement("tr", (UIComponent)calendarMonth);
            rowId = rowIdPrefix + rowNum++;
            writer.writeAttribute("id", (Object)rowId, null);
            writer.write("\n");
            for (i = 0; i < 7; ++i) {
                boolean selected = calendarMonth.isDateSelected(startDate, endDate);
                boolean dayInMonth = startDate.get(2) == displayedMonth;
                String style = styles[19];
                if (selected) {
                    style = dayInMonth ? styles[20] : styles[21];
                } else if (dayInMonth) {
                    style = calendarMonth.compareDate(startDate, todaysDate) ? styles[22] : styles[18];
                }
                this.renderDateLink(startDate, style, dateLinkPrefix.concat(String.valueOf(dateLinkId)), calendarMonth, writer);
                ++dateLinkId;
                startDate.add(6, 1);
                startDate.getTime();
            }
            writer.endElement("tr");
            writer.write("\n");
        }
        if (rowNum < 6) {
            writer.startElement("tr", (UIComponent)calendarMonth);
            rowId = rowIdPrefix + rowNum++;
            writer.writeAttribute("id", (Object)rowId, null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            writer.write("\n");
            for (i = 0; i < 7; ++i) {
                this.renderDateLink(startDate, styles[19], dateLinkPrefix.concat(String.valueOf(dateLinkId)), calendarMonth, writer);
                ++dateLinkId;
                startDate.add(6, 1);
                startDate.getTime();
            }
            writer.endElement("tr");
            writer.write("\n");
        }
    }

    private void renderDateLink(Calendar startDate, String style, String id, CalendarMonth calendarMonth, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeText((Object)"\n", null);
        int day = startDate.get(5);
        writer.startElement("a", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeAttribute("id", (Object)id, null);
        String dateString = calendarMonth.getDateFormat().format(startDate.getTime());
        writer.writeAttribute("title", (Object)dateString, null);
        StringBuffer buffer = new StringBuffer(128);
        if (calendarMonth.isPopup()) {
            buffer.append(calendarMonth.getJavaScriptObjectName());
            buffer.append(".dayClicked(this); return false;");
        } else {
            buffer.append(calendarMonth.getJavaScriptObjectName());
            buffer.append(".setDateValue('");
            buffer.append(dateString);
            buffer.append("', this); return false;");
        }
        writer.writeAttribute("onclick", (Object)buffer.toString(), null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.write(String.valueOf(day));
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
    }

    private void renderCalendarControls(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[3], null);
        writer.writeText((Object)"\n", null);
        this.renderLayoutTable(writer, calendarMonth);
        writer.writeText((Object)"\n", null);
        String pattern = calendarMonth.getDateFormatPattern();
        if (pattern.indexOf("yyyy") < pattern.indexOf("MM")) {
            this.renderYearControl(calendarMonth, styles, context, writer);
            writer.startElement("td", (UIComponent)calendarMonth);
            writer.writeAttribute("width", (Object)"8", null);
            writer.write("&nbsp;");
            writer.endElement("td");
            writer.write("\n");
            this.renderMonthControl(calendarMonth, styles, context, writer);
        } else {
            this.renderMonthControl(calendarMonth, styles, context, writer);
            writer.startElement("td", (UIComponent)calendarMonth);
            writer.writeAttribute("width", (Object)"8", null);
            writer.write("&nbsp;");
            writer.endElement("td");
            writer.write("\n");
            this.renderYearControl(calendarMonth, styles, context, writer);
        }
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private void renderYearControl(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.write("\n");
        DropDown yearDropDown = calendarMonth.getYearMenu();
        yearDropDown.setToolTip(styles[8]);
        RenderingUtilities.renderComponent((UIComponent)yearDropDown, context);
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
    }

    private void renderMonthControl(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("align", (Object)"left", null);
        writer.write("\n");
        IconHyperlink decreaseLink = calendarMonth.getPreviousMonthLink();
        decreaseLink.setAlt(styles[6]);
        RenderingUtilities.renderComponent((UIComponent)decreaseLink, context);
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("align", (Object)"left", null);
        writer.write("\n");
        DropDown monthDropDown = calendarMonth.getMonthMenu();
        monthDropDown.setToolTip(styles[9]);
        RenderingUtilities.renderComponent((UIComponent)monthDropDown, context);
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("align", (Object)"left", null);
        writer.write("\n");
        IconHyperlink increaseLink = calendarMonth.getNextMonthLink();
        increaseLink.setAlt(styles[7]);
        RenderingUtilities.renderComponent((UIComponent)increaseLink, context);
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
    }

    protected void renderLayoutTable(ResponseWriter writer, CalendarMonth calendarMonth) throws IOException {
        writer.startElement("table", (UIComponent)calendarMonth);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.write("\n");
        writer.startElement("tr", (UIComponent)calendarMonth);
    }

    private void renderCalendarFooter(CalendarMonth calendarMonth, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)calendarMonth);
        writer.write("\n");
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[23], null);
        writer.writeAttribute("colspan", (Object)"7", null);
        writer.write("\n");
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[24], null);
        writer.write("\n");
        writer.startElement("span", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[25], null);
        writer.write("\n");
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(2, context.getViewRoot().getLocale());
        dateFormat.setTimeZone(calendarMonth.getTimeZone());
        Date today = calendarMonth.getCalendar().getTime();
        writer.writeText((Object)dateFormat.format(today), null);
        writer.write("\n");
        writer.endElement("span");
        writer.write("\n");
        RenderingUtilities.renderAnchor(SKIP_SECTION, (UIComponent)calendarMonth, context);
        StringBuffer strBuffer = new StringBuffer(128);
        strBuffer.append(calendarMonth.getJavaScriptObjectName());
        strBuffer.append(".toggle(); return false;");
        writer.startElement("a", (UIComponent)calendarMonth);
        writer.writeAttribute("onclick", (Object)strBuffer.toString(), null);
        writer.writeAttribute("class", (Object)styles[27], null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.write(styles[28]);
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
    }

    protected void renderSpacerImage(FacesContext context, CalendarMonth calendarMonth, Theme theme, int height, int width) throws IOException {
        Icon dot = theme.getIcon("DOT");
        dot.setWidth(width);
        dot.setHeight(height);
        dot.setId("icon");
        dot.setAlt("");
        RenderingUtilities.renderComponent((UIComponent)dot, context);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof CalendarMonth)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), CalendarMonth.class.getName()};
            String message = MessageUtil.getMessage("com.sun.rave.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        CalendarMonth calendarMonth = (CalendarMonth)component;
        this.initializeChildren(calendarMonth, context);
        ResponseWriter writer = context.getResponseWriter();
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = this.getStyles(calendarMonth, context, theme);
        String id = calendarMonth.getClientId(context);
        if (calendarMonth.isPopup()) {
            this.renderPopupStart(calendarMonth, id, styles, context, writer);
        } else {
            writer.startElement("div", (UIComponent)calendarMonth);
            writer.writeAttribute("id", (Object)id, null);
            writer.writeText((Object)"\n", null);
        }
        this.renderCalendarControls(calendarMonth, styles, context, writer);
        this.renderDateTable(calendarMonth, styles, id, context, writer);
        if (calendarMonth.isPopup()) {
            this.renderPopupEnd(writer);
        } else {
            writer.endElement("div");
        }
    }

    private void renderPopupStart(CalendarMonth calendarMonth, String id, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)styles[0], null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[1], null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[2], null);
        writer.writeText((Object)"\n", null);
        this.renderLayoutTable(writer, calendarMonth);
        writer.startElement("td", (UIComponent)calendarMonth);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
    }

    private void renderPopupEnd(ResponseWriter writer) throws IOException {
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
        writer.endElement("table");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private void renderDateTable(CalendarMonth calendarMonth, String[] styles, String id, FacesContext context, ResponseWriter writer) throws IOException {
        RenderingUtilities.renderSkipLink(SKIP_SECTION, styles[26], null, null, null, (UIComponent)calendarMonth, context);
        writer.startElement("div", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[4], null);
        writer.write("\n");
        writer.startElement("table", (UIComponent)calendarMonth);
        writer.writeAttribute("class", (Object)styles[5], null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("cellspacing", (Object)"1", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.write("\n");
        this.renderDayHeaderRow(calendarMonth, styles, context, writer);
        this.renderDays(calendarMonth, id, styles, writer);
        if (calendarMonth.isPopup()) {
            this.renderCalendarFooter(calendarMonth, styles, context, writer);
            writer.write("\n");
        }
        writer.endElement("table");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        if (!calendarMonth.isPopup()) {
            RenderingUtilities.renderAnchor(SKIP_SECTION, (UIComponent)calendarMonth, context);
        }
    }

    private void initializeChildren(CalendarMonth cm, FacesContext context) {
        boolean updateCalendarControls = false;
        Calendar calendar = cm.getCalendar();
        Date displayDate = calendar.getTime();
        Integer year = cm.getCurrentYear();
        Integer month = cm.getCurrentMonth();
        if (year != null && month != null) {
            calendar.set(1, year);
            calendar.set(2, month - 1);
        } else {
            updateCalendarControls = true;
        }
        Date minDate = null;
        Date maxDate = null;
        UIComponent parent = cm.getParent();
        if (parent instanceof DateManager) {
            minDate = ((DateManager)parent).getFirstAvailableDate();
            maxDate = ((DateManager)parent).getLastAvailableDate();
        }
        if (displayDate.before(minDate)) {
            displayDate = minDate;
            updateCalendarControls = true;
        }
        if (maxDate.before(displayDate)) {
            displayDate = maxDate;
            updateCalendarControls = true;
        }
        DropDown yearMenu = cm.getYearMenu();
        DropDown monthMenu = cm.getMonthMenu();
        if (updateCalendarControls) {
            calendar.setTime(displayDate);
            String yearValue = String.valueOf(calendar.get(1));
            yearMenu.setSubmittedValue(new String[]{yearValue});
            String monthValue = String.valueOf(calendar.get(2) + 1);
            monthMenu.setSubmittedValue(new String[]{monthValue});
        }
        calendar.setTime(minDate);
        int firstYear = calendar.get(1);
        calendar.setTime(maxDate);
        int lastYear = calendar.get(1);
        int numYears = lastYear - firstYear + 1;
        Integer yearInteger = null;
        Option[] yearOptions = new Option[numYears];
        for (int i = 0; i < numYears; ++i) {
            yearInteger = new Integer(firstYear + i);
            yearOptions[i] = new Option(yearInteger, yearInteger.toString());
        }
        yearMenu.setItems(yearOptions);
        SimpleDateFormat formatter = (SimpleDateFormat)cm.getDateFormat();
        String[] monthNames = formatter.getDateFormatSymbols().getMonths();
        Option[] months = new Option[12];
        calendar.set(2, 0);
        for (int i = 0; i < 12; ++i) {
            int monthInt = calendar.get(2);
            months[i] = new Option(new Integer(monthInt + 1), monthNames[i]);
            calendar.add(2, 1);
        }
        monthMenu.setItems(months);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String[] getStyles(CalendarMonth calendarMonth, FacesContext context, Theme theme) {
        String[] styles = new String[]{theme.getStyleClass("CalPopShdDiv"), theme.getStyleClass("CalPopShd2Div"), theme.getStyleClass("CalPopDiv"), theme.getStyleClass("DatSelDiv"), theme.getStyleClass("DatCalDiv"), theme.getStyleClass("DatCalTbl"), theme.getMessage("CalendarMonth.goBack"), theme.getMessage("CalendarMonth.goForward"), theme.getMessage("CalendarMonth.selectYear"), theme.getMessage("CalendarMonth.selectMonth"), theme.getMessage("CalendarMonth.weekdayMon"), theme.getMessage("CalendarMonth.weekdayTue"), theme.getMessage("CalendarMonth.weekdayWed"), theme.getMessage("CalendarMonth.weekdayThu"), theme.getMessage("CalendarMonth.weekdayFri"), theme.getMessage("CalendarMonth.weekdaySat"), theme.getMessage("CalendarMonth.weekdaySun"), theme.getStyleClass("DatDayHdrTxt"), theme.getStyleClass("DatLnk"), theme.getStyleClass("DatOthLnk"), theme.getStyleClass("DatBldLnk"), theme.getStyleClass("DatOthBldLnk"), theme.getStyleClass("DatCurLnk"), theme.getStyleClass("CalPopFtr"), theme.getStyleClass("CalPopFtrDiv"), theme.getStyleClass("CurDayTxt"), theme.getStyleClass("SkpMedGry1"), theme.getStyleClass("CalPopClsLnk"), theme.getMessage("CalendarMonth.close")};
        return styles;
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
    }
}

