/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.api.insync.InSyncService;
import org.netbeans.modules.visualweb.api.insync.JsfJspDataObjectMarker;
import org.netbeans.modules.visualweb.project.jsf.api.JsfDataObjectException;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsfloader.CompoundSaveCookie;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataLoader;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataNode;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspEditorSupport;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspTemplateEncodingQueryImplementation;
import org.netbeans.modules.visualweb.project.jsfloader.Utils;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseCookie;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseFactory;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfJspDataObject
extends MultiDataObject
implements CookieSet.Factory,
JsfJspDataObjectMarker {
    static final long serialVersionUID = 8354927561693097159L;
    static final String JSF_ATTRIBUTE = "jsfjsp";
    private static final String JSP_ICON_BASE = "org/netbeans/modules/visualweb/project/jsfloader/resources/jsfJspObject.png";
    static final String PROP_ENCODING = "encoding";
    private static final String PROP_CUSTOM_TEMPLATE = "custom-template";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private transient OpenEdit openEdit;
    private transient Lookup currentLookup;
    private transient JsfJspEditorSupport jsfJspEditorSupport;
    private static final Object LOCK_JSF_JSP_EDITOR = new Object();
    private boolean isEncodingRetrieved = false;
    private static final ThreadLocal<Boolean> pureCopy = new ThreadLocal();

    public JsfJspDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(OpenCookie.class, (CookieSet.Factory)this);
        cookieSet.add(EditCookie.class, (CookieSet.Factory)this);
        cookieSet.add(JsfJspEditorSupport.class, (CookieSet.Factory)this);
        cookieSet.add(ViewSupport.class, (CookieSet.Factory)this);
        cookieSet.add(TagLibParseCookie.class, (CookieSet.Factory)this);
        this.createLookup();
    }

    private void createLookup() {
        Lookup lookup = this.getCookieSet().getLookup();
        FileEncodingQueryImplementation fileEncodingQueryImplementation = new FileEncodingQueryImplementation(){

            public Charset getEncoding(FileObject fileObject) {
                assert (fileObject != null);
                assert (fileObject.equals(JsfJspDataObject.this.getPrimaryFile()));
                String string = JsfJspDataObject.this.getFileEncoding();
                try {
                    return Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Boolean bl = (Boolean)fileObject.getAttribute("template");
                    if (bl == null || !bl.booleanValue()) {
                        Logger.getLogger("global").log(Level.INFO, "Detected illegal charset name in file " + fileObject.getNameExt() + " (" + illegalCharsetNameException.getMessage() + ")");
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Logger.getLogger("global").log(Level.INFO, "Detected unsupported charset name in file " + fileObject.getNameExt() + " (" + unsupportedCharsetException.getMessage() + ")");
                }
                return null;
            }
        };
        this.currentLookup = new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)fileEncodingQueryImplementation)});
    }

    protected Node createNodeDelegate() {
        JsfJspDataNode jsfJspDataNode = new JsfJspDataNode((DataObject)this, Children.LEAF);
        jsfJspDataNode.setIconBaseWithExtension(JSP_ICON_BASE);
        return jsfJspDataNode;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataLoader.Obj");
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (OpenCookie.class.equals(clazz) || EditCookie.class.equals(clazz)) {
            if (this.openEdit == null) {
                this.openEdit = new OpenEdit();
            }
            return (T)((Node.Cookie)clazz.cast(this.openEdit));
        }
        if (JsfJspEditorSupport.class.isAssignableFrom(clazz)) {
            return (T)((Node.Cookie)clazz.cast((Object)this.getJsfJspEditorSupport()));
        }
        if (ViewSupport.class.isAssignableFrom(clazz)) {
            return (T)((Node.Cookie)clazz.cast(new ViewSupport(this.getPrimaryEntry())));
        }
        if (TagLibParseCookie.class.isAssignableFrom(clazz)) {
            return (T)((Node.Cookie)clazz.cast(TagLibParseFactory.createTagLibParseCookie((FileObject)this.getPrimaryFile())));
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    public Lookup getLookup() {
        return this.currentLookup;
    }

    <T extends Node.Cookie> T getPureCookie(Class<T> clazz) {
        return (T)super.getCookie(clazz);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz == SaveCookie.class) {
            FileObject fileObject = Utils.findJavaForJsp(this.getPrimaryFile());
            if (fileObject != null && fileObject.isValid()) {
                SaveCookie saveCookie = (SaveCookie)super.getCookie(clazz);
                JsfJavaDataObject jsfJavaDataObject = Utils.findCorrespondingJsfJavaDataObject(this.getPrimaryFile(), false);
                SaveCookie saveCookie2 = jsfJavaDataObject == null ? null : (SaveCookie)jsfJavaDataObject.getPureCookie(clazz);
                if (saveCookie == null && saveCookie2 == null) {
                    return null;
                }
                return (T)((Node.Cookie)clazz.cast(new CompoundSaveCookie(saveCookie, saveCookie2)));
            }
        } else if (TagLibParseCookie.class.isAssignableFrom(clazz)) {
            return (T)((Node.Cookie)clazz.cast(super.getCookie(TagLibParseCookie.class)));
        }
        return (T)super.getCookie(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsfJspEditorSupport getJsfJspEditorSupport() {
        Object object = LOCK_JSF_JSP_EDITOR;
        synchronized (object) {
            if (this.jsfJspEditorSupport == null) {
                this.jsfJspEditorSupport = new JsfJspEditorSupport(this);
            }
            return this.jsfJspEditorSupport;
        }
    }

    public String getFileEncoding() {
        String string;
        if (!this.isEncodingRetrieved) {
            this.updateFileEncoding(false);
            this.isEncodingRetrieved = true;
        }
        string = (string = (String)this.getPrimaryFile().getAttribute(PROP_ENCODING)) != null ? string : DEFAULT_ENCODING;
        return string;
    }

    void updateFileEncoding(boolean bl) {
        if (this.isTemplate()) {
            return;
        }
        TagLibParseCookie tagLibParseCookie = this.getCookie(TagLibParseCookie.class);
        if (tagLibParseCookie != null) {
            String string = tagLibParseCookie.getOpenInfo(true, bl).getEncoding();
            try {
                this.getPrimaryFile().setAttribute(PROP_ENCODING, (Object)string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pureCopy(DataFolder dataFolder) throws IOException {
        try {
            pureCopy.set(Boolean.TRUE);
            this.copy(dataFolder);
        }
        finally {
            pureCopy.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory;
        FileObject fileObject;
        if (pureCopy.get() == Boolean.TRUE) {
            return super.handleCopy(dataFolder);
        }
        FileObject fileObject2 = Utils.findJavaForJsp(this.getPrimaryFile());
        if (fileObject2 == null) {
            throw new JsfDataObjectException("Can't find java file for " + (Object)((Object)this));
        }
        DataObject dataObject = super.handleCopy(dataFolder);
        boolean bl = false;
        if (dataFolder.getPrimaryFile().getFileSystem().isDefault()) {
            fileObject = dataObject.getPrimaryFile();
            try {
                Object object;
                Object object2;
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(fileObject.getInputStream());
                String string = Utils.getBeanNameForJsp(this.getPrimaryFile());
                if (string == null) {
                    throw new JsfDataObjectException("Got null bean name for " + this.getPrimaryFile());
                }
                MarkupVisitor markupVisitor = new MarkupVisitor(string, "${folder}${name}");
                markupVisitor.apply(document);
                FileLock fileLock = fileObject.lock();
                try {
                    object2 = fileObject.getOutputStream(fileLock);
                    object = new PrintStream((OutputStream)object2);
                    ((PrintStream)object).println("<#assign pound = '#'>");
                    XMLUtil.write((Document)document, (OutputStream)object2, (String)this.getFileEncoding());
                }
                finally {
                    fileLock.releaseLock();
                }
                fileObject.setAttribute(PROP_ENCODING, (Object)this.getFileEncoding());
                fileObject.setAttribute("template", (Object)Boolean.TRUE);
                fileObject.setAttribute("javax.script.ScriptEngine", (Object)"freemarker");
                fileObject.setAttribute(PROP_CUSTOM_TEMPLATE, (Object)Boolean.TRUE);
                try {
                    object2 = Thread.currentThread().getContextClassLoader().loadClass("org.netbeans.modules.visualweb.project.jsf.ui.PageIterator");
                    object = ((Class)object2).getMethod("createWebFormIterator", new Class[0]);
                    Object object3 = ((Method)object).invoke(null, new Object[0]);
                    fileObject.setAttribute("templateWizardIterator", object3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JsfDataObjectException("Parser Configuration Exception : " + parserConfigurationException.getMessage() + " while processing " + fileObject);
            }
            catch (SAXException sAXException) {
                throw new JsfDataObjectException("Parsing Exception : " + sAXException.getMessage() + " while processing " + fileObject);
            }
        } else {
            bl = true;
        }
        try {
            fileObject = DataObject.find((FileObject)fileObject2);
            if (fileObject instanceof JsfJavaDataObject) {
                documentBuilderFactory = Utils.findJavaFolderForJsp(dataObject.getPrimaryFile());
                documentBuilder = DataFolder.findFolder((FileObject)documentBuilderFactory);
                ((JsfJavaDataObject)fileObject).pureCopy((DataFolder)documentBuilder);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
        }
        if (bl) {
            try {
                fileObject = dataObject.getPrimaryFile();
                dataObject.setValid(false);
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
                return dataObject;
            }
            InSyncService.getProvider().copied((JsfJspDataObjectMarker)this, (JsfJspDataObjectMarker)dataObject);
        }
        return dataObject;
    }

    protected void handleDelete() throws IOException {
        FileObject fileObject;
        DataObject dataObject;
        boolean bl = this.isTemplate();
        FileObject fileObject2 = this.getPrimaryFile();
        super.handleDelete();
        if (bl && (dataObject = DataObject.find((FileObject)(fileObject = Utils.findJavaForJsp(fileObject2)))) != null) {
            try {
                dataObject.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(65536, "Could not delete java template: " + fileObject.getNameExt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataObject dataObject = null;
        try {
            JsfJspDataLoader.jspTemplateCreation.set(Boolean.TRUE);
            if (Boolean.TRUE.equals(this.getPrimaryFile().getAttribute(PROP_CUSTOM_TEMPLATE))) {
                JsfJspTemplateEncodingQueryImplementation.TEMPLATE_FILEOBJECT.set(this.getPrimaryFile());
            }
            dataObject = super.handleCreateFromTemplate(dataFolder, string);
        }
        finally {
            JsfJspDataLoader.jspTemplateCreation.set(Boolean.FALSE);
            if (Boolean.TRUE.equals(this.getPrimaryFile().getAttribute(PROP_CUSTOM_TEMPLATE))) {
                JsfJspTemplateEncodingQueryImplementation.TEMPLATE_FILEOBJECT.remove();
            }
        }
        dataObject.getPrimaryFile().setAttribute(JSF_ATTRIBUTE, (Object)Boolean.TRUE);
        FileObject fileObject = Utils.findJavaFolderForJsp(dataObject.getPrimaryFile());
        if (fileObject == null) {
            throw new JsfDataObjectException("Can't find corresponding java folder for " + dataObject);
        }
        DataFolder dataFolder2 = (DataFolder)DataObject.find((FileObject)fileObject);
        FileObject fileObject2 = Utils.findJavaForJsp(this.getPrimaryFile());
        if (fileObject2 == null) {
            throw new JsfDataObjectException("Can't find java file template for jsp template " + (Object)((Object)this));
        }
        DataObject dataObject2 = DataObject.find((FileObject)fileObject2);
        if (fileObject.getFileObject(dataObject.getName(), dataObject2.getPrimaryFile().getExt()) != null) {
            ErrorManager.getDefault().log(65536, "\ndesigner:JsfJspDataObject#handleCreateFromTemplate: The java file " + dataObject.getName() + "." + dataObject2.getPrimaryFile().getExt() + " was created by somebody else. It is not necessary now, fix it!");
        } else {
            FileObject fileObject3;
            DataObject dataObject3 = null;
            try {
                fileObject3 = dataObject.getPrimaryFile();
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject3);
                if (project == null) {
                    dataObject3 = dataObject2.createFromTemplate(dataFolder2, dataObject.getName());
                } else {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Object object = project.getProjectDirectory().getAttribute("NewProject");
                    if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                        hashMap.put("creatingProject", "true");
                    }
                    hashMap.put("j2eePlatformVersion", JsfProjectUtils.getJ2eePlatformVersion((Project)project));
                    hashMap.put("sourceLevel", JsfProjectUtils.getSourceLevel((Project)project));
                    dataObject3 = dataObject2.createFromTemplate(dataFolder2, dataObject.getName(), hashMap);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (dataObject3 != null) {
                    dataObject3.getPrimaryFile().setAttribute("NBIssue81746Workaround", (Object)Boolean.TRUE);
                    dataObject3.getPrimaryFile().setAttribute("jsfjava", (Object)Boolean.TRUE);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!(dataObject instanceof JsfJspDataObject)) {
                try {
                    fileObject3 = dataObject.getPrimaryFile();
                    dataObject.setValid(false);
                    dataObject = DataObject.find((FileObject)fileObject3);
                    if (!(dataObject instanceof JsfJspDataObject)) {
                        ErrorManager.getDefault().log(65536, "JsfJspDataObject#handleCreateFromTemplate: DataObject.find() did not return the correct value for " + fileObject3);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    ErrorManager.getDefault().log(65536, "\nJsfJspDataObject#handleCreateFromTemplate: Unable to change to JsfJspDataLoader for FileObject: " + dataObject.getPrimaryFile());
                }
            }
        }
        try {
            dataObject.getPrimaryFile().setAttribute("NBIssue81746Workaround", (Object)Boolean.TRUE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return dataObject;
    }

    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = super.handleRename(string);
        return fileObject;
    }

    private class MarkupVisitor {
        private String oldName;
        private String newName;

        MarkupVisitor(String string, String string2) {
            this.oldName = string;
            this.newName = string2;
        }

        public void apply(org.w3c.dom.Node node) {
            int n;
            this.visit(node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                int n2 = namedNodeMap.getLength();
                for (n = 0; n < n2; ++n) {
                    this.apply(namedNodeMap.item(n));
                }
            }
            NodeList nodeList = node.getChildNodes();
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.apply(nodeList.item(i));
            }
        }

        private void visit(org.w3c.dom.Node node) {
            String string;
            String string2;
            if (node.getNodeType() == 2 && (string2 = this.update(string = node.getNodeValue())) != null) {
                node.setNodeValue(string2);
            }
        }

        private String update(String string) {
            if (string.startsWith("#{") && string.endsWith("}")) {
                return "${pound}" + this.updateName(string.substring(1));
            }
            return null;
        }

        private String updateName(String string) {
            int n;
            if (string.startsWith("{" + this.oldName + ".") && string.endsWith("}") && (n = string.indexOf(".")) != -1) {
                String string2 = string.substring(n, string.length() - 1);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{");
                stringBuffer.append(this.newName);
                stringBuffer.append(string2);
                stringBuffer.append("}");
                return stringBuffer.toString();
            }
            return string;
        }
    }

    private static final class ViewSupport
    implements ViewCookie {
        private MultiDataObject.Entry primary;

        public ViewSupport(MultiDataObject.Entry entry) {
            this.primary = entry;
        }

        public void view() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(this.primary.getFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    private class OpenEdit
    implements OpenCookie,
    EditCookie {
        private OpenEdit() {
        }

        public void open() {
            String string = this.getAttribute();
            if (string != null && string.equals("designer") || string == null) {
                JsfJspDataObject.this.getJsfJspEditorSupport().openDesigner();
            } else {
                JsfJspDataObject.this.getJsfJspEditorSupport().editJsp();
            }
        }

        public void edit() {
            String string = this.getAttribute();
            if (string != null && string.equals("designer")) {
                JsfJspDataObject.this.getJsfJspEditorSupport().openDesigner();
            } else {
                JsfJspDataObject.this.getJsfJspEditorSupport().editJsp();
            }
        }

        private String getAttribute() {
            try {
                String string = (String)JsfJspDataObject.this.getPrimaryFile().getAttribute("selected-multiview");
                JsfJspDataObject.this.getPrimaryFile().setAttribute("selected-multiview", null);
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

