/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.editors.api.nodes;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NodeType {
    UNKNOWN_TYPE,
    PROCESS,
    SCOPE,
    SEQUENCE,
    FLOW,
    IF,
    ELSE_IF,
    ELSE,
    WHILE,
    EMPTY,
    INVOKE,
    RECEIVE,
    REPLY,
    PICK,
    ASSIGN,
    WAIT,
    THROW,
    RETHROW,
    THEN,
    EXIT,
    COMPENSATE,
    COMPENSATE_SCOPE,
    POOL,
    PARTNER_LINK,
    PARTNER_LINK_TYPE,
    DATA_OBJECT,
    ANNOTATION,
    CATCH,
    CATCH_ALL,
    ALARM_HANDLER,
    ALARM_EVENT_HANDLER,
    EVENT_HANDLERS,
    COMPENSATION_HANDLER,
    TERMINATION_HANDLER,
    FAULT_HANDLERS,
    DIAGRAM,
    EXCEPTION_HANDLER,
    DEFAULT_EXCEPTION_HANDLER,
    MESSAGE_HANDLER,
    ON_EVENT,
    SEQUENCE_CONNECTOR,
    FLOW_LINK_CONNECTOR,
    DEFAULT_FLOW_LINK_CONNECTOR,
    FLOW_CONNECTOR_LINK_EVENT,
    FLOW_JOIN_CONDITION_GATEWAY,
    PARTNER_MESSAGE_CONNECTOR,
    ALL_TYPES_CONTAINER,
    MESSAGE_TYPE,
    BPEL_GLOBAL_CATALOG,
    PRIMITIVE_TYPE,
    GLOBAL_SIMPLE_TYPE,
    GLOBAL_COMPLEX_TYPE,
    GLOBAL_ELEMENT,
    WSDL_FILE,
    SCHEMA_FILE,
    VARIABLE_SCOPE,
    VARIABLE_CONTAINER,
    VARIABLE,
    CORRELATION,
    CORRELATION_P,
    CORRELATION_SET_CONTAINER,
    CORRELATION_SET,
    CORRELATION_PROPERTY,
    CORRELATION_PROPERTY_ALIAS,
    MESSAGE_PART,
    COPY,
    SCHEMA_ELEMENT,
    IMPORT,
    IMPORT_WSDL,
    IMPORT_SCHEMA,
    IMPORT_CONTAINER,
    MESSAGE_EXCHANGE,
    MESSAGE_EXCHANGE_CONTAINER,
    REPEAT_UNTIL,
    FOR_EACH,
    FROM_PART,
    TO_PART,
    FROM,
    TO,
    STANDARD_FAULTS_FOLDER,
    WSDL_FILES_FOLDER,
    BPEL_FAULTS_FOLDER,
    FAULT,
    EMBEDDED_SCHEMAS_FOLDER,
    EMBEDDED_SCHEMA,
    PARTNER_ROLE,
    QUERY,
    BOOLEAN_EXPR,
    COMPLETION_CONDITION,
    DEFAULT_BPEL_ENTITY_NODE,
    FOLDER;

    public static final String FOLDER_MODIFICATOR = "FOLDER";
    private static final String BADGE_MODIFICATOR = "BADGE";
    private static final String IMAGE_FOLDER_NAME = "org/netbeans/modules/bpel/editors/api/nodes/images/";
    private static final String HELP_ID_PREFIX = "org.netbeans.modules.bpel.editors.api.nodes.NodeType";
    private AtomicReference<String> myDisplayName = new AtomicReference();
    private AtomicReference<Image> myDefaultImage = new AtomicReference();
    private Map<Object, Image> myImageMap;
    private String myHelpId;
    public static final Image UNKNOWN_IMAGE;

    public String getDisplayName() {
        if (this.myDisplayName.get() == null) {
            try {
                this.myDisplayName.compareAndSet(null, NbBundle.getMessage(NodeType.class, (String)this.toString()));
            }
            catch (Exception exception) {
                this.myDisplayName.compareAndSet(null, this.name());
            }
        }
        return this.myDisplayName.get();
    }

    public String getHelpId() {
        if (this.myHelpId == null) {
            this.myHelpId = "org.netbeans.modules.bpel.editors.api.nodes.NodeType." + this.toString();
        }
        return this.myHelpId;
    }

    public String getDisplayName(Object object) {
        String string = null;
        try {
            String string2 = this.toString() + "_" + object.toString();
            string = NbBundle.getMessage(NodeType.class, (String)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public Icon getIcon() {
        return new ImageIcon(this.getImage());
    }

    public Image getImage() {
        if (this.myDefaultImage.get() == null) {
            Image image = NodeType.getImageImpl((Object)this, null);
            if (image == null) {
                image = UNKNOWN_IMAGE;
            }
            this.myDefaultImage.compareAndSet(null, image);
        }
        return this.myDefaultImage.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Object object) {
        if (object == null) {
            return this.getImage();
        }
        NodeType nodeType = this;
        synchronized (nodeType) {
            Image image = this.getImageMap().get(object);
            if (image == null) {
                image = NodeType.getImageImpl((Object)this, object);
                if (image == null) {
                    image = UNKNOWN_IMAGE;
                }
                this.getImageMap().put(object, image);
            }
            return image;
        }
    }

    public Image getBadgeImage() {
        return this.getImage(BADGE_MODIFICATOR);
    }

    private Map<Object, Image> getImageMap() {
        if (this.myImageMap == null) {
            this.myImageMap = new HashMap<Object, Image>();
        }
        return this.myImageMap;
    }

    private static Image getImageImpl(Object object, Object object2) {
        String string = null;
        string = object2 == null ? IMAGE_FOLDER_NAME + object + ".png" : IMAGE_FOLDER_NAME + object + "_" + object2 + ".png";
        return ImageUtilities.loadImage((String)string);
    }

    public static boolean isValidImage(Image image) {
        return image != null && !UNKNOWN_IMAGE.equals(image);
    }

    static {
        UNKNOWN_IMAGE = NodeType.getImageImpl((Object)UNKNOWN_TYPE, null);
    }
}

