/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportClass
implements ErrorRule<ImportCandidatesHolder> {
    static RequestProcessor WORKER = new RequestProcessor("ImportClassEnabler", 1);
    private boolean cancelled;
    private ComputeImports compImports;

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<ImportCandidatesHolder> data) {
        Object object;
        Object object4;
        this.resume();
        int n2 = n + 1;
        if (n2 == -1) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create errorPosition=-1");
            return Collections.emptyList();
        }
        TreePath treePath2 = compilationInfo.getTreeUtilities().pathFor(n2);
        if (treePath2.getParentPath() != null && treePath2.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && !(object4 = (MethodInvocationTree)treePath2.getParentPath().getLeaf()).getTypeArguments().contains(treePath2.getLeaf())) {
            return Collections.emptyList();
        }
        object4 = null;
        try {
            object4 = ErrorHintsProvider.findUnresolvedElementToken(compilationInfo, n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create ident={0}", object4);
        if (object4 == null) {
            return Collections.emptyList();
        }
        FileObject fileObject = compilationInfo.getFileObject();
        String string2 = ((Object)object4.text()).toString();
        Pair<List<String>, List<String>> pair = this.getCandidateFQNs(compilationInfo, fileObject, string2, data);
        List<? extends ImportTree> list = compilationInfo.getCompilationUnit().getImports();
        for (ImportTree object32 : list) {
            Object object2;
            object = object32.getQualifiedIdentifier().toString();
            if (pair == null || (object2 = pair.getA()) == null || !object2.contains(object)) continue;
            return Collections.emptyList();
        }
        if (this.isCancelled() || pair == null) {
            ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancelled.");
            return CreatorBasedLazyFixList.CANCELLED;
        }
        List<String> list2 = pair.getA();
        List<String> list3 = pair.getB();
        object = new ArrayList();
        if (list3 != null && list2 != null) {
            for (String string3 : list3) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0001#");
                boolean bl = list2.contains(string3);
                if (bl) {
                    stringBuilder.append("A#");
                } else {
                    stringBuilder.append("Z#");
                }
                int n3 = Utilities.getImportanceLevel((String)string3);
                String string4 = Integer.toHexString(n3);
                stringBuilder.append("00000000".substring(0, 8 - string4.length()));
                stringBuilder.append(string4);
                stringBuilder.append('#');
                stringBuilder.append(string3);
                object.add(new FixImport(fileObject, string3, stringBuilder.toString(), bl));
            }
        }
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create finished.");
        return object;
    }

    @Override
    public synchronized void cancel() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancel called.");
        this.cancelled = true;
        if (this.compImports != null) {
            this.compImports.cancel();
        }
    }

    @Override
    public String getId() {
        return ImportClass.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Import Fix";
    }

    public String getDescription() {
        return "Add Import Fix";
    }

    private synchronized void resume() {
        ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.resume called.");
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setComputeImports(ComputeImports computeImports) {
        this.compImports = computeImports;
    }

    public Pair<List<String>, List<String>> getCandidateFQNs(CompilationInfo compilationInfo, FileObject fileObject, String string, ErrorRule.Data<ImportCandidatesHolder> data) {
        Object object;
        Object object2;
        Pair<Object, Object> pair;
        ImportCandidatesHolder importCandidatesHolder = data.getData();
        if (importCandidatesHolder == null) {
            importCandidatesHolder = new ImportCandidatesHolder();
            data.setData(importCandidatesHolder);
        }
        if ((pair = importCandidatesHolder.getCandidates()) == null || pair.getA() == null || pair.getB() == null) {
            object2 = new HashMap();
            object = new ComputeImports();
            this.setComputeImports((ComputeImports)object);
            ComputeImports.Pair pair2 = object.computeCandidates(compilationInfo);
            this.setComputeImports(null);
            if (this.isCancelled() || pair2 == null) {
                ErrorHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.getCandidateFQNs cancelled, returning.");
                return null;
            }
            for (Object object3 : ((Map)pair2.a).keySet()) {
                Object object4 = new ArrayList();
                for (Object object5 : (List)((Map)pair2.a).get(object3)) {
                    object4.add(object5.getQualifiedName().toString());
                }
                object2.put(object3, object4);
            }
            HashMap hashMap = new HashMap();
            for (Object object4 : ((Map)pair2.b).keySet()) {
                ArrayList arrayList = new ArrayList();
                for (TypeElement typeElement : (List)((Map)pair2.b).get(object4)) {
                    arrayList.add(typeElement.getQualifiedName().toString());
                }
                hashMap.put(object4, arrayList);
            }
            pair = new Pair<Object, Object>(object2, hashMap);
            importCandidatesHolder.setCandidates(pair);
        }
        object2 = pair.getA().get(string);
        object = pair.getB().get(string);
        return new Pair<Object, ComputeImports>(object2, (ComputeImports)object);
    }

    static final class FixImport
    implements EnhancedFix {
        private FileObject file;
        private String fqn;
        private String sortText;
        private boolean isValid;

        public FixImport(FileObject fileObject, String string, String string2, boolean bl) {
            this.file = fileObject;
            this.fqn = string;
            this.sortText = string2;
            this.isValid = bl;
        }

        public String getText() {
            if (this.isValid) {
                return NbBundle.getMessage(ImportClass.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
            }
            return "<html><font color='#808080'><s>" + NbBundle.getMessage(ImportClass.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    if (workingCopy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(FixImport.this.fqn);
                    if (typeElement == null) {
                        Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", FixImport.this.fqn));
                        return;
                    }
                    CompilationUnitTree compilationUnitTree = JavaFixAllImports.addImports((CompilationUnitTree)workingCopy.getCompilationUnit(), Collections.singletonList(typeElement.getQualifiedName().toString()), (TreeMaker)workingCopy.getTreeMaker());
                    workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree);
                }
            };
            javaSource.runModificationTask((Task)task).commit();
            return null;
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FixImport) {
                return this.fqn.equals(((FixImport)object).fqn);
            }
            return false;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportCandidatesHolder {
        private Pair<Map<String, List<String>>, Map<String, List<String>>> candidates;

        public Pair<Map<String, List<String>>, Map<String, List<String>>> getCandidates() {
            return this.candidates;
        }

        public void setCandidates(Pair<Map<String, List<String>>, Map<String, List<String>>> pair) {
            this.candidates = pair;
        }
    }
}

