/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wsdl.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public class ImportViewNodes {
    private static Image badgedImage = ImportViewNodes.loadImage("org/netbeans/modules/xml/wsdl/ui/nodes/resources/error-badge.gif");

    private static boolean isAcceptableFile(FileObject fileObject) {
        return fileObject.getExt().equalsIgnoreCase("wsdl") || fileObject.getExt().equalsIgnoreCase("xsd");
    }

    private static Image loadImage(String string) {
        return new ImageIcon(ImportViewNodes.class.getClassLoader().getResource(string)).getImage();
    }

    public static final class DuplicateFileCookie
    implements Node.Cookie {
        private FileObject fileObject;
        private Project ownerProject;

        public DuplicateFileCookie(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public void setPrecedingOwnerProject(Project project) {
            this.ownerProject = project;
        }

        public Project getPrecedingOwnerProject() {
            return this.ownerProject;
        }

        public String getFileName() {
            return this.fileObject.getNameExt();
        }
    }

    static final class DepedentProjectFileNode
    extends FilterNode {
        private FileObject fileObject;
        private SourceGroup ownerGroup;
        private SourceGroup[] allGroups;
        private boolean fileExists;
        private ProxyLookup lookup;
        private CookieSet set;
        private DuplicateFileCookie dupCookie;

        public DepedentProjectFileNode(Node node, FileObject fileObject, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray) {
            super(node);
            this.fileObject = fileObject;
            this.ownerGroup = sourceGroup;
            this.allGroups = sourceGroupArray;
            this.set = new CookieSet();
            this.dupCookie = new DuplicateFileCookie(this.fileObject);
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            this.fileExists = this.isFileExistsInPreviousProject();
            if (this.fileExists) {
                this.set.add((Node.Cookie)this.dupCookie);
                return ImageUtilities.mergeImages((Image)image, (Image)badgedImage, (int)10, (int)10);
            }
            this.set.remove((Node.Cookie)this.dupCookie);
            return image;
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = this.set.getCookie(clazz);
            if (cookie != null) {
                return cookie;
            }
            return super.getCookie(clazz);
        }

        public String getShortDescription() {
            if (this.isFileExistsInPreviousProject()) {
                return "File already exists in a previous project.";
            }
            return super.getShortDescription();
        }

        private boolean isFileExistsInPreviousProject() {
            SourceGroup sourceGroup;
            boolean bl = false;
            for (int i = 0; i < this.allGroups.length && !(sourceGroup = this.allGroups[i]).equals(this.ownerGroup); ++i) {
                bl = this.isFileExistInRootFolder(sourceGroup.getRootFolder());
                if (!bl) continue;
                this.dupCookie.setPrecedingOwnerProject(FileOwnerQuery.getOwner((FileObject)sourceGroup.getRootFolder()));
                break;
            }
            return bl;
        }

        boolean isFileExistInRootFolder(FileObject fileObject) {
            FileObject fileObject2;
            boolean bl = false;
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length && !((fileObject2 = fileObjectArray[i]).isFolder() ? (bl = this.isFileExistInRootFolder(fileObject2)) : ImportViewNodes.isAcceptableFile(fileObject2) && (bl = this.isSameFileName(fileObject2))); ++i) {
            }
            return bl;
        }

        boolean isSameFileName(FileObject fileObject) {
            boolean bl = false;
            bl = fileObject.getNameExt().equals(this.fileObject.getNameExt());
            return bl;
        }
    }

    public static final class SourceGroupsChildren
    extends Children.Keys {
        private Project ownerProject;
        private SourceGroup[] allGroups;
        private SourceGroup ownerGroup;
        private FileObject fo;
        private FileObject mFileToExclude;

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray, Project project, FileObject fileObject2) {
            this.fo = fileObject;
            this.ownerGroup = sourceGroup;
            this.allGroups = sourceGroupArray;
            this.ownerProject = project;
            this.mFileToExclude = fileObject2;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            if (object instanceof Key) {
                fileObject = ((Key)object).folder;
                Node node = null;
                if (fileObject.isFolder()) {
                    node = DataFolder.findFolder((FileObject)fileObject).getNodeDelegate();
                    if (node != null) {
                        FilterNode filterNode = new FilterNode(node, (Children)new SourceGroupsChildren(fileObject, this.ownerGroup, this.allGroups, this.ownerProject, this.mFileToExclude));
                        return new Node[]{filterNode};
                    }
                    return new Node[0];
                }
                try {
                    node = DataFolder.find((FileObject)fileObject).getNodeDelegate();
                    if (node != null) {
                        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                        if (this.ownerProject.equals(project)) {
                            FilterNode filterNode = new FilterNode(node){

                                public Action getPreferredAction() {
                                    return null;
                                }
                            };
                            return new Node[]{filterNode};
                        }
                        DepedentProjectFileNode depedentProjectFileNode = new DepedentProjectFileNode(node, fileObject, this.ownerGroup, this.allGroups);
                        return new Node[]{depedentProjectFileNode};
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return new Node[0];
            }
            return new Node[0];
        }

        private Collection getKeys() {
            FileObject[] fileObjectArray = this.fo.getChildren();
            ArrayList<Key> arrayList = new ArrayList<Key>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].isFolder()) {
                    if (fileObjectArray[i].equals(this.mFileToExclude) || !VisibilityQuery.getDefault().isVisible(fileObjectArray[i]) || !ImportViewNodes.isAcceptableFile(fileObjectArray[i])) continue;
                    arrayList.add(new Key(fileObjectArray[i]));
                    continue;
                }
                arrayList.add(new Key(fileObjectArray[i]));
            }
            Collections.sort(arrayList, new KeyComparator());
            return arrayList;
        }

        private class KeyComparator
        implements Comparator,
        Serializable {
            private KeyComparator() {
            }

            public int compare(Object object, Object object2) {
                FileObject fileObject = ((Key)object).getFileObject();
                FileObject fileObject2 = ((Key)object2).getFileObject();
                return fileObject.getNameExt().compareToIgnoreCase(fileObject2.getNameExt());
            }
        }

        private class Key {
            private FileObject folder;

            private Key(FileObject fileObject) {
                this.folder = fileObject;
            }

            FileObject getFileObject() {
                return this.folder;
            }
        }
    }

    public static final class SourceGroups
    extends Children.Keys {
        private FileObject mFileToExclude;
        private Project ownerProject;
        private SourceGroup[] allGroups;

        public SourceGroups(Project project, SourceGroup[] sourceGroupArray, SourceGroup[] sourceGroupArray2, FileObject fileObject) {
            this.ownerProject = project;
            this.allGroups = new SourceGroup[sourceGroupArray.length + sourceGroupArray2.length];
            System.arraycopy(sourceGroupArray, 0, this.allGroups, 0, sourceGroupArray.length);
            System.arraycopy(sourceGroupArray2, 0, this.allGroups, sourceGroupArray.length, sourceGroupArray2.length);
            this.mFileToExclude = fileObject;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = null;
            if (object instanceof SourceGroup) {
                sourceGroup = (SourceGroup)object;
                fileObject = sourceGroup.getRootFolder();
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                GroupNode groupNode = new GroupNode(this.ownerProject, project, sourceGroup, this.allGroups, DataFolder.findFolder((FileObject)fileObject), this.mFileToExclude);
                return new Node[]{groupNode};
            }
            return new Node[0];
        }

        private Collection getKeys() {
            return Arrays.asList(this.allGroups);
        }
    }

    static final class GroupNode
    extends FilterNode
    implements PropertyChangeListener {
        final String GROUP_NAME_PATTERN = NbBundle.getMessage(ImportViewNodes.class, (String)"FMT_ImportViewNodes_GroupName");
        private Project project;
        private ProjectInformation pi;
        private SourceGroup group;

        public GroupNode(Project project, Project project2, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray, DataFolder dataFolder, FileObject fileObject) {
            super(dataFolder.getNodeDelegate(), (Children)new SourceGroupsChildren(dataFolder.getPrimaryFile(), sourceGroup, sourceGroupArray, project, fileObject), GroupNode.createLookup(project2, sourceGroup, dataFolder));
            this.project = project2;
            this.pi = ProjectUtils.getInformation((Project)this.project);
            this.group = sourceGroup;
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
            sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return MessageFormat.format(this.GROUP_NAME_PATTERN, this.group.getDisplayName(), this.pi.getDisplayName(), this.getOriginal().getDisplayName());
        }

        public String getShortDescription() {
            FileObject fileObject = this.group.getRootFolder();
            String string = FileUtil.getFileDisplayName((FileObject)fileObject);
            return NbBundle.getMessage(ImportViewNodes.class, (String)"HINT_group", (Object)string);
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(true);
            }
            Action[] actionArray = super.getActions(false);
            return actionArray;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("displayName".equals(string)) {
                this.fireDisplayNameChange(null, null);
            } else if ("name".equals(string)) {
                this.fireNameChange(null, null);
            } else if (!"icon".equals(string)) {
                if ("name".equals(string)) {
                    this.fireNameChange(null, null);
                } else if ("displayName".equals(string)) {
                    this.fireDisplayNameChange(null, null);
                } else if (!"icon".equals(string) && "rootFolder".equals(string)) {
                    this.fireNameChange(null, null);
                    this.fireDisplayNameChange(null, null);
                    this.fireShortDescriptionChange(null, null);
                }
            }
        }

        private static Lookup createLookup(Project project, SourceGroup sourceGroup, DataFolder dataFolder) {
            return new ProxyLookup(new Lookup[]{dataFolder.getNodeDelegate().getLookup(), project.getLookup()});
        }
    }
}

