/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.wizard.Command;
import org.netbeans.modules.xml.wsdl.ui.wizard.OperationGenerator;
import org.netbeans.modules.xml.wsdl.ui.wizard.PartnerLinkTypeGenerator;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortTypeGenerator
implements Command {
    private WSDLModel mModel;
    private PortType mPortType;
    private Operation mOperation;
    private Map mConfigurationMap;
    private List<Message> mNewMessageList = new ArrayList<Message>();
    private Collection<Import> mImports = new ArrayList<Import>();
    private ExtensibilityElement mPartnerLinkTypeElement = null;
    private Comment mComment;

    public PortTypeGenerator(WSDLModel wSDLModel, Map map) {
        this.mModel = wSDLModel;
        this.mConfigurationMap = map;
    }

    public PortType getPortType() {
        return this.mPortType;
    }

    public Operation getOperation() {
        return this.mOperation;
    }

    public List<Message> getNewMessages() {
        return this.mNewMessageList;
    }

    public Collection<Import> getImports() {
        return this.mImports;
    }

    public ExtensibilityElement getPartnerLinkType() {
        return this.mPartnerLinkTypeElement;
    }

    public Comment getComment() {
        return this.mComment;
    }

    @Override
    public void execute() {
        if (this.mModel != null) {
            String string = (String)this.mConfigurationMap.get("PORTTYPE_NAME");
            if (string == null) {
                return;
            }
            this.mPortType = this.mModel.getFactory().createPortType();
            this.mPortType.setName(string);
            this.mModel.getDefinitions().addPortType(this.mPortType);
            OperationGenerator operationGenerator = new OperationGenerator(this.mModel, this.mPortType, this.mConfigurationMap);
            operationGenerator.execute();
            this.mOperation = operationGenerator.getOperation();
            this.mNewMessageList = operationGenerator.getNewMessages();
            this.mImports.addAll(operationGenerator.getImports());
            Boolean bl = (Boolean)this.mConfigurationMap.get("AUTOGEN_PARTNERLINKTYPE");
            if (bl != null && !bl.booleanValue()) {
                return;
            }
            PartnerLinkTypeGenerator partnerLinkTypeGenerator = new PartnerLinkTypeGenerator(this.mPortType, this.mModel);
            partnerLinkTypeGenerator.execute();
            this.mPartnerLinkTypeElement = partnerLinkTypeGenerator.getPartnerLinkType();
            if (this.mPartnerLinkTypeElement != null) {
                this.mModel.getDefinitions().addExtensibilityElement(this.mPartnerLinkTypeElement);
                List list = this.mPartnerLinkTypeElement.getChildren();
                if (list != null && list.size() > 0) {
                    WSDLComponent wSDLComponent = (WSDLComponent)list.get(0);
                    Element element = this.mPartnerLinkTypeElement.getPeer();
                    Element element2 = wSDLComponent.getPeer();
                    this.mComment = this.mModel.getAccess().getDocumentRoot().createComment(NbBundle.getMessage(PortTypeGenerator.class, (String)"LBL_partnerLinkType_comment"));
                    this.mModel.getAccess().insertBefore((Node)element, (Node)this.mComment, (Node)element2, (DocumentModelAccess.NodeUpdater)((AbstractDocumentComponent)this.mPartnerLinkTypeElement));
                }
            }
        }
    }
}

