/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.FocusableWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFilterNode;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.openide.actions.ReorderAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWidget<T extends WSDLComponent>
extends Widget
implements ComponentListener,
PopupMenuProvider,
FocusableWidget,
PropertyChangeListener {
    private final T wsdlComponent;
    private final Lookup widgetLookup;
    private final InstanceContent lookupContent;
    private Node componentNode;
    private ComponentListener weakComponentListener;
    private final WSDLModel model;
    private Border currentBorder;
    private PropertyChangeListener weakModelListener;

    public AbstractWidget(Scene scene, T t, Lookup lookup) {
        super(scene);
        this.model = ((PartnerScene)scene).getModel();
        this.lookupContent = new InstanceContent();
        this.widgetLookup = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.lookupContent), lookup});
        this.wsdlComponent = t;
        if (t != null) {
            this.lookupContent.add(t);
            this.setWSDLComponent(t);
        }
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteComponent() {
        if (this.wsdlComponent == null) {
            return;
        }
        this.registerListener(null);
        try {
            if (this.model.startTransaction()) {
                this.model.removeChildComponent(this.wsdlComponent);
                this.postDeleteComponent((Model)this.model);
            }
        }
        finally {
            this.model.endTransaction();
        }
    }

    public WSDLModel getModel() {
        return this.model;
    }

    protected void postDeleteComponent(Model model) {
    }

    protected TopComponent findTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.getScene().getView());
    }

    public Lookup getLookup() {
        return this.widgetLookup;
    }

    protected InstanceContent getLookupContent() {
        return this.lookupContent;
    }

    public synchronized Node getNode() {
        if (this.componentNode == null) {
            if (this.wsdlComponent == null) {
                this.componentNode = new AbstractNode(Children.LEAF);
            } else {
                NodesFactory nodesFactory = NodesFactory.getInstance();
                this.componentNode = nodesFactory.create((WSDLComponent)this.wsdlComponent);
            }
            this.componentNode = this.getNodeFilter(this.componentNode);
        }
        return this.componentNode;
    }

    protected Node getNodeFilter(Node node) {
        return new WidgetFilterNode(node, this);
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        Node node = this.getNode();
        if (node != null && this.wsdlComponent != null) {
            ((PartnerScene)this.getScene()).userSelectionSuggested(Collections.singleton(this.wsdlComponent), false);
            TopComponent topComponent = this.findTopComponent();
            Lookup lookup = topComponent != null ? topComponent.getLookup() : Lookup.EMPTY;
            Action[] actionArray = node.getActions(true);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            Collections.addAll(arrayList, actionArray);
            this.updateActions(arrayList);
            actionArray = arrayList.toArray(new Action[arrayList.size()]);
            return Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
        }
        return null;
    }

    public T getWSDLComponent() {
        return this.wsdlComponent;
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (objectState2.isSelected()) {
            if (!objectState.isSelected()) {
                Object object;
                TopComponent topComponent = this.findTopComponent();
                if (topComponent != null) {
                    object = this.getNode();
                    topComponent.setActivatedNodes(new Node[]{object});
                }
                if (this.currentBorder == null) {
                    this.currentBorder = this.getBorder();
                    object = this.currentBorder.getInsets();
                    this.setBorder(BorderFactory.createEmptyBorder((int)object.top, (int)object.left, (int)object.bottom, (int)object.right));
                }
            }
        } else {
            if (this.currentBorder != null) {
                this.setBorder(this.currentBorder);
            }
            this.currentBorder = null;
        }
        this.revalidate(true);
        this.getScene().validate();
        this.repaint();
    }

    protected void registerListener(T t) {
        WSDLModel wSDLModel = null;
        if (this.wsdlComponent != null && (wSDLModel = this.wsdlComponent.getModel()) != null) {
            if (this.weakComponentListener != null) {
                wSDLModel.removeComponentListener(this.weakComponentListener);
                this.weakComponentListener = null;
            }
            if (this.weakModelListener != null) {
                wSDLModel.removePropertyChangeListener(this.weakModelListener);
                this.weakModelListener = null;
            }
        }
        if (t != null) {
            this.weakComponentListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)this, (Object)this.model);
            this.model.addComponentListener(this.weakComponentListener);
            this.weakModelListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.model);
            this.model.addPropertyChangeListener(this.weakModelListener);
        }
    }

    protected void setWSDLComponent(T t) {
        this.registerListener(t);
    }

    protected void paintChildren() {
        super.paintChildren();
        if (this.getState().isSelected()) {
            Graphics2D graphics2D = this.getGraphics();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(WidgetConstants.SELECTION_COLOR);
            graphics2D.draw(this.createSelectionShape());
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        }
    }

    protected Shape createSelectionShape() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle2D.Double(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
    }

    protected void updateActions(List<Action> list) {
        ListIterator<Action> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Action action = listIterator.next();
            if (!(action instanceof ReorderAction)) continue;
            listIterator.remove();
        }
    }

    public final void childrenAdded(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.getWSDLComponent()) {
            this.childrenAdded();
            this.getScene().validate();
        }
    }

    public final void childrenDeleted(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.getWSDLComponent()) {
            this.childrenDeleted();
            this.getScene().validate();
        }
    }

    public final void valueChanged(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.getWSDLComponent()) {
            this.updated();
            this.getScene().validate();
        }
    }

    public void childrenAdded() {
    }

    public void childrenDeleted() {
    }

    public void updated() {
    }

    @Override
    public boolean isFocusable() {
        AbstractWidget abstractWidget = this;
        while (abstractWidget.isVisible() && (abstractWidget = abstractWidget.getParentWidget()) != null) {
        }
        return abstractWidget == null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.registerListener(this.getWSDLComponent());
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.registerListener(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WidgetEditCookie widgetEditCookie = (WidgetEditCookie)AbstractWidget.this.getLookup().lookup(WidgetEditCookie.class);
                if (widgetEditCookie != null) {
                    widgetEditCookie.close();
                }
            }
        });
        this.componentNode = null;
    }
}

