/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.wsdl.bindingsupport.spi.ValidationInfo;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.view.AddBindingPanel;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.OperationPanel;
import org.netbeans.modules.xml.wsdl.ui.wizard.BindingGenerator;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;

public class BindingConfigurationDialogPanel
extends JPanel {
    private String mErrorMessage = null;
    private ServiceNameChangeListener serviceNameListener;
    private BindingNameChangeListener bindingNameListener;
    private ServicePortNameChangeListener servicePortNameListener;
    private final PortType mPortType;
    private AddBindingPanel addBindingPanel;
    private CommonMessagePanel commonMessagePanel;
    private WSDLModel mModel;
    private DialogDescriptor mDD;
    private boolean bindingNameChanged = false;
    private boolean portNameChanged = false;
    private String mBindingSubTypeError;

    public BindingConfigurationDialogPanel(WSDLModel wSDLModel) {
        this.mModel = wSDLModel;
        this.mPortType = null;
        this.initComponents();
        this.initGUI();
    }

    public BindingConfigurationDialogPanel(WSDLModel wSDLModel, PortType portType) {
        this.mModel = wSDLModel;
        this.mPortType = portType;
        this.initComponents();
        this.initGUI();
    }

    public boolean canAutoCreateServicePort() {
        return this.addBindingPanel.canAutoCreateServicePort();
    }

    public void setAutoCreateServicePort(boolean bl) {
        this.addBindingPanel.setAutoCreateServicePort(bl);
    }

    private void initComponents() {
        this.commonMessagePanel = new CommonMessagePanel();
        this.addBindingPanel = new AddBindingPanel();
        this.setName("BindingConfigurationDialogPanel");
        this.commonMessagePanel.setName("ShowErrorWarningPanel");
        this.addBindingPanel.setName("addBindingPanel");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBindingPanel, -1, 395, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.commonMessagePanel, -1, 385, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.addBindingPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.commonMessagePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initGUI() {
        this.bindingNameListener = new BindingNameChangeListener();
        this.serviceNameListener = new ServiceNameChangeListener();
        this.servicePortNameListener = new ServicePortNameChangeListener();
        this.addBindingPanel.setServiceNameDocumentListener(this.serviceNameListener);
        this.addBindingPanel.initPortTypeSelection(this.mModel, this.mPortType);
        NameGenerator nameGenerator = NameGenerator.getInstance();
        PortType portType = this.getPortType();
        String string = null;
        if (portType != null) {
            string = portType.getName();
        } else {
            this.mErrorMessage = NbBundle.getMessage(BindingConfigurationDialogPanel.class, (String)"ERR_MSG_NoPortTypeForCreatingNewBinding");
            this.addBindingPanel.setPanelEnabled(false);
            this.updateMessagePanel();
        }
        String string2 = null;
        string2 = string != null ? string + "Binding" : nameGenerator.generateUniqueBindingName(this.mModel);
        if (string2 != null && nameGenerator.isBindingExists(string2, this.mModel)) {
            string2 = nameGenerator.generateUniqueBindingName(string2, this.mModel);
        }
        this.setBindingName(string2);
        FileObject fileObject = (FileObject)this.mModel.getModelSource().getLookup().lookup(FileObject.class);
        String string3 = fileObject.getName() + "Service";
        Definitions definitions = this.mModel.getDefinitions();
        Collection collection = definitions.getServices();
        Service service = null;
        if (collection != null && !collection.isEmpty()) {
            service = (Service)collection.iterator().next();
            string3 = service.getName();
        }
        this.setServiceName(string3);
        String string4 = this.getBindingName() + "Port";
        if (service != null && nameGenerator.isServicePortExists(string4, service)) {
            string4 = nameGenerator.generateUniqueServicePortName(string4, service);
        }
        this.setServicePortName(string4);
        this.addBindingPanel.getPortTypeSelectionComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    NameGenerator nameGenerator;
                    String string;
                    PortType portType = BindingConfigurationDialogPanel.this.getPortType();
                    BindingConfigurationDialogPanel.this.validateAll();
                    boolean bl = false;
                    if (!BindingConfigurationDialogPanel.this.bindingNameChanged) {
                        string = portType.getName() + "Binding";
                        nameGenerator = NameGenerator.getInstance();
                        if (nameGenerator.isBindingExists(string, BindingConfigurationDialogPanel.this.mModel)) {
                            string = nameGenerator.generateUniqueBindingName(string, BindingConfigurationDialogPanel.this.mModel);
                        }
                        if (!BindingConfigurationDialogPanel.this.getBindingName().equals(string)) {
                            BindingConfigurationDialogPanel.this.setBindingName(string);
                            bl = true;
                        }
                    }
                    if (bl && !BindingConfigurationDialogPanel.this.portNameChanged) {
                        string = BindingConfigurationDialogPanel.this.getBindingName() + "Port";
                        nameGenerator = NameGenerator.getInstance();
                        Service service = (Service)BindingConfigurationDialogPanel.this.mModel.findComponentByName(BindingConfigurationDialogPanel.this.getServiceName(), Service.class);
                        if (service != null && nameGenerator.isServicePortExists(string, service)) {
                            string = nameGenerator.generateUniqueServicePortName(string, service);
                        }
                        if (!BindingConfigurationDialogPanel.this.getServicePortName().equals(string)) {
                            BindingConfigurationDialogPanel.this.setServicePortName(string);
                        }
                    }
                }
            }
        });
        BindingConfigurationListener bindingConfigurationListener = new BindingConfigurationListener();
        this.addBindingPanel.addPropertyChangeListener(bindingConfigurationListener);
        this.validateAll();
    }

    public String getBindingName() {
        return this.addBindingPanel.getBindingName();
    }

    public void setBindingName(String string) {
        this.addBindingPanel.getBindingNameTextField().getDocument().removeDocumentListener(this.bindingNameListener);
        this.addBindingPanel.setBindingName(string);
        this.addBindingPanel.getBindingNameTextField().getDocument().addDocumentListener(this.bindingNameListener);
    }

    public void setServiceName(String string) {
        this.addBindingPanel.setServiceName(string);
    }

    public void setServicePortName(String string) {
        this.addBindingPanel.getServicePortTextField().getDocument().removeDocumentListener(this.servicePortNameListener);
        this.addBindingPanel.setServicePortName(string);
        this.addBindingPanel.getServicePortTextField().getDocument().addDocumentListener(this.servicePortNameListener);
    }

    public LocalizedTemplateGroup getBindingType() {
        return this.addBindingPanel.getBindingType();
    }

    public LocalizedTemplate getBindingSubType() {
        return this.addBindingPanel.getBindingSubType();
    }

    public String getServiceName() {
        return this.addBindingPanel.getServiceName();
    }

    public String getServicePortName() {
        return this.addBindingPanel.getServicePortName();
    }

    public PortType getPortType() {
        if (this.mPortType != null) {
            return this.mPortType;
        }
        return this.addBindingPanel.getSelectedPortType();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.mDD = dialogDescriptor;
        this.updateMessagePanel();
    }

    private boolean isValidName(String string) {
        try {
            boolean bl = Utils.isValidNCName((String)string);
            this.mErrorMessage = !bl ? NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string) : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mErrorMessage == null;
    }

    private void validateAll() {
        boolean bl = this.validatePortType();
        if (!bl) {
            this.updateMessagePanel();
            return;
        }
        if (this.mBindingSubTypeError != null) {
            this.mErrorMessage = this.mBindingSubTypeError;
            this.updateMessagePanel();
            return;
        }
        boolean bl2 = this.isValidName(this.addBindingPanel.getBindingName());
        if (!bl2) {
            this.updateMessagePanel();
            return;
        }
        boolean bl3 = this.isBindingExists();
        if (bl3) {
            this.updateMessagePanel();
            return;
        }
        if (this.canAutoCreateServicePort()) {
            String string;
            boolean bl4 = this.isValidName(this.addBindingPanel.getServiceName());
            if (!bl4) {
                this.updateMessagePanel();
                return;
            }
            boolean bl5 = this.isValidName(this.addBindingPanel.getServicePortName());
            if (!bl5) {
                this.updateMessagePanel();
                return;
            }
            String string2 = this.addBindingPanel.getServiceName();
            boolean bl6 = this.isServicePortExists(string2, string = this.addBindingPanel.getServicePortName());
            if (bl6) {
                this.updateMessagePanel();
                return;
            }
        }
        this.mErrorMessage = null;
        this.updateMessagePanel();
    }

    private boolean validatePortType() {
        HashSet<String> hashSet = new HashSet<String>();
        PortType portType = this.getPortType();
        if (portType == null) {
            return false;
        }
        for (Operation operation : portType.getOperations()) {
            String string = operation.getName();
            String string2 = "";
            try {
                string2 = operation.getInput().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "";
            try {
                string3 = operation.getOutput().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = string + string2 + string3;
            if (hashSet.contains(string4)) {
                this.mErrorMessage = NbBundle.getMessage(BindingConfigurationDialogPanel.class, (String)"ERR_MSG_ImproperlyOverloadedOperations");
                return false;
            }
            hashSet.add(string4);
        }
        return true;
    }

    private boolean isBindingExists() {
        boolean bl = false;
        String string = this.addBindingPanel.getBindingName();
        Binding binding = (Binding)this.mModel.findComponentByName(string, Binding.class);
        if (binding != null) {
            this.mErrorMessage = NbBundle.getMessage(BindingConfigurationDialogPanel.class, (String)"ERR_MSG_BindingAlreadyExists", (Object)string);
            bl = true;
        }
        return bl;
    }

    public boolean isServicePortExists(String string, String string2) {
        Service service;
        boolean bl = false;
        if (string != null && string2 != null && (service = (Service)this.mModel.findComponentByName(string, Service.class)) != null && (bl = NameGenerator.getInstance().isServicePortExists(this.getServicePortName(), service))) {
            this.mErrorMessage = NbBundle.getMessage(BindingConfigurationDialogPanel.class, (String)"ERR_MSG_ServicePortAlreadyExists", (Object)this.getServicePortName());
        }
        return bl;
    }

    private void updateMessagePanel() {
        if (this.mErrorMessage != null) {
            this.commonMessagePanel.setErrorMessage(this.mErrorMessage);
            if (this.mDD != null) {
                this.mDD.setValid(false);
            }
        } else {
            this.commonMessagePanel.setMessage("");
            if (this.mDD != null) {
                this.mDD.setValid(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBindingSubType(LocalizedTemplate localizedTemplate) {
        if (localizedTemplate != null) {
            String string = this.getBindingName();
            LocalizedTemplateGroup localizedTemplateGroup = this.getBindingType();
            String string2 = this.getServiceName();
            String string3 = this.getServicePortName();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("BINDING_NAME", string);
            hashMap.put("BINDING_TYPE", localizedTemplateGroup);
            hashMap.put("BINDING_SUBTYPE", localizedTemplate);
            hashMap.put("SERVICE_NAME", string2);
            hashMap.put("SERVICEPORT_NAME", string3);
            hashMap.put("AUTO_CREATE_SERVICEPORT", this.canAutoCreateServicePort());
            try {
                this.mModel.startTransaction();
                BindingGenerator bindingGenerator = new BindingGenerator(this.mModel, this.getPortType(), hashMap);
                bindingGenerator.execute();
                Binding binding = bindingGenerator.getBinding();
                Port port = bindingGenerator.getPort();
                if (binding != null) {
                    List list;
                    String string4 = this.mModel.getDefinitions().getTargetNamespace();
                    ArrayList arrayList = new ArrayList();
                    List list2 = localizedTemplate.getMProvider().validate(binding);
                    if (list2 != null) {
                        arrayList.addAll(list2);
                    }
                    if (port != null && (list = localizedTemplate.getMProvider().validate(port)) != null) {
                        arrayList.addAll(list);
                    }
                    if (arrayList.size() > 0) {
                        list = (ValidationInfo)arrayList.get(0);
                        this.mBindingSubTypeError = list.getDescription();
                        IOProvider.getDefault().getStdOut().print(this.mBindingSubTypeError);
                        this.mErrorMessage = this.mBindingSubTypeError;
                        this.updateMessagePanel();
                    } else {
                        this.mErrorMessage = this.mBindingSubTypeError = null;
                        this.updateMessagePanel();
                        localizedTemplate.getMProvider().postProcess(string4, binding);
                        if (port != null) {
                            localizedTemplate.getMProvider().postProcess(string4, port);
                        }
                    }
                }
            }
            finally {
                if (this.mModel.isIntransaction()) {
                    this.mModel.rollbackTransaction();
                }
            }
        }
    }

    class BindingConfigurationListener
    implements PropertyChangeListener {
        BindingConfigurationListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("PROP_BINDING_SUBTYPE".equals(string)) {
                LocalizedTemplate localizedTemplate = (LocalizedTemplate)propertyChangeEvent.getNewValue();
                BindingConfigurationDialogPanel.this.processBindingSubType(localizedTemplate);
            } else if ("PROP_BINDING_TYPE".equals(string)) {
                BindingConfigurationDialogPanel.this.processBindingSubType(BindingConfigurationDialogPanel.this.getBindingSubType());
            } else if ("PROP_AUTOCREATE_SERVICE".equals(string)) {
                BindingConfigurationDialogPanel.this.validateAll();
            }
        }
    }

    class ServicePortNameChangeListener
    implements DocumentListener {
        ServicePortNameChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.portChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.portChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.portChanged();
        }

        private void portChanged() {
            BindingConfigurationDialogPanel.this.portNameChanged = true;
            BindingConfigurationDialogPanel.this.validateAll();
        }
    }

    class ServiceNameChangeListener
    implements DocumentListener {
        ServiceNameChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.serviceChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.serviceChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.serviceChanged();
        }

        private void serviceChanged() {
            BindingConfigurationDialogPanel.this.validateAll();
        }
    }

    class BindingNameChangeListener
    implements DocumentListener {
        BindingNameChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.bindingChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.bindingChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.bindingChanged();
        }

        private void bindingChanged() {
            BindingConfigurationDialogPanel.this.bindingNameChanged = true;
            BindingConfigurationDialogPanel.this.validateAll();
        }
    }
}

