/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLUtils {
    public static SAXParseException parse(InputSource inputSource) throws SAXException, ParserConfigurationException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = null;
            XMLReader xMLReader = null;
            sAXParserFactory.setNamespaceAware(true);
            sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.parse(inputSource);
            SAXParseException sAXParseException = errorHandler.getError();
            if (sAXParseException != null) {
                return sAXParseException;
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw parserConfigurationException;
        }
        return null;
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }
}

