/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDesignMultiViewDesc;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLEditorSupport;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLMultiViewFactory;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLTreeViewMultiViewElement;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.GraphView;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.palette.WSDLPaletteFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.openide.actions.SaveAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class WSDLDesignMultiViewElement
extends TopComponent
implements MultiViewElement,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = -655912409997381426L;
    private static final String ACTIVATED_NODES = "activatedNodes";
    private WSDLDataObject wsdlDataObject;
    private ExplorerManager explorerManager;
    private GraphView graphComponent;
    private transient MultiViewElementCallback multiViewObserver;
    private transient JLabel errorLabel = new JLabel();
    private transient JToolBar mToolbar;
    private ActivatedNodesMediator nodesMediator;
    private CookieProxyLookup cpl;
    private WSDLModel wsdlModel;

    public WSDLDesignMultiViewElement() {
    }

    public WSDLDesignMultiViewElement(WSDLDataObject wSDLDataObject) {
        this.wsdlDataObject = wSDLDataObject;
        this.initialize();
    }

    private void initialize() {
        this.setFocusable(true);
        this.explorerManager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        SaveAction saveAction = (SaveAction)SystemAction.get(SaveAction.class);
        actionMap.put("save", (Action)saveAction);
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = (KeyStroke)saveAction.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("control S");
        }
        inputMap.put(keyStroke, "save");
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                Component component = resultItem.getComponents();
                WSDLDesignMultiViewElement.this.graphComponent.showComponent(component);
            }
        };
        Node node = this.wsdlDataObject.getNodeDelegate();
        this.nodesMediator = new ActivatedNodesMediator(node);
        this.nodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        this.cpl = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{actionMap, this.wsdlDataObject, showCookie, WSDLPaletteFactory.getPalette()}), this.nodesMediator.getLookup(), node.getLookup()}, node);
        this.associateLookup((Lookup)this.cpl);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.nodesMediator);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.cpl);
        this.setLayout(new BorderLayout());
    }

    private WSDLModel getWSDLModel() {
        if (this.wsdlModel != null) {
            return this.wsdlModel;
        }
        this.wsdlModel = this.wsdlDataObject.getWSDLEditorSupport().getModel();
        this.wsdlModel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.wsdlModel));
        return this.wsdlModel;
    }

    private void cleanup() {
        try {
            this.explorerManager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.nodesMediator);
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.cpl);
        this.nodesMediator.setExplorerManager(null);
        this.nodesMediator = null;
        this.cpl = null;
        if (this.mToolbar != null) {
            this.mToolbar.removeAll();
        }
        this.mToolbar = null;
        this.removeAll();
        this.graphComponent = null;
        this.wsdlModel = null;
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        this.explorerManager = null;
        this.multiViewObserver = null;
        this.setActivatedNodes(new Node[0]);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Model.State state;
        if ("state".equals(propertyChangeEvent.getPropertyName()) && (state = (Model.State)propertyChangeEvent.getNewValue()) != null) {
            this.initUI();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public int getPersistenceType() {
        return 0;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        if (!WSDLEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public UndoRedo getUndoRedo() {
        return this.wsdlDataObject.getWSDLEditorSupport().getUndoManager();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    public void componentOpened() {
        super.componentOpened();
        this.initUI();
    }

    public void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-designview");
        if (this.graphComponent != null) {
            this.graphComponent.requestFocusInWindow();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        if (this.explorerManager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        }
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-designview");
    }

    public void componentShowing() {
        super.componentShowing();
    }

    protected String preferredID() {
        return "WSDLDesignMultiViewElementTC";
    }

    private void initUI() {
        WSDLModel wSDLModel = this.getWSDLModel();
        if (this.mToolbar != null) {
            this.mToolbar.removeAll();
            this.mToolbar = null;
        }
        if (wSDLModel != null && wSDLModel.getState() == Model.State.VALID) {
            if (this.graphComponent == null) {
                this.graphComponent = new GraphView(wSDLModel);
            }
            this.removeAll();
            this.add(this.graphComponent, "Center");
            return;
        }
        String string = null;
        if (wSDLModel == null || wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
            string = NbBundle.getMessage(WSDLTreeViewMultiViewElement.class, (String)"MSG_NotWellformedWsdl");
        }
        this.removeAll();
        this.errorLabel.setText("<" + string + ">");
        this.errorLabel.setHorizontalAlignment(0);
        this.errorLabel.setHorizontalTextPosition(0);
        this.errorLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.errorLabel.setBackground(color != null ? color : Color.white);
        this.errorLabel.setOpaque(true);
        this.add(this.errorLabel, "Center");
    }

    public JComponent getToolbarRepresentation() {
        if (this.mToolbar == null) {
            this.mToolbar = new JToolBar();
            this.mToolbar.setFloatable(false);
            WSDLModel wSDLModel = this.getWSDLModel();
            if (wSDLModel != null && wSDLModel.getState() == Model.State.VALID) {
                this.mToolbar.addSeparator();
                if (this.graphComponent != null) {
                    this.graphComponent.addToolbarActions(this.mToolbar);
                }
                this.mToolbar.addSeparator();
                this.mToolbar.add((Action)new ValidateAction((Model)wSDLModel));
            }
        }
        return this.mToolbar;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void requestActive() {
        super.requestActive();
        if (this.graphComponent != null) {
            this.graphComponent.requestFocus();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WSDLDesignMultiViewDesc.class);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof WSDLDataObject) {
            this.wsdlDataObject = (WSDLDataObject)((Object)object);
            this.initialize();
            if (this.graphComponent == null) {
                this.initUI();
            }
        }
        if (this.graphComponent != null) {
            try {
                if (!objectInput.readBoolean()) {
                    this.graphComponent.setCollaborationsVisible(false);
                }
                if (!objectInput.readBoolean()) {
                    this.graphComponent.setMessagesVisible(false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.wsdlDataObject);
        boolean bl = false;
        boolean bl2 = true;
        if (this.graphComponent != null) {
            bl = this.graphComponent.isCollaborationsShowing();
            bl2 = this.graphComponent.isMessagesShowing();
        }
        objectOutput.writeBoolean(bl);
        objectOutput.writeBoolean(bl2);
    }
}

